/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.imap;

import java.util.Vector;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPMessage;
import macromedia.externals.com.sun.mail_1_4_7.imap.Utility;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.MessageSet;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.UIDSet;
import macromedia.externals.javax.mail_1_4_7.Message;

public final class Utility {
    private Utility() {
    }

    public static MessageSet[] toMessageSet(Message[] messageArray, Condition condition) {
        Vector<MessageSet> vector = new Vector<MessageSet>(1);
        for (int i2 = 0; i2 < messageArray.length; ++i2) {
            IMAPMessage iMAPMessage = (IMAPMessage)messageArray[i2];
            if (iMAPMessage.isExpunged()) continue;
            int n2 = iMAPMessage.getSequenceNumber();
            if (condition != null && !condition.test(iMAPMessage)) continue;
            MessageSet messageSet = new MessageSet();
            messageSet.start = n2;
            ++i2;
            while (i2 < messageArray.length) {
                iMAPMessage = (IMAPMessage)messageArray[i2];
                if (!iMAPMessage.isExpunged()) {
                    int n3 = iMAPMessage.getSequenceNumber();
                    if (condition == null || condition.test(iMAPMessage)) {
                        if (n3 == n2 + 1) {
                            n2 = n3;
                        } else {
                            --i2;
                            break;
                        }
                    }
                }
                ++i2;
            }
            messageSet.end = n2;
            vector.addElement(messageSet);
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new MessageSet[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static UIDSet[] toUIDSet(Message[] messageArray) {
        Vector<UIDSet> vector = new Vector<UIDSet>(1);
        for (int i2 = 0; i2 < messageArray.length; ++i2) {
            IMAPMessage iMAPMessage = (IMAPMessage)messageArray[i2];
            if (iMAPMessage.isExpunged()) continue;
            long l2 = iMAPMessage.getUID();
            UIDSet uIDSet = new UIDSet();
            uIDSet.start = l2;
            ++i2;
            while (i2 < messageArray.length) {
                iMAPMessage = (IMAPMessage)messageArray[i2];
                if (!iMAPMessage.isExpunged()) {
                    long l3 = iMAPMessage.getUID();
                    if (l3 == l2 + 1L) {
                        l2 = l3;
                    } else {
                        --i2;
                        break;
                    }
                }
                ++i2;
            }
            uIDSet.end = l2;
            vector.addElement(uIDSet);
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new UIDSet[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

