/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.imap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPFolder;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPMessage;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPStore;
import macromedia.externals.com.sun.mail_1_4_7.util.MailLogger;
import macromedia.externals.javax.mail_1_4_7.Message;

/*
 * Exception performing whole class analysis ignored.
 */
public class MessageCache {
    private IMAPMessage[] messages;
    private int[] seqnums;
    private int size;
    private IMAPFolder folder;
    private MailLogger logger;
    private static final int SLOP = 64;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$mail$imap$MessageCache;

    MessageCache(IMAPFolder iMAPFolder, IMAPStore iMAPStore, int n2) {
        this.folder = iMAPFolder;
        this.logger = iMAPFolder.logger.getSubLogger("messagecache", "DEBUG IMAP MC", iMAPStore.getMessageCacheDebug());
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config(new StringBuffer().append("create cache of size ").append(n2).toString());
        }
        this.ensureCapacity(n2, 1);
    }

    MessageCache(int n2, boolean bl2) {
        this.folder = null;
        this.logger = new MailLogger(this.getClass(), "messagecache", "DEBUG IMAP MC", bl2, System.out);
        if (this.logger.isLoggable(Level.CONFIG)) {
            this.logger.config(new StringBuffer().append("create DEBUG cache of size ").append(n2).toString());
        }
        this.ensureCapacity(n2, 1);
    }

    public int size() {
        return this.size;
    }

    public IMAPMessage getMessage(int n2) {
        if (n2 < 1 || n2 > this.size) {
            throw new ArrayIndexOutOfBoundsException(new StringBuffer().append("message number (").append(n2).append(") out of bounds (").append(this.size).append(")").toString());
        }
        IMAPMessage iMAPMessage = this.messages[n2 - 1];
        if (iMAPMessage == null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(new StringBuffer().append("create message number ").append(n2).toString());
            }
            this.messages[n2 - 1] = iMAPMessage = this.folder.newIMAPMessage(n2);
            if (this.seqnumOf(n2) <= 0) {
                this.logger.fine("it's expunged!");
                iMAPMessage.setExpunged(true);
            }
        }
        return iMAPMessage;
    }

    public IMAPMessage getMessageBySeqnum(int n2) {
        int n3 = this.msgnumOf(n2);
        if (n3 < 0) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(new StringBuffer().append("no message seqnum ").append(n2).toString());
            }
            return null;
        }
        return this.getMessage(n3);
    }

    public void expungeMessage(int n2) {
        int n3 = this.msgnumOf(n2);
        if (n3 < 0) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(new StringBuffer().append("expunge no seqnum ").append(n2).toString());
            }
            return;
        }
        IMAPMessage iMAPMessage = this.messages[n3 - 1];
        if (iMAPMessage != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(new StringBuffer().append("expunge existing ").append(n3).toString());
            }
            iMAPMessage.setExpunged(true);
        }
        if (this.seqnums == null) {
            int n4;
            this.logger.fine("create seqnums array");
            this.seqnums = new int[this.messages.length];
            for (n4 = 1; n4 < n3; ++n4) {
                this.seqnums[n4 - 1] = n4;
            }
            this.seqnums[n3 - 1] = 0;
            for (n4 = n3 + 1; n4 <= this.seqnums.length; ++n4) {
                this.seqnums[n4 - 1] = n4 - 1;
            }
        } else {
            this.seqnums[n3 - 1] = 0;
            for (int i2 = n3 + 1; i2 <= this.seqnums.length; ++i2) {
                if (!$assertionsDisabled && this.seqnums[i2 - 1] == 1) {
                    throw new AssertionError();
                }
                if (this.seqnums[i2 - 1] <= 0) continue;
                int n5 = i2 - 1;
                this.seqnums[n5] = this.seqnums[n5] - 1;
            }
        }
    }

    public IMAPMessage[] removeExpungedMessages() {
        IMAPMessage[] iMAPMessageArray;
        int n2;
        this.logger.fine("remove expunged messages");
        ArrayList<IMAPMessage[]> arrayList = new ArrayList<IMAPMessage[]>();
        int n3 = 1;
        for (n2 = 1; n2 <= this.size; ++n2) {
            if (this.seqnumOf(n2) <= 0) {
                iMAPMessageArray = this.getMessage(n2);
                arrayList.add(iMAPMessageArray);
                continue;
            }
            if (n3 != n2) {
                this.messages[n3 - 1] = this.messages[n2 - 1];
                if (this.messages[n3 - 1] != null) {
                    this.messages[n3 - 1].setMessageNumber(n3);
                }
            }
            ++n3;
        }
        this.seqnums = null;
        this.shrink(n3, n2);
        iMAPMessageArray = new IMAPMessage[arrayList.size()];
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(new StringBuffer().append("return ").append(iMAPMessageArray.length).toString());
        }
        arrayList.toArray(iMAPMessageArray);
        return iMAPMessageArray;
    }

    public IMAPMessage[] removeExpungedMessages(Message[] messageArray) {
        IMAPMessage iMAPMessage;
        int n2;
        this.logger.fine("remove expunged messages");
        ArrayList<IMAPMessage> arrayList = new ArrayList<IMAPMessage>();
        int[] nArray = new int[messageArray.length];
        for (n2 = 0; n2 < messageArray.length; ++n2) {
            nArray[n2] = messageArray[n2].getMessageNumber();
        }
        Arrays.sort(nArray);
        int n3 = 1;
        int n4 = 0;
        boolean bl2 = false;
        for (n2 = 1; n2 <= this.size; ++n2) {
            if (n4 < nArray.length && n2 == nArray[n4] && this.seqnumOf(n2) <= 0) {
                iMAPMessage = this.getMessage(n2);
                arrayList.add(iMAPMessage);
                while (n4 < nArray.length && nArray[n4] <= n2) {
                    ++n4;
                }
                continue;
            }
            if (n3 != n2) {
                this.messages[n3 - 1] = this.messages[n2 - 1];
                if (this.messages[n3 - 1] != null) {
                    this.messages[n3 - 1].setMessageNumber(n3);
                }
                if (this.seqnums != null) {
                    this.seqnums[n3 - 1] = this.seqnums[n2 - 1];
                }
            }
            if (this.seqnums != null && this.seqnums[n3 - 1] != n3) {
                bl2 = true;
            }
            ++n3;
        }
        if (!bl2) {
            this.seqnums = null;
        }
        this.shrink(n3, n2);
        iMAPMessage = new IMAPMessage[arrayList.size()];
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(new StringBuffer().append("return ").append(((IMAPMessage)iMAPMessage).length).toString());
        }
        arrayList.toArray((T[])iMAPMessage);
        return iMAPMessage;
    }

    private void shrink(int n2, int n3) {
        this.size = n2 - 1;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(new StringBuffer().append("size now ").append(this.size).toString());
        }
        if (this.size == 0) {
            this.messages = null;
            this.seqnums = null;
        } else if (this.size > 64 && this.size < this.messages.length / 2) {
            this.logger.fine("reallocate array");
            IMAPMessage[] iMAPMessageArray = new IMAPMessage[this.size + 64];
            System.arraycopy(this.messages, 0, iMAPMessageArray, 0, this.size);
            this.messages = iMAPMessageArray;
            if (this.seqnums != null) {
                int[] nArray = new int[this.size + 64];
                System.arraycopy(this.seqnums, 0, nArray, 0, this.size);
                this.seqnums = nArray;
            }
        } else {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(new StringBuffer().append("clean ").append(n2).append(" to ").append(n3).toString());
            }
            for (int i2 = n2; i2 < n3; ++i2) {
                this.messages[i2 - 1] = null;
                if (this.seqnums == null) continue;
                this.seqnums[i2 - 1] = 0;
            }
        }
    }

    public void addMessages(int n2, int n3) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(new StringBuffer().append("add ").append(n2).append(" messages").toString());
        }
        this.ensureCapacity(this.size + n2, n3);
    }

    private void ensureCapacity(int n2, int n3) {
        block6: {
            block7: {
                block5: {
                    if (this.messages != null) break block5;
                    this.messages = new IMAPMessage[n2 + 64];
                    break block6;
                }
                if (this.messages.length >= n2) break block7;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(new StringBuffer().append("expand capacity to ").append(n2).toString());
                }
                IMAPMessage[] iMAPMessageArray = new IMAPMessage[n2 + 64];
                System.arraycopy(this.messages, 0, iMAPMessageArray, 0, this.messages.length);
                this.messages = iMAPMessageArray;
                if (this.seqnums == null) break block6;
                int[] nArray = new int[n2 + 64];
                System.arraycopy(this.seqnums, 0, nArray, 0, this.seqnums.length);
                for (int i2 = this.size; i2 < nArray.length; ++i2) {
                    nArray[i2] = n3++;
                }
                this.seqnums = nArray;
                if (!this.logger.isLoggable(Level.FINE)) break block6;
                this.logger.fine(new StringBuffer().append("message ").append(n2).append(" has sequence number ").append(this.seqnums[n2 - 1]).toString());
                break block6;
            }
            if (n2 < this.size) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine(new StringBuffer().append("shrink capacity to ").append(n2).toString());
                }
                for (int i3 = n2 + 1; i3 <= this.size; ++i3) {
                    this.messages[i3 - 1] = null;
                    if (this.seqnums == null) continue;
                    this.seqnums[i3 - 1] = -1;
                }
            }
        }
        this.size = n2;
    }

    public int seqnumOf(int n2) {
        if (this.seqnums == null) {
            return n2;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(new StringBuffer().append("msgnum ").append(n2).append(" is seqnum ").append(this.seqnums[n2 - 1]).toString());
        }
        return this.seqnums[n2 - 1];
    }

    private int msgnumOf(int n2) {
        if (this.seqnums == null) {
            return n2;
        }
        if (n2 < 1) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(new StringBuffer().append("bad seqnum ").append(n2).toString());
            }
            return -1;
        }
        for (int i2 = n2; i2 <= this.size; ++i2) {
            if (this.seqnums[i2 - 1] == n2) {
                return i2;
            }
            if (this.seqnums[i2 - 1] > n2) break;
        }
        return -1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$mail$imap$MessageCache == null ? (class$com$sun$mail$imap$MessageCache = MessageCache.class$((String)"macromedia.externals.com.sun.mail_1_4_7.imap.MessageCache")) : class$com$sun$mail$imap$MessageCache).desiredAssertionStatus();
    }
}

