/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.imap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import macromedia.externals.com.sun.mail_1_4_7.iap.ConnectionException;
import macromedia.externals.com.sun.mail_1_4_7.iap.ProtocolException;
import macromedia.externals.com.sun.mail_1_4_7.iap.Response;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPFolder;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPInputStream;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPMultipartDataSource;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPNestedMessage;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPStore;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.BODY;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.BODYSTRUCTURE;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.ENVELOPE;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.FetchItem;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.FetchResponse;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.IMAPProtocol;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.INTERNALDATE;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.Item;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.RFC822DATA;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.RFC822SIZE;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.UID;
import macromedia.externals.com.sun.mail_1_4_7.util.ReadableMime;
import macromedia.externals.javax.mail_1_4_7.Address;
import macromedia.externals.javax.mail_1_4_7.Flags;
import macromedia.externals.javax.mail_1_4_7.Folder;
import macromedia.externals.javax.mail_1_4_7.FolderClosedException;
import macromedia.externals.javax.mail_1_4_7.Header;
import macromedia.externals.javax.mail_1_4_7.IllegalWriteException;
import macromedia.externals.javax.mail_1_4_7.Message;
import macromedia.externals.javax.mail_1_4_7.MessageRemovedException;
import macromedia.externals.javax.mail_1_4_7.MessagingException;
import macromedia.externals.javax.mail_1_4_7.Session;
import macromedia.externals.javax.mail_1_4_7.internet.ContentType;
import macromedia.externals.javax.mail_1_4_7.internet.InternetAddress;
import macromedia.externals.javax.mail_1_4_7.internet.InternetHeaders;
import macromedia.externals.javax.mail_1_4_7.internet.MimeMessage;
import macromedia.externals.javax.mail_1_4_7.internet.MimePart;
import macromedia.externals.javax.mail_1_4_7.internet.MimeUtility;

public class IMAPMessage
extends MimeMessage
implements ReadableMime {
    protected BODYSTRUCTURE bs;
    protected ENVELOPE envelope;
    protected Map items;
    private Date receivedDate;
    private int size = -1;
    private boolean peek;
    private long uid = -1L;
    protected String sectionId;
    private String type;
    private String subject;
    private String description;
    private volatile boolean headersLoaded = false;
    private Hashtable loadedHeaders = new Hashtable(1);
    static final String EnvelopeCmd = "ENVELOPE INTERNALDATE RFC822.SIZE";

    protected IMAPMessage(IMAPFolder iMAPFolder, int n2) {
        super((Folder)iMAPFolder, n2);
        this.flags = null;
    }

    protected IMAPMessage(Session session) {
        super(session);
    }

    protected IMAPProtocol getProtocol() throws ProtocolException, FolderClosedException {
        ((IMAPFolder)this.folder).waitIfIdle();
        IMAPProtocol iMAPProtocol = ((IMAPFolder)this.folder).protocol;
        if (iMAPProtocol == null) {
            throw new FolderClosedException(this.folder);
        }
        return iMAPProtocol;
    }

    protected boolean isREV1() throws FolderClosedException {
        IMAPProtocol iMAPProtocol = ((IMAPFolder)this.folder).protocol;
        if (iMAPProtocol == null) {
            throw new FolderClosedException(this.folder);
        }
        return iMAPProtocol.isREV1();
    }

    protected Object getMessageCacheLock() {
        return ((IMAPFolder)this.folder).messageCacheLock;
    }

    protected int getSequenceNumber() {
        return ((IMAPFolder)this.folder).messageCache.seqnumOf(this.getMessageNumber());
    }

    protected void setMessageNumber(int n2) {
        super.setMessageNumber(n2);
    }

    protected long getUID() {
        return this.uid;
    }

    protected void setUID(long l2) {
        this.uid = l2;
    }

    protected void setExpunged(boolean bl2) {
        super.setExpunged(bl2);
    }

    protected void checkExpunged() throws MessageRemovedException {
        if (this.expunged) {
            throw new MessageRemovedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forceCheckExpunged() throws MessageRemovedException, FolderClosedException {
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                this.getProtocol().noop();
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                // empty catch block
            }
        }
        if (this.expunged) {
            throw new MessageRemovedException();
        }
    }

    protected int getFetchBlockSize() {
        return ((IMAPStore)this.folder.getStore()).getFetchBlockSize();
    }

    protected boolean ignoreBodyStructureSize() {
        return ((IMAPStore)this.folder.getStore()).ignoreBodyStructureSize();
    }

    public Address[] getFrom() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        InternetAddress[] internetAddressArray = this.envelope.from;
        if (internetAddressArray == null || internetAddressArray.length == 0) {
            internetAddressArray = this.envelope.sender;
        }
        return this.aaclone(internetAddressArray);
    }

    public void setFrom(Address address) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void addFrom(Address[] addressArray) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public Address getSender() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        if (this.envelope.sender != null) {
            return this.envelope.sender[0];
        }
        return null;
    }

    public void setSender(Address address) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public Address[] getRecipients(Message.RecipientType recipientType) throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        if (recipientType == Message.RecipientType.TO) {
            return this.aaclone(this.envelope.to);
        }
        if (recipientType == Message.RecipientType.CC) {
            return this.aaclone(this.envelope.cc);
        }
        if (recipientType == Message.RecipientType.BCC) {
            return this.aaclone(this.envelope.bcc);
        }
        return super.getRecipients(recipientType);
    }

    public void setRecipients(Message.RecipientType recipientType, Address[] addressArray) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void addRecipients(Message.RecipientType recipientType, Address[] addressArray) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public Address[] getReplyTo() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        if (this.envelope.replyTo == null || this.envelope.replyTo.length == 0) {
            return this.getFrom();
        }
        return this.aaclone(this.envelope.replyTo);
    }

    public void setReplyTo(Address[] addressArray) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public String getSubject() throws MessagingException {
        this.checkExpunged();
        if (this.subject != null) {
            return this.subject;
        }
        this.loadEnvelope();
        if (this.envelope.subject == null) {
            return null;
        }
        try {
            this.subject = MimeUtility.decodeText((String)MimeUtility.unfold((String)this.envelope.subject));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.subject = this.envelope.subject;
        }
        return this.subject;
    }

    public void setSubject(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public Date getSentDate() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        if (this.envelope.date == null) {
            return null;
        }
        return new Date(this.envelope.date.getTime());
    }

    public void setSentDate(Date date) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public Date getReceivedDate() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        if (this.receivedDate == null) {
            return null;
        }
        return new Date(this.receivedDate.getTime());
    }

    public int getSize() throws MessagingException {
        this.checkExpunged();
        if (this.size == -1) {
            this.loadEnvelope();
        }
        return this.size;
    }

    public int getLineCount() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.lines;
    }

    public String[] getContentLanguage() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        if (this.bs.language != null) {
            return (String[])this.bs.language.clone();
        }
        return null;
    }

    public void setContentLanguage(String[] stringArray) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public String getInReplyTo() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.envelope.inReplyTo;
    }

    public synchronized String getContentType() throws MessagingException {
        this.checkExpunged();
        if (this.type == null) {
            this.loadBODYSTRUCTURE();
            ContentType contentType = new ContentType(this.bs.type, this.bs.subtype, this.bs.cParams);
            this.type = contentType.toString();
        }
        return this.type;
    }

    public String getDisposition() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.disposition;
    }

    public void setDisposition(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public String getEncoding() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.encoding;
    }

    public String getContentID() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.id;
    }

    public void setContentID(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public String getContentMD5() throws MessagingException {
        this.checkExpunged();
        this.loadBODYSTRUCTURE();
        return this.bs.md5;
    }

    public void setContentMD5(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public String getDescription() throws MessagingException {
        this.checkExpunged();
        if (this.description != null) {
            return this.description;
        }
        this.loadBODYSTRUCTURE();
        if (this.bs.description == null) {
            return null;
        }
        try {
            this.description = MimeUtility.decodeText((String)this.bs.description);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.description = this.bs.description;
        }
        return this.description;
    }

    public void setDescription(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public String getMessageID() throws MessagingException {
        this.checkExpunged();
        this.loadEnvelope();
        return this.envelope.messageId;
    }

    public String getFileName() throws MessagingException {
        this.checkExpunged();
        String string = null;
        this.loadBODYSTRUCTURE();
        if (this.bs.dParams != null) {
            string = this.bs.dParams.get("filename");
        }
        if (string == null && this.bs.cParams != null) {
            string = this.bs.cParams.get("name");
        }
        return string;
    }

    public void setFileName(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getContentStream() throws MessagingException {
        ByteArrayInputStream byteArrayInputStream = null;
        boolean bl2 = this.getPeek();
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                this.checkExpunged();
                if (iMAPProtocol.isREV1() && this.getFetchBlockSize() != -1) {
                    return new IMAPInputStream(this, this.toSection("TEXT"), this.bs != null && !this.ignoreBodyStructureSize() ? this.bs.size : -1, bl2);
                }
                if (iMAPProtocol.isREV1()) {
                    BODY bODY = bl2 ? iMAPProtocol.peekBody(this.getSequenceNumber(), this.toSection("TEXT")) : iMAPProtocol.fetchBody(this.getSequenceNumber(), this.toSection("TEXT"));
                    if (bODY != null) {
                        byteArrayInputStream = bODY.getByteArrayInputStream();
                    }
                } else {
                    RFC822DATA rFC822DATA = iMAPProtocol.fetchRFC822(this.getSequenceNumber(), "TEXT");
                    if (rFC822DATA != null) {
                        byteArrayInputStream = rFC822DATA.getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                this.forceCheckExpunged();
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
        if (byteArrayInputStream == null) {
            throw new MessagingException("No content");
        }
        return byteArrayInputStream;
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        this.checkExpunged();
        if (this.dh == null) {
            this.loadBODYSTRUCTURE();
            if (this.type == null) {
                ContentType contentType = new ContentType(this.bs.type, this.bs.subtype, this.bs.cParams);
                this.type = contentType.toString();
            }
            if (this.bs.isMulti()) {
                this.dh = new DataHandler((DataSource)new IMAPMultipartDataSource((MimePart)this, this.bs.bodies, this.sectionId, this));
            } else if (this.bs.isNested() && this.isREV1() && this.bs.envelope != null) {
                this.dh = new DataHandler((Object)new IMAPNestedMessage(this, this.bs.bodies[0], this.bs.envelope, this.sectionId == null ? "1" : new StringBuffer().append(this.sectionId).append(".1").toString()), this.type);
            }
        }
        return super.getDataHandler();
    }

    public void setDataHandler(DataHandler dataHandler) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getMimeStream() throws MessagingException {
        ByteArrayInputStream byteArrayInputStream = null;
        boolean bl2 = this.getPeek();
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                this.checkExpunged();
                if (iMAPProtocol.isREV1() && this.getFetchBlockSize() != -1) {
                    return new IMAPInputStream(this, this.sectionId, -1, bl2);
                }
                if (iMAPProtocol.isREV1()) {
                    BODY bODY = bl2 ? iMAPProtocol.peekBody(this.getSequenceNumber(), this.sectionId) : iMAPProtocol.fetchBody(this.getSequenceNumber(), this.sectionId);
                    if (bODY != null) {
                        byteArrayInputStream = bODY.getByteArrayInputStream();
                    }
                } else {
                    RFC822DATA rFC822DATA = iMAPProtocol.fetchRFC822(this.getSequenceNumber(), null);
                    if (rFC822DATA != null) {
                        byteArrayInputStream = rFC822DATA.getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                this.forceCheckExpunged();
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
        if (byteArrayInputStream == null) {
            this.forceCheckExpunged();
            throw new MessagingException("No content");
        }
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        InputStream inputStream = this.getMimeStream();
        try {
            int n2;
            byte[] byArray = new byte[16384];
            while ((n2 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHeader(String string) throws MessagingException {
        this.checkExpunged();
        if (this.isHeaderLoaded(string)) {
            return this.headers.getHeader(string);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                this.checkExpunged();
                if (iMAPProtocol.isREV1()) {
                    BODY bODY = iMAPProtocol.peekBody(this.getSequenceNumber(), this.toSection(new StringBuffer().append("HEADER.FIELDS (").append(string).append(")").toString()));
                    if (bODY != null) {
                        byteArrayInputStream = bODY.getByteArrayInputStream();
                    }
                } else {
                    RFC822DATA rFC822DATA = iMAPProtocol.fetchRFC822(this.getSequenceNumber(), new StringBuffer().append("HEADER.LINES (").append(string).append(")").toString());
                    if (rFC822DATA != null) {
                        byteArrayInputStream = rFC822DATA.getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                this.forceCheckExpunged();
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
        if (byteArrayInputStream == null) {
            return null;
        }
        if (this.headers == null) {
            this.headers = new InternetHeaders();
        }
        this.headers.load((InputStream)byteArrayInputStream);
        this.setHeaderLoaded(string);
        return this.headers.getHeader(string);
    }

    public String getHeader(String string, String string2) throws MessagingException {
        this.checkExpunged();
        if (this.getHeader(string) == null) {
            return null;
        }
        return this.headers.getHeader(string, string2);
    }

    public void setHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void addHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public void removeHeader(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public Enumeration getAllHeaders() throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] stringArray) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getNonMatchingHeaders(stringArray);
    }

    public void addHeaderLine(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPMessage is read-only");
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) throws MessagingException {
        this.checkExpunged();
        this.loadHeaders();
        return super.getNonMatchingHeaderLines(stringArray);
    }

    public synchronized Flags getFlags() throws MessagingException {
        this.checkExpunged();
        this.loadFlags();
        return super.getFlags();
    }

    public synchronized boolean isSet(Flags.Flag flag) throws MessagingException {
        this.checkExpunged();
        this.loadFlags();
        return super.isSet(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFlags(Flags flags, boolean bl2) throws MessagingException {
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                this.checkExpunged();
                iMAPProtocol.storeFlags(this.getSequenceNumber(), flags, bl2);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
    }

    public synchronized void setPeek(boolean bl2) {
        this.peek = bl2;
    }

    public synchronized boolean getPeek() {
        return this.peek;
    }

    public synchronized void invalidateHeaders() {
        this.headersLoaded = false;
        this.loadedHeaders.clear();
        this.headers = null;
        this.envelope = null;
        this.bs = null;
        this.receivedDate = null;
        this.size = -1;
        this.type = null;
        this.subject = null;
        this.description = null;
        this.flags = null;
    }

    protected boolean handleFetchItem(Item item, String[] stringArray, boolean bl2) throws MessagingException {
        if (item instanceof Flags) {
            this.flags = (Flags)item;
        } else if (item instanceof ENVELOPE) {
            this.envelope = (ENVELOPE)item;
        } else if (item instanceof INTERNALDATE) {
            this.receivedDate = ((INTERNALDATE)item).getDate();
        } else if (item instanceof RFC822SIZE) {
            this.size = ((RFC822SIZE)item).size;
        } else if (item instanceof BODYSTRUCTURE) {
            this.bs = (BODYSTRUCTURE)item;
        } else if (item instanceof UID) {
            UID uID = (UID)item;
            this.uid = uID.uid;
            if (((IMAPFolder)this.folder).uidTable == null) {
                ((IMAPFolder)this.folder).uidTable = new Hashtable();
            }
            ((IMAPFolder)this.folder).uidTable.put(new Long(uID.uid), this);
        } else if (item instanceof RFC822DATA || item instanceof BODY) {
            ByteArrayInputStream byteArrayInputStream = item instanceof RFC822DATA ? ((RFC822DATA)item).getByteArrayInputStream() : ((BODY)item).getByteArrayInputStream();
            InternetHeaders internetHeaders = new InternetHeaders();
            if (byteArrayInputStream != null) {
                internetHeaders.load((InputStream)byteArrayInputStream);
            }
            if (this.headers == null || bl2) {
                this.headers = internetHeaders;
            } else {
                Enumeration enumeration = internetHeaders.getAllHeaders();
                while (enumeration.hasMoreElements()) {
                    Header header = (Header)enumeration.nextElement();
                    if (this.isHeaderLoaded(header.getName())) continue;
                    this.headers.addHeader(header.getName(), header.getValue());
                }
            }
            if (bl2) {
                this.setHeadersLoaded(true);
            } else {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    this.setHeaderLoaded(stringArray[i2]);
                }
            }
        } else {
            return false;
        }
        return true;
    }

    protected void handleExtensionFetchItems(Map map) throws MessagingException {
        if (this.items == null) {
            this.items = map;
        } else {
            this.items.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object fetchItem(FetchItem fetchItem) throws MessagingException {
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            Object var3_3 = null;
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                this.checkExpunged();
                int n2 = this.getSequenceNumber();
                Response[] responseArray = iMAPProtocol.fetch(n2, fetchItem.getName());
                for (int i2 = 0; i2 < responseArray.length; ++i2) {
                    FetchResponse fetchResponse;
                    Object v2;
                    if (responseArray[i2] == null || !(responseArray[i2] instanceof FetchResponse) || ((FetchResponse)responseArray[i2]).getNumber() != n2 || (v2 = (fetchResponse = (FetchResponse)responseArray[i2]).getExtensionItems().get(fetchItem.getName())) == null) continue;
                    var3_3 = v2;
                }
                iMAPProtocol.notifyResponseHandlers(responseArray);
                iMAPProtocol.handleResult(responseArray[responseArray.length - 1]);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                this.forceCheckExpunged();
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
            return var3_3;
        }
    }

    public synchronized Object getItem(FetchItem fetchItem) throws MessagingException {
        Object object;
        Object object2 = object = this.items == null ? null : (Object)this.items.get(fetchItem.getName());
        if (object == null) {
            object = this.fetchItem(fetchItem);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadEnvelope() throws MessagingException {
        if (this.envelope != null) {
            return;
        }
        Response[] responseArray = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                this.checkExpunged();
                int n2 = this.getSequenceNumber();
                responseArray = iMAPProtocol.fetch(n2, EnvelopeCmd);
                for (int i2 = 0; i2 < responseArray.length; ++i2) {
                    if (responseArray[i2] == null || !(responseArray[i2] instanceof FetchResponse) || ((FetchResponse)responseArray[i2]).getNumber() != n2) continue;
                    FetchResponse fetchResponse = (FetchResponse)responseArray[i2];
                    int n3 = fetchResponse.getItemCount();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        Item item = fetchResponse.getItem(i3);
                        if (item instanceof ENVELOPE) {
                            this.envelope = (ENVELOPE)item;
                            continue;
                        }
                        if (item instanceof INTERNALDATE) {
                            this.receivedDate = ((INTERNALDATE)item).getDate();
                            continue;
                        }
                        if (!(item instanceof RFC822SIZE)) continue;
                        this.size = ((RFC822SIZE)item).size;
                    }
                }
                iMAPProtocol.notifyResponseHandlers(responseArray);
                iMAPProtocol.handleResult(responseArray[responseArray.length - 1]);
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                this.forceCheckExpunged();
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
        if (this.envelope == null) {
            throw new MessagingException("Failed to load IMAP envelope");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadBODYSTRUCTURE() throws MessagingException {
        if (this.bs != null) {
            return;
        }
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                this.checkExpunged();
                this.bs = iMAPProtocol.fetchBodyStructure(this.getSequenceNumber());
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                this.forceCheckExpunged();
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
            if (this.bs == null) {
                this.forceCheckExpunged();
                throw new MessagingException("Unable to load BODYSTRUCTURE");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadHeaders() throws MessagingException {
        if (this.headersLoaded) {
            return;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                this.checkExpunged();
                if (iMAPProtocol.isREV1()) {
                    BODY bODY = iMAPProtocol.peekBody(this.getSequenceNumber(), this.toSection("HEADER"));
                    if (bODY != null) {
                        byteArrayInputStream = bODY.getByteArrayInputStream();
                    }
                } else {
                    RFC822DATA rFC822DATA = iMAPProtocol.fetchRFC822(this.getSequenceNumber(), "HEADER");
                    if (rFC822DATA != null) {
                        byteArrayInputStream = rFC822DATA.getByteArrayInputStream();
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                this.forceCheckExpunged();
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
        if (byteArrayInputStream == null) {
            throw new MessagingException("Cannot load header");
        }
        this.headers = new InternetHeaders((InputStream)byteArrayInputStream);
        this.headersLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadFlags() throws MessagingException {
        if (this.flags != null) {
            return;
        }
        Object object = this.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.getProtocol();
                this.checkExpunged();
                this.flags = iMAPProtocol.fetchFlags(this.getSequenceNumber());
                if (this.flags == null) {
                    this.flags = new Flags();
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.folder, connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                this.forceCheckExpunged();
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
    }

    private boolean areHeadersLoaded() {
        return this.headersLoaded;
    }

    private void setHeadersLoaded(boolean bl2) {
        this.headersLoaded = bl2;
    }

    private boolean isHeaderLoaded(String string) {
        if (this.headersLoaded) {
            return true;
        }
        return this.loadedHeaders.containsKey(string.toUpperCase(Locale.ENGLISH));
    }

    private void setHeaderLoaded(String string) {
        this.loadedHeaders.put(string.toUpperCase(Locale.ENGLISH), string);
    }

    private String toSection(String string) {
        if (this.sectionId == null) {
            return string;
        }
        return new StringBuffer().append(this.sectionId).append(".").append(string).toString();
    }

    private InternetAddress[] aaclone(InternetAddress[] internetAddressArray) {
        if (internetAddressArray == null) {
            return null;
        }
        return (InternetAddress[])internetAddressArray.clone();
    }

    private Flags _getFlags() {
        return this.flags;
    }

    private ENVELOPE _getEnvelope() {
        return this.envelope;
    }

    private BODYSTRUCTURE _getBodyStructure() {
        return this.bs;
    }

    void _setFlags(Flags flags) {
        this.flags = flags;
    }

    Session _getSession() {
        return this.session;
    }

    static /* synthetic */ ENVELOPE access$000(IMAPMessage iMAPMessage) {
        return iMAPMessage._getEnvelope();
    }

    static /* synthetic */ Flags access$100(IMAPMessage iMAPMessage) {
        return iMAPMessage._getFlags();
    }

    static /* synthetic */ BODYSTRUCTURE access$200(IMAPMessage iMAPMessage) {
        return iMAPMessage._getBodyStructure();
    }

    static /* synthetic */ boolean access$300(IMAPMessage iMAPMessage) {
        return iMAPMessage.areHeadersLoaded();
    }

    static /* synthetic */ int access$400(IMAPMessage iMAPMessage) {
        return iMAPMessage.size;
    }

    static /* synthetic */ boolean access$500(IMAPMessage iMAPMessage, String string) {
        return iMAPMessage.isHeaderLoaded(string);
    }
}

