/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.sun.mail_1_4_7.imap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import macromedia.externals.com.sun.mail_1_4_7.iap.ConnectionException;
import macromedia.externals.com.sun.mail_1_4_7.iap.ProtocolException;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPInputStream;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPMessage;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPMultipartDataSource;
import macromedia.externals.com.sun.mail_1_4_7.imap.IMAPNestedMessage;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.BODY;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.BODYSTRUCTURE;
import macromedia.externals.com.sun.mail_1_4_7.imap.protocol.IMAPProtocol;
import macromedia.externals.com.sun.mail_1_4_7.util.LineOutputStream;
import macromedia.externals.com.sun.mail_1_4_7.util.PropUtil;
import macromedia.externals.com.sun.mail_1_4_7.util.ReadableMime;
import macromedia.externals.com.sun.mail_1_4_7.util.SharedByteArrayOutputStream;
import macromedia.externals.javax.mail_1_4_7.FolderClosedException;
import macromedia.externals.javax.mail_1_4_7.IllegalWriteException;
import macromedia.externals.javax.mail_1_4_7.MessagingException;
import macromedia.externals.javax.mail_1_4_7.Multipart;
import macromedia.externals.javax.mail_1_4_7.internet.ContentType;
import macromedia.externals.javax.mail_1_4_7.internet.InternetHeaders;
import macromedia.externals.javax.mail_1_4_7.internet.MimeBodyPart;
import macromedia.externals.javax.mail_1_4_7.internet.MimePart;
import macromedia.externals.javax.mail_1_4_7.internet.MimeUtility;

public class IMAPBodyPart
extends MimeBodyPart
implements ReadableMime {
    private IMAPMessage message;
    private BODYSTRUCTURE bs;
    private String sectionId;
    private String type;
    private String description;
    private boolean headersLoaded = false;
    private static final boolean decodeFileName = PropUtil.getBooleanSystemProperty((String)"mail.mime.decodefilename", (boolean)false);

    protected IMAPBodyPart(BODYSTRUCTURE bODYSTRUCTURE, String string, IMAPMessage iMAPMessage) {
        this.bs = bODYSTRUCTURE;
        this.sectionId = string;
        this.message = iMAPMessage;
        ContentType contentType = new ContentType(bODYSTRUCTURE.type, bODYSTRUCTURE.subtype, bODYSTRUCTURE.cParams);
        this.type = contentType.toString();
    }

    protected void updateHeaders() {
    }

    public int getSize() throws MessagingException {
        return this.bs.size;
    }

    public int getLineCount() throws MessagingException {
        return this.bs.lines;
    }

    public String getContentType() throws MessagingException {
        return this.type;
    }

    public String getDisposition() throws MessagingException {
        return this.bs.disposition;
    }

    public void setDisposition(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public String getEncoding() throws MessagingException {
        return this.bs.encoding;
    }

    public String getContentID() throws MessagingException {
        return this.bs.id;
    }

    public String getContentMD5() throws MessagingException {
        return this.bs.md5;
    }

    public void setContentMD5(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public String getDescription() throws MessagingException {
        if (this.description != null) {
            return this.description;
        }
        if (this.bs.description == null) {
            return null;
        }
        try {
            this.description = MimeUtility.decodeText((String)this.bs.description);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.description = this.bs.description;
        }
        return this.description;
    }

    public void setDescription(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public String getFileName() throws MessagingException {
        String string = null;
        if (this.bs.dParams != null) {
            string = this.bs.dParams.get("filename");
        }
        if (string == null && this.bs.cParams != null) {
            string = this.bs.cParams.get("name");
        }
        if (decodeFileName && string != null) {
            try {
                string = MimeUtility.decodeText((String)string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new MessagingException("Can't decode filename", (Exception)unsupportedEncodingException);
            }
        }
        return string;
    }

    public void setFileName(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getContentStream() throws MessagingException {
        ByteArrayInputStream byteArrayInputStream = null;
        boolean bl2 = this.message.getPeek();
        Object object = this.message.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.message.getProtocol();
                this.message.checkExpunged();
                if (iMAPProtocol.isREV1() && this.message.getFetchBlockSize() != -1) {
                    return new IMAPInputStream(this.message, this.sectionId, this.message.ignoreBodyStructureSize() ? -1 : this.bs.size, bl2);
                }
                int n2 = this.message.getSequenceNumber();
                BODY bODY = bl2 ? iMAPProtocol.peekBody(n2, this.sectionId) : iMAPProtocol.fetchBody(n2, this.sectionId);
                if (bODY != null) {
                    byteArrayInputStream = bODY.getByteArrayInputStream();
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.message.getFolder(), connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
        if (byteArrayInputStream == null) {
            throw new MessagingException("No content");
        }
        return byteArrayInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getHeaderStream() throws MessagingException {
        if (!this.message.isREV1()) {
            this.loadHeaders();
        }
        Object object = this.message.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.message.getProtocol();
                this.message.checkExpunged();
                if (iMAPProtocol.isREV1()) {
                    int n2 = this.message.getSequenceNumber();
                    BODY bODY = iMAPProtocol.peekBody(n2, new StringBuffer().append(this.sectionId).append(".MIME").toString());
                    if (bODY == null) {
                        throw new MessagingException("Failed to fetch headers");
                    }
                    ByteArrayInputStream byteArrayInputStream = bODY.getByteArrayInputStream();
                    if (byteArrayInputStream == null) {
                        throw new MessagingException("Failed to fetch headers");
                    }
                    return byteArrayInputStream;
                }
                SharedByteArrayOutputStream sharedByteArrayOutputStream = new SharedByteArrayOutputStream(0);
                LineOutputStream lineOutputStream = new LineOutputStream((OutputStream)sharedByteArrayOutputStream);
                try {
                    Enumeration enumeration = super.getAllHeaderLines();
                    while (enumeration.hasMoreElements()) {
                        lineOutputStream.writeln((String)enumeration.nextElement());
                    }
                    lineOutputStream.writeln();
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        lineOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                return sharedByteArrayOutputStream.toStream();
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.message.getFolder(), connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
    }

    public InputStream getMimeStream() throws MessagingException {
        return new SequenceInputStream(this.getHeaderStream(), this.getContentStream());
    }

    public synchronized DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            if (this.bs.isMulti()) {
                this.dh = new DataHandler((DataSource)new IMAPMultipartDataSource((MimePart)this, this.bs.bodies, this.sectionId, this.message));
            } else if (this.bs.isNested() && this.message.isREV1() && this.bs.envelope != null) {
                this.dh = new DataHandler((Object)new IMAPNestedMessage(this.message, this.bs.bodies[0], this.bs.envelope, this.sectionId), this.type);
            }
        }
        return super.getDataHandler();
    }

    public void setDataHandler(DataHandler dataHandler) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public void setContent(Object object, String string) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public void setContent(Multipart multipart) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public String[] getHeader(String string) throws MessagingException {
        this.loadHeaders();
        return super.getHeader(string);
    }

    public void setHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public void addHeader(String string, String string2) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public void removeHeader(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public Enumeration getAllHeaders() throws MessagingException {
        this.loadHeaders();
        return super.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] stringArray) throws MessagingException {
        this.loadHeaders();
        return super.getMatchingHeaders(stringArray);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) throws MessagingException {
        this.loadHeaders();
        return super.getNonMatchingHeaders(stringArray);
    }

    public void addHeaderLine(String string) throws MessagingException {
        throw new IllegalWriteException("IMAPBodyPart is read-only");
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        this.loadHeaders();
        return super.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) throws MessagingException {
        this.loadHeaders();
        return super.getMatchingHeaderLines(stringArray);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) throws MessagingException {
        this.loadHeaders();
        return super.getNonMatchingHeaderLines(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadHeaders() throws MessagingException {
        if (this.headersLoaded) {
            return;
        }
        if (this.headers == null) {
            this.headers = new InternetHeaders();
        }
        Object object = this.message.getMessageCacheLock();
        synchronized (object) {
            try {
                IMAPProtocol iMAPProtocol = this.message.getProtocol();
                this.message.checkExpunged();
                if (iMAPProtocol.isREV1()) {
                    int n2 = this.message.getSequenceNumber();
                    BODY bODY = iMAPProtocol.peekBody(n2, new StringBuffer().append(this.sectionId).append(".MIME").toString());
                    if (bODY == null) {
                        throw new MessagingException("Failed to fetch headers");
                    }
                    ByteArrayInputStream byteArrayInputStream = bODY.getByteArrayInputStream();
                    if (byteArrayInputStream == null) {
                        throw new MessagingException("Failed to fetch headers");
                    }
                    this.headers.load((InputStream)byteArrayInputStream);
                } else {
                    this.headers.addHeader("Content-Type", this.type);
                    this.headers.addHeader("Content-Transfer-Encoding", this.bs.encoding);
                    if (this.bs.description != null) {
                        this.headers.addHeader("Content-Description", this.bs.description);
                    }
                    if (this.bs.id != null) {
                        this.headers.addHeader("Content-ID", this.bs.id);
                    }
                    if (this.bs.md5 != null) {
                        this.headers.addHeader("Content-MD5", this.bs.md5);
                    }
                }
            }
            catch (ConnectionException connectionException) {
                throw new FolderClosedException(this.message.getFolder(), connectionException.getMessage());
            }
            catch (ProtocolException protocolException) {
                throw new MessagingException(protocolException.getMessage(), (Exception)((Object)protocolException));
            }
        }
        this.headersLoaded = true;
    }
}

