/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.validators;

import java.net.MalformedURLException;
import java.net.URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKSet;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.source.ImmutableJWKSet;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.source.ImmutableSecret;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.source.JWKSource;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.source.RemoteJWKSet;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.BadJOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWEDecryptionKeySelector;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWEKeySelector;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWSKeySelector;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWSVerificationKeySelector;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ResourceRetriever;
import macromedia.externals.com.nimbusds.jwt_8_2_1.EncryptedJWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.jwt_8_2_1.PlainJWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.SignedJWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.BadJWTException;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.ClockSkewAware;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.DefaultJWTProcessor;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.JWTClaimsVerifier;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.GeneralException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.Secret;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Issuer;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.Nonce;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.IDTokenClaimsSet;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.op.OIDCProviderMetadata;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.rp.OIDCClientInformation;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.validators.IDTokenClaimsVerifier;
import net.jcip.annotations.ThreadSafe;

/*
 * Exception performing whole class analysis ignored.
 */
@ThreadSafe
public class IDTokenValidator
implements ClockSkewAware {
    public static final int DEFAULT_MAX_CLOCK_SKEW = 60;
    private final Issuer expectedIssuer;
    private final ClientID clientID;
    private final JWSKeySelector jwsKeySelector;
    private final JWEKeySelector jweKeySelector;
    private int maxClockSkew = 60;

    public IDTokenValidator(Issuer issuer, ClientID clientID) {
        this(issuer, clientID, null, null);
    }

    public IDTokenValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, JWKSet jWKSet) {
        this(issuer, clientID, (JWSKeySelector)new JWSVerificationKeySelector(jWSAlgorithm, (JWKSource)new ImmutableJWKSet(jWKSet)), null);
    }

    public IDTokenValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, URL uRL) {
        this(issuer, clientID, jWSAlgorithm, uRL, null);
    }

    public IDTokenValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, URL uRL, ResourceRetriever resourceRetriever) {
        this(issuer, clientID, (JWSKeySelector)new JWSVerificationKeySelector(jWSAlgorithm, (JWKSource)new RemoteJWKSet(uRL, resourceRetriever)), null);
    }

    public IDTokenValidator(Issuer issuer, ClientID clientID, JWSAlgorithm jWSAlgorithm, Secret secret) {
        this(issuer, clientID, (JWSKeySelector)new JWSVerificationKeySelector(jWSAlgorithm, (JWKSource)new ImmutableSecret(secret.getValueBytes())), null);
    }

    public IDTokenValidator(Issuer issuer, ClientID clientID, JWSKeySelector jWSKeySelector, JWEKeySelector jWEKeySelector) {
        if (issuer == null) {
            throw new IllegalArgumentException("The expected ID token issuer must not be null");
        }
        this.expectedIssuer = issuer;
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.clientID = clientID;
        this.jwsKeySelector = jWSKeySelector;
        this.jweKeySelector = jWEKeySelector;
    }

    public Issuer getExpectedIssuer() {
        return this.expectedIssuer;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public JWSKeySelector getJWSKeySelector() {
        return this.jwsKeySelector;
    }

    public JWEKeySelector getJWEKeySelector() {
        return this.jweKeySelector;
    }

    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    public void setMaxClockSkew(int n2) {
        this.maxClockSkew = n2;
    }

    public IDTokenClaimsSet validate(JWT jWT, Nonce nonce) throws BadJOSEException, JOSEException {
        if (jWT instanceof PlainJWT) {
            return this.validate((PlainJWT)jWT, nonce);
        }
        if (jWT instanceof SignedJWT) {
            return this.validate((SignedJWT)jWT, nonce);
        }
        if (jWT instanceof EncryptedJWT) {
            return this.validate((EncryptedJWT)jWT, nonce);
        }
        throw new JOSEException("Unexpected JWT type: " + jWT.getClass());
    }

    private IDTokenClaimsSet validate(PlainJWT plainJWT, Nonce nonce) throws BadJOSEException, JOSEException {
        JWTClaimsSet jWTClaimsSet;
        if (this.jwsKeySelector != null) {
            throw new BadJWTException("Signed ID token expected");
        }
        try {
            jWTClaimsSet = plainJWT.getJWTClaimsSet();
        }
        catch (java.text.ParseException parseException) {
            throw new BadJWTException(parseException.getMessage(), (Throwable)parseException);
        }
        IDTokenClaimsVerifier iDTokenClaimsVerifier = new IDTokenClaimsVerifier(this.expectedIssuer, this.clientID, nonce, this.maxClockSkew);
        iDTokenClaimsVerifier.verify(jWTClaimsSet);
        return IDTokenValidator.toIDTokenClaimsSet((JWTClaimsSet)jWTClaimsSet);
    }

    private IDTokenClaimsSet validate(SignedJWT signedJWT, Nonce nonce) throws BadJOSEException, JOSEException {
        if (this.jwsKeySelector == null) {
            throw new BadJWTException("Verification of signed JWTs not configured");
        }
        DefaultJWTProcessor defaultJWTProcessor = new DefaultJWTProcessor();
        defaultJWTProcessor.setJWSKeySelector(this.jwsKeySelector);
        defaultJWTProcessor.setJWTClaimsVerifier((JWTClaimsVerifier)new IDTokenClaimsVerifier(this.expectedIssuer, this.clientID, nonce, this.maxClockSkew));
        JWTClaimsSet jWTClaimsSet = defaultJWTProcessor.process(signedJWT, null);
        return IDTokenValidator.toIDTokenClaimsSet((JWTClaimsSet)jWTClaimsSet);
    }

    private IDTokenClaimsSet validate(EncryptedJWT encryptedJWT, Nonce nonce) throws BadJOSEException, JOSEException {
        if (this.jweKeySelector == null) {
            throw new BadJWTException("Decryption of JWTs not configured");
        }
        if (this.jwsKeySelector == null) {
            throw new BadJWTException("Verification of signed JWTs not configured");
        }
        DefaultJWTProcessor defaultJWTProcessor = new DefaultJWTProcessor();
        defaultJWTProcessor.setJWSKeySelector(this.jwsKeySelector);
        defaultJWTProcessor.setJWEKeySelector(this.jweKeySelector);
        defaultJWTProcessor.setJWTClaimsVerifier((JWTClaimsVerifier)new IDTokenClaimsVerifier(this.expectedIssuer, this.clientID, nonce, this.maxClockSkew));
        JWTClaimsSet jWTClaimsSet = defaultJWTProcessor.process(encryptedJWT, null);
        return IDTokenValidator.toIDTokenClaimsSet((JWTClaimsSet)jWTClaimsSet);
    }

    private static IDTokenClaimsSet toIDTokenClaimsSet(JWTClaimsSet jWTClaimsSet) throws JOSEException {
        try {
            return new IDTokenClaimsSet(jWTClaimsSet);
        }
        catch (ParseException parseException) {
            throw new JOSEException(parseException.getMessage(), (Throwable)parseException);
        }
    }

    private static JWSKeySelector createJWSKeySelector(OIDCProviderMetadata oIDCProviderMetadata, OIDCClientInformation oIDCClientInformation) throws GeneralException {
        JWSAlgorithm jWSAlgorithm = oIDCClientInformation.getOIDCMetadata().getIDTokenJWSAlg();
        if (oIDCProviderMetadata.getIDTokenJWSAlgs() == null) {
            throw new GeneralException("Missing OpenID Provider id_token_signing_alg_values_supported parameter");
        }
        if (!oIDCProviderMetadata.getIDTokenJWSAlgs().contains(jWSAlgorithm)) {
            throw new GeneralException("The OpenID Provider doesn't support " + jWSAlgorithm + " ID tokens");
        }
        if (Algorithm.NONE.equals((Object)jWSAlgorithm)) {
            return null;
        }
        if (JWSAlgorithm.Family.RSA.contains((Object)jWSAlgorithm) || JWSAlgorithm.Family.EC.contains((Object)jWSAlgorithm)) {
            URL uRL;
            try {
                uRL = oIDCProviderMetadata.getJWKSetURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new GeneralException("Invalid jwk set URI: " + malformedURLException.getMessage(), (Throwable)malformedURLException);
            }
            RemoteJWKSet remoteJWKSet = new RemoteJWKSet(uRL);
            return new JWSVerificationKeySelector(jWSAlgorithm, (JWKSource)remoteJWKSet);
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)jWSAlgorithm)) {
            Secret secret = oIDCClientInformation.getSecret();
            if (secret == null) {
                throw new GeneralException("Missing client secret");
            }
            return new JWSVerificationKeySelector(jWSAlgorithm, (JWKSource)new ImmutableSecret(secret.getValueBytes()));
        }
        throw new GeneralException("Unsupported JWS algorithm: " + jWSAlgorithm);
    }

    private static JWEKeySelector createJWEKeySelector(OIDCProviderMetadata oIDCProviderMetadata, OIDCClientInformation oIDCClientInformation, JWKSource jWKSource) throws GeneralException {
        JWEAlgorithm jWEAlgorithm = oIDCClientInformation.getOIDCMetadata().getIDTokenJWEAlg();
        EncryptionMethod encryptionMethod = oIDCClientInformation.getOIDCMetadata().getIDTokenJWEEnc();
        if (jWEAlgorithm == null) {
            return null;
        }
        if (encryptionMethod == null) {
            throw new GeneralException("Missing required ID token JWE encryption method for " + jWEAlgorithm);
        }
        if (oIDCProviderMetadata.getIDTokenJWEAlgs() == null || !oIDCProviderMetadata.getIDTokenJWEAlgs().contains(jWEAlgorithm)) {
            throw new GeneralException("The OpenID Provider doesn't support " + jWEAlgorithm + " ID tokens");
        }
        if (oIDCProviderMetadata.getIDTokenJWEEncs() == null || !oIDCProviderMetadata.getIDTokenJWEEncs().contains(encryptionMethod)) {
            throw new GeneralException("The OpenID Provider doesn't support " + jWEAlgorithm + " / " + encryptionMethod + " ID tokens");
        }
        return new JWEDecryptionKeySelector(jWEAlgorithm, encryptionMethod, jWKSource);
    }

    public static IDTokenValidator create(OIDCProviderMetadata oIDCProviderMetadata, OIDCClientInformation oIDCClientInformation, JWKSource jWKSource) throws GeneralException {
        JWSKeySelector jWSKeySelector = IDTokenValidator.createJWSKeySelector((OIDCProviderMetadata)oIDCProviderMetadata, (OIDCClientInformation)oIDCClientInformation);
        JWEKeySelector jWEKeySelector = IDTokenValidator.createJWEKeySelector((OIDCProviderMetadata)oIDCProviderMetadata, (OIDCClientInformation)oIDCClientInformation, (JWKSource)jWKSource);
        return new IDTokenValidator(oIDCProviderMetadata.getIssuer(), oIDCClientInformation.getID(), jWSKeySelector, jWEKeySelector);
    }
}

