/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.rp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client.ClientMetadata;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client.RegistrationError;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.SubjectType;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.ACR;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.id.SectorID;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.rp.ApplicationType;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import org.apache.commons.collections.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class OIDCClientMetadata
extends ClientMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private ApplicationType applicationType;
    private SubjectType subjectType;
    private URI sectorIDURI;
    private Set<URI> requestObjectURIs;
    private JWSAlgorithm requestObjectJWSAlg;
    private JWEAlgorithm requestObjectJWEAlg;
    private EncryptionMethod requestObjectJWEEnc;
    private JWSAlgorithm idTokenJWSAlg;
    private JWEAlgorithm idTokenJWEAlg;
    private EncryptionMethod idTokenJWEEnc;
    private JWSAlgorithm userInfoJWSAlg;
    private JWEAlgorithm userInfoJWEAlg;
    private EncryptionMethod userInfoJWEEnc;
    private int defaultMaxAge = -1;
    private boolean requiresAuthTime;
    private List<ACR> defaultACRs;
    private URI initiateLoginURI;
    private Set<URI> postLogoutRedirectURIs;

    static {
        HashSet<String> hashSet = new HashSet<String>(ClientMetadata.getRegisteredParameterNames());
        hashSet.add("application_type");
        hashSet.add("subject_type");
        hashSet.add("sector_identifier_uri");
        hashSet.add("request_uris");
        hashSet.add("request_object_signing_alg");
        hashSet.add("request_object_encryption_alg");
        hashSet.add("request_object_encryption_enc");
        hashSet.add("id_token_signed_response_alg");
        hashSet.add("id_token_encrypted_response_alg");
        hashSet.add("id_token_encrypted_response_enc");
        hashSet.add("userinfo_signed_response_alg");
        hashSet.add("userinfo_encrypted_response_alg");
        hashSet.add("userinfo_encrypted_response_enc");
        hashSet.add("default_max_age");
        hashSet.add("require_auth_time");
        hashSet.add("default_acr_values");
        hashSet.add("initiate_login_uri");
        hashSet.add("post_logout_redirect_uris");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public OIDCClientMetadata() {
    }

    public OIDCClientMetadata(ClientMetadata clientMetadata) {
        super(clientMetadata);
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(ApplicationType applicationType) {
        this.applicationType = applicationType;
    }

    public SubjectType getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(SubjectType subjectType) {
        this.subjectType = subjectType;
    }

    public URI getSectorIDURI() {
        return this.sectorIDURI;
    }

    public void setSectorIDURI(URI uRI) {
        if (uRI != null) {
            SectorID.ensureHTTPScheme((URI)uRI);
            SectorID.ensureHostComponent((URI)uRI);
        }
        this.sectorIDURI = uRI;
    }

    public SectorID resolveSectorID() {
        if (!SubjectType.PAIRWISE.equals((Object)this.getSubjectType())) {
            return null;
        }
        if (this.getSectorIDURI() != null) {
            return new SectorID(this.getSectorIDURI());
        }
        if (CollectionUtils.isEmpty((Collection)this.getRedirectionURIs())) {
            throw new IllegalStateException("Couldn't resolve sector ID: Missing redirect_uris");
        }
        if (this.getRedirectionURIs().size() > 1) {
            throw new IllegalStateException("Couldn't resolve sector ID: More than one redirect_uri, sector_identifier_uri not specified");
        }
        return new SectorID((URI)this.getRedirectionURIs().iterator().next());
    }

    public Set<URI> getRequestObjectURIs() {
        return this.requestObjectURIs;
    }

    public void setRequestObjectURIs(Set<URI> set) {
        this.requestObjectURIs = set;
    }

    public JWSAlgorithm getRequestObjectJWSAlg() {
        return this.requestObjectJWSAlg;
    }

    public void setRequestObjectJWSAlg(JWSAlgorithm jWSAlgorithm) {
        this.requestObjectJWSAlg = jWSAlgorithm;
    }

    public JWEAlgorithm getRequestObjectJWEAlg() {
        return this.requestObjectJWEAlg;
    }

    public void setRequestObjectJWEAlg(JWEAlgorithm jWEAlgorithm) {
        this.requestObjectJWEAlg = jWEAlgorithm;
    }

    public EncryptionMethod getRequestObjectJWEEnc() {
        return this.requestObjectJWEEnc;
    }

    public void setRequestObjectJWEEnc(EncryptionMethod encryptionMethod) {
        this.requestObjectJWEEnc = encryptionMethod;
    }

    public JWSAlgorithm getIDTokenJWSAlg() {
        return this.idTokenJWSAlg;
    }

    public void setIDTokenJWSAlg(JWSAlgorithm jWSAlgorithm) {
        this.idTokenJWSAlg = jWSAlgorithm;
    }

    public JWEAlgorithm getIDTokenJWEAlg() {
        return this.idTokenJWEAlg;
    }

    public void setIDTokenJWEAlg(JWEAlgorithm jWEAlgorithm) {
        this.idTokenJWEAlg = jWEAlgorithm;
    }

    public EncryptionMethod getIDTokenJWEEnc() {
        return this.idTokenJWEEnc;
    }

    public void setIDTokenJWEEnc(EncryptionMethod encryptionMethod) {
        this.idTokenJWEEnc = encryptionMethod;
    }

    public JWSAlgorithm getUserInfoJWSAlg() {
        return this.userInfoJWSAlg;
    }

    public void setUserInfoJWSAlg(JWSAlgorithm jWSAlgorithm) {
        this.userInfoJWSAlg = jWSAlgorithm;
    }

    public JWEAlgorithm getUserInfoJWEAlg() {
        return this.userInfoJWEAlg;
    }

    public void setUserInfoJWEAlg(JWEAlgorithm jWEAlgorithm) {
        this.userInfoJWEAlg = jWEAlgorithm;
    }

    public EncryptionMethod getUserInfoJWEEnc() {
        return this.userInfoJWEEnc;
    }

    public void setUserInfoJWEEnc(EncryptionMethod encryptionMethod) {
        this.userInfoJWEEnc = encryptionMethod;
    }

    public int getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(int n2) {
        this.defaultMaxAge = n2;
    }

    public boolean requiresAuthTime() {
        return this.requiresAuthTime;
    }

    public void requiresAuthTime(boolean bl2) {
        this.requiresAuthTime = bl2;
    }

    public List<ACR> getDefaultACRs() {
        return this.defaultACRs;
    }

    public void setDefaultACRs(List<ACR> list) {
        this.defaultACRs = list;
    }

    public URI getInitiateLoginURI() {
        return this.initiateLoginURI;
    }

    public void setInitiateLoginURI(URI uRI) {
        this.initiateLoginURI = uRI;
    }

    public Set<URI> getPostLogoutRedirectionURIs() {
        return this.postLogoutRedirectURIs;
    }

    public void setPostLogoutRedirectionURIs(Set<URI> set) {
        this.postLogoutRedirectURIs = set;
    }

    public void applyDefaults() {
        super.applyDefaults();
        if (this.applicationType == null) {
            this.applicationType = ApplicationType.WEB;
        }
        if (this.idTokenJWSAlg == null) {
            this.idTokenJWSAlg = JWSAlgorithm.RS256;
        }
    }

    public JSONObject toJSONObject(boolean bl2) {
        JSONArray jSONArray;
        JSONObject jSONObject = super.toJSONObject(bl2);
        jSONObject.putAll((Map)this.getCustomFields());
        if (this.applicationType != null) {
            jSONObject.put((Object)"application_type", (Object)this.applicationType.toString());
        }
        if (this.subjectType != null) {
            jSONObject.put((Object)"subject_type", (Object)this.subjectType.toString());
        }
        if (this.sectorIDURI != null) {
            jSONObject.put((Object)"sector_identifier_uri", (Object)this.sectorIDURI.toString());
        }
        if (this.requestObjectURIs != null) {
            jSONArray = new JSONArray();
            for (URI uRI : this.requestObjectURIs) {
                jSONArray.add((Object)uRI.toString());
            }
            jSONObject.put((Object)"request_uris", (Object)jSONArray);
        }
        if (this.requestObjectJWSAlg != null) {
            jSONObject.put((Object)"request_object_signing_alg", (Object)this.requestObjectJWSAlg.getName());
        }
        if (this.requestObjectJWEAlg != null) {
            jSONObject.put((Object)"request_object_encryption_alg", (Object)this.requestObjectJWEAlg.getName());
        }
        if (this.requestObjectJWEEnc != null) {
            jSONObject.put((Object)"request_object_encryption_enc", (Object)this.requestObjectJWEEnc.getName());
        }
        if (this.idTokenJWSAlg != null) {
            jSONObject.put((Object)"id_token_signed_response_alg", (Object)this.idTokenJWSAlg.getName());
        }
        if (this.idTokenJWEAlg != null) {
            jSONObject.put((Object)"id_token_encrypted_response_alg", (Object)this.idTokenJWEAlg.getName());
        }
        if (this.idTokenJWEEnc != null) {
            jSONObject.put((Object)"id_token_encrypted_response_enc", (Object)this.idTokenJWEEnc.getName());
        }
        if (this.userInfoJWSAlg != null) {
            jSONObject.put((Object)"userinfo_signed_response_alg", (Object)this.userInfoJWSAlg.getName());
        }
        if (this.userInfoJWEAlg != null) {
            jSONObject.put((Object)"userinfo_encrypted_response_alg", (Object)this.userInfoJWEAlg.getName());
        }
        if (this.userInfoJWEEnc != null) {
            jSONObject.put((Object)"userinfo_encrypted_response_enc", (Object)this.userInfoJWEEnc.getName());
        }
        if (this.defaultMaxAge > 0) {
            jSONObject.put((Object)"default_max_age", (Object)this.defaultMaxAge);
        }
        if (this.requiresAuthTime()) {
            jSONObject.put((Object)"require_auth_time", (Object)this.requiresAuthTime);
        }
        if (this.defaultACRs != null) {
            jSONArray = new JSONArray();
            for (URI uRI : this.defaultACRs) {
                jSONArray.add((Object)uRI);
            }
            jSONObject.put((Object)"default_acr_values", (Object)jSONArray);
        }
        if (this.initiateLoginURI != null) {
            jSONObject.put((Object)"initiate_login_uri", (Object)this.initiateLoginURI.toString());
        }
        if (this.postLogoutRedirectURIs != null) {
            jSONArray = new JSONArray();
            for (URI uRI : this.postLogoutRedirectURIs) {
                jSONArray.add((Object)uRI.toString());
            }
            jSONObject.put((Object)"post_logout_redirect_uris", (Object)jSONArray);
        }
        return jSONObject;
    }

    public static OIDCClientMetadata parse(JSONObject jSONObject) throws ParseException {
        JSONObject jSONObject2;
        OIDCClientMetadata oIDCClientMetadata;
        block26: {
            ClientMetadata clientMetadata = ClientMetadata.parse((JSONObject)jSONObject);
            oIDCClientMetadata = new OIDCClientMetadata(clientMetadata);
            jSONObject2 = clientMetadata.getCustomFields();
            try {
                String string;
                int n2;
                int n3;
                String[] stringArray;
                AbstractCollection abstractCollection;
                if (jSONObject.get((Object)"application_type") != null) {
                    oIDCClientMetadata.setApplicationType((ApplicationType)JSONObjectUtils.getEnum((JSONObject)jSONObject, (String)"application_type", ApplicationType.class));
                    jSONObject2.remove((Object)"application_type");
                }
                if (jSONObject.get((Object)"subject_type") != null) {
                    oIDCClientMetadata.setSubjectType((SubjectType)JSONObjectUtils.getEnum((JSONObject)jSONObject, (String)"subject_type", SubjectType.class));
                    jSONObject2.remove((Object)"subject_type");
                }
                if (jSONObject.get((Object)"sector_identifier_uri") != null) {
                    oIDCClientMetadata.setSectorIDURI(JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"sector_identifier_uri"));
                    jSONObject2.remove((Object)"sector_identifier_uri");
                }
                if (jSONObject.get((Object)"request_uris") != null) {
                    abstractCollection = new LinkedHashSet<URI>();
                    stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"request_uris");
                    n3 = stringArray.length;
                    n2 = 0;
                    while (n2 < n3) {
                        string = stringArray[n2];
                        try {
                            abstractCollection.add(new URI(string));
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            throw new ParseException("Invalid \"request_uris\" parameter");
                        }
                        ++n2;
                    }
                    oIDCClientMetadata.setRequestObjectURIs(abstractCollection);
                    jSONObject2.remove((Object)"request_uris");
                }
                if (jSONObject.get((Object)"request_object_signing_alg") != null) {
                    oIDCClientMetadata.setRequestObjectJWSAlg(new JWSAlgorithm(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"request_object_signing_alg")));
                    jSONObject2.remove((Object)"request_object_signing_alg");
                }
                if (jSONObject.get((Object)"request_object_encryption_alg") != null) {
                    oIDCClientMetadata.setRequestObjectJWEAlg(new JWEAlgorithm(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"request_object_encryption_alg")));
                    jSONObject2.remove((Object)"request_object_encryption_alg");
                }
                if (jSONObject.get((Object)"request_object_encryption_enc") != null) {
                    oIDCClientMetadata.setRequestObjectJWEEnc(EncryptionMethod.parse((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)"request_object_encryption_enc")));
                    jSONObject2.remove((Object)"request_object_encryption_enc");
                }
                if (jSONObject.get((Object)"id_token_signed_response_alg") != null) {
                    oIDCClientMetadata.setIDTokenJWSAlg(new JWSAlgorithm(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"id_token_signed_response_alg")));
                    jSONObject2.remove((Object)"id_token_signed_response_alg");
                }
                if (jSONObject.get((Object)"id_token_encrypted_response_alg") != null) {
                    oIDCClientMetadata.setIDTokenJWEAlg(new JWEAlgorithm(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"id_token_encrypted_response_alg")));
                    jSONObject2.remove((Object)"id_token_encrypted_response_alg");
                }
                if (jSONObject.get((Object)"id_token_encrypted_response_enc") != null) {
                    oIDCClientMetadata.setIDTokenJWEEnc(EncryptionMethod.parse((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)"id_token_encrypted_response_enc")));
                    jSONObject2.remove((Object)"id_token_encrypted_response_enc");
                }
                if (jSONObject.get((Object)"userinfo_signed_response_alg") != null) {
                    oIDCClientMetadata.setUserInfoJWSAlg(new JWSAlgorithm(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"userinfo_signed_response_alg")));
                    jSONObject2.remove((Object)"userinfo_signed_response_alg");
                }
                if (jSONObject.get((Object)"userinfo_encrypted_response_alg") != null) {
                    oIDCClientMetadata.setUserInfoJWEAlg(new JWEAlgorithm(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"userinfo_encrypted_response_alg")));
                    jSONObject2.remove((Object)"userinfo_encrypted_response_alg");
                }
                if (jSONObject.get((Object)"userinfo_encrypted_response_enc") != null) {
                    oIDCClientMetadata.setUserInfoJWEEnc(EncryptionMethod.parse((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)"userinfo_encrypted_response_enc")));
                    jSONObject2.remove((Object)"userinfo_encrypted_response_enc");
                }
                if (jSONObject.get((Object)"default_max_age") != null) {
                    oIDCClientMetadata.setDefaultMaxAge(JSONObjectUtils.getInt((JSONObject)jSONObject, (String)"default_max_age"));
                    jSONObject2.remove((Object)"default_max_age");
                }
                if (jSONObject.get((Object)"require_auth_time") != null) {
                    oIDCClientMetadata.requiresAuthTime(JSONObjectUtils.getBoolean((JSONObject)jSONObject, (String)"require_auth_time"));
                    jSONObject2.remove((Object)"require_auth_time");
                }
                if (jSONObject.get((Object)"default_acr_values") != null) {
                    abstractCollection = new LinkedList();
                    stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"default_acr_values");
                    n3 = stringArray.length;
                    n2 = 0;
                    while (n2 < n3) {
                        string = stringArray[n2];
                        abstractCollection.add((ACR)new ACR(string));
                        ++n2;
                    }
                    oIDCClientMetadata.setDefaultACRs(abstractCollection);
                    jSONObject2.remove((Object)"default_acr_values");
                }
                if (jSONObject.get((Object)"initiate_login_uri") != null) {
                    oIDCClientMetadata.setInitiateLoginURI(JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"initiate_login_uri"));
                    jSONObject2.remove((Object)"initiate_login_uri");
                }
                if (jSONObject.get((Object)"post_logout_redirect_uris") == null) break block26;
                abstractCollection = new LinkedHashSet();
                stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"post_logout_redirect_uris");
                n3 = stringArray.length;
                n2 = 0;
                while (n2 < n3) {
                    string = stringArray[n2];
                    try {
                        abstractCollection.add(new URI(string));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new ParseException("Invalid \"post_logout_redirect_uris\" parameter");
                    }
                    ++n2;
                }
                oIDCClientMetadata.setPostLogoutRedirectionURIs((Set)((Object)abstractCollection));
                jSONObject2.remove((Object)"post_logout_redirect_uris");
            }
            catch (ParseException parseException) {
                throw new ParseException(parseException.getMessage(), RegistrationError.INVALID_CLIENT_METADATA.appendDescription(": " + parseException.getMessage()), parseException.getCause());
            }
        }
        oIDCClientMetadata.setCustomFields(jSONObject2);
        return oIDCClientMetadata;
    }

    public static /* bridge */ /* synthetic */ ClientMetadata parse(JSONObject jSONObject) throws ParseException {
        return OIDCClientMetadata.parse((JSONObject)jSONObject);
    }
}

