/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.op;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.GeneralException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.OAuth2Error;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.AuthenticationRequest;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.ClaimsRequest;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.ACR;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.ClaimRequirement;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.op.OIDCProviderMetadata;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.rp.OIDCClientInformation;
import net.jcip.annotations.Immutable;

@Immutable
public final class ACRRequest {
    private final List<ACR> essentialACRs;
    private final List<ACR> voluntaryACRs;

    public ACRRequest(List<ACR> list, List<ACR> list2) {
        this.essentialACRs = list;
        this.voluntaryACRs = list2;
    }

    public List<ACR> getEssentialACRs() {
        return this.essentialACRs;
    }

    public List<ACR> getVoluntaryACRs() {
        return this.voluntaryACRs;
    }

    public boolean isEmpty() {
        return !(this.essentialACRs != null && !this.essentialACRs.isEmpty() || this.voluntaryACRs != null && !this.voluntaryACRs.isEmpty());
    }

    public ACRRequest applyDefaultACRs(OIDCClientInformation oIDCClientInformation) {
        if (this.isEmpty() && oIDCClientInformation.getOIDCMetadata().getDefaultACRs() != null) {
            LinkedList linkedList = new LinkedList(oIDCClientInformation.getOIDCMetadata().getDefaultACRs());
            return new ACRRequest(null, linkedList);
        }
        return this;
    }

    public void ensureACRSupport(AuthenticationRequest authenticationRequest, OIDCProviderMetadata oIDCProviderMetadata) throws GeneralException {
        if (this.getEssentialACRs() != null) {
            boolean bl2 = false;
            for (String string : this.getEssentialACRs()) {
                if (oIDCProviderMetadata.getACRs() == null || !oIDCProviderMetadata.getACRs().contains(string)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                String string;
                string = "Requested essential ACR(s) not supported";
                throw new GeneralException(string, OAuth2Error.ACCESS_DENIED.appendDescription(": " + string), authenticationRequest.getClientID(), authenticationRequest.getRedirectionURI(), authenticationRequest.impliedResponseMode(), authenticationRequest.getState());
            }
        }
    }

    public static ACRRequest resolve(AuthenticationRequest authenticationRequest) {
        List list2;
        ArrayList<ACR> arrayList = null;
        ArrayList<ACR> arrayList2 = null;
        ClaimsRequest claimsRequest = authenticationRequest.getClaims();
        if (claimsRequest != null) {
            for (List list2 : claimsRequest.getIDTokenClaims()) {
                if (!list2.getClaimName().equals("acr")) continue;
                if (list2.getClaimRequirement().equals((Object)ClaimRequirement.ESSENTIAL)) {
                    arrayList = new ArrayList<ACR>();
                    if (list2.getValue() != null) {
                        arrayList.add(new ACR(list2.getValue()));
                    }
                    if (list2.getValues() == null) continue;
                    for (String string : list2.getValues()) {
                        arrayList.add(new ACR(string));
                    }
                    continue;
                }
                arrayList2 = new ArrayList();
                if (list2.getValue() != null) {
                    arrayList2.add(new ACR(list2.getValue()));
                }
                if (list2.getValues() == null) continue;
                for (String string : list2.getValues()) {
                    arrayList2.add(new ACR(string));
                }
            }
        }
        if ((list2 = authenticationRequest.getACRValues()) != null) {
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<ACR>();
            }
            arrayList2.addAll(list2);
        }
        return new ACRRequest(arrayList, (List)arrayList2);
    }
}

