/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.id;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Resource;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ResourceRetriever;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.GeneralException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONArrayUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;

public class SectorIDURIValidator {
    private final ResourceRetriever resourceRetriever;

    public SectorIDURIValidator(ResourceRetriever resourceRetriever) {
        if (resourceRetriever == null) {
            throw new IllegalArgumentException("The resource retriever must not be null");
        }
        this.resourceRetriever = resourceRetriever;
    }

    public ResourceRetriever getResourceRetriever() {
        return this.resourceRetriever;
    }

    public void validate(URI uRI, Set<URI> set) throws GeneralException {
        Resource resource;
        try {
            resource = this.resourceRetriever.retrieveResource(uRI.toURL());
        }
        catch (IOException iOException) {
            throw new GeneralException("Couldn't retrieve the sector ID JSON document: " + iOException.getMessage(), (Throwable)iOException);
        }
        if (resource.getContentType() == null) {
            throw new GeneralException("Couldn't validate sector ID URI: Missing Content-Type");
        }
        if (!resource.getContentType().toLowerCase().startsWith("application/json")) {
            throw new GeneralException("Couldn't validate sector ID URI: Content-Type must be application/json, found " + resource.getContentType());
        }
        List list = JSONArrayUtils.toURIList((JSONArray)JSONArrayUtils.parse((String)resource.getContent()));
        for (URI uRI2 : set) {
            if (list.contains(uRI2)) continue;
            throw new GeneralException("Sector ID URI validation failed: Redirect URI " + uRI2 + " is missing from published JSON array at sector ID URI " + uRI);
        }
    }
}

