/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.id;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Subject;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.id.PairwiseSubjectCodec;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.id.SectorID;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class HashBasedPairwiseSubjectCodec
extends PairwiseSubjectCodec {
    public static final String HASH_ALGORITHM = "SHA-256";

    public HashBasedPairwiseSubjectCodec(byte[] byArray) {
        super(byArray);
        if (byArray == null) {
            throw new IllegalArgumentException("The salt must not be null");
        }
    }

    public HashBasedPairwiseSubjectCodec(Base64URL base64URL) {
        super(base64URL.decode());
    }

    public Subject encode(SectorID sectorID, Subject subject) {
        MessageDigest messageDigest;
        try {
            messageDigest = this.getProvider() != null ? MessageDigest.getInstance(HASH_ALGORITHM, this.getProvider()) : MessageDigest.getInstance(HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        messageDigest.update(sectorID.getValue().getBytes(CHARSET));
        messageDigest.update(subject.getValue().getBytes(CHARSET));
        byte[] byArray = messageDigest.digest(this.getSalt());
        return new Subject(Base64URL.encode((byte[])byArray).toString());
    }
}

