/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims;

import com.nimbusds.langtag.LangTag;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Subject;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.Address;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.ClaimsSet;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.Gender;
import macromedia.externals.javax.mail_1_4_7.internet.InternetAddress;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;

public class UserInfo
extends ClaimsSet {
    public static final String SUB_CLAIM_NAME = "sub";
    public static final String NAME_CLAIM_NAME = "name";
    public static final String GIVEN_NAME_CLAIM_NAME = "given_name";
    public static final String FAMILY_NAME_CLAIM_NAME = "family_name";
    public static final String MIDDLE_NAME_CLAIM_NAME = "middle_name";
    public static final String NICKNAME_CLAIM_NAME = "nickname";
    public static final String PREFERRED_USERNAME_CLAIM_NAME = "preferred_username";
    public static final String PROFILE_CLAIM_NAME = "profile";
    public static final String PICTURE_CLAIM_NAME = "picture";
    public static final String WEBSITE_CLAIM_NAME = "website";
    public static final String EMAIL_CLAIM_NAME = "email";
    public static final String EMAIL_VERIFIED_CLAIM_NAME = "email_verified";
    public static final String GENDER_CLAIM_NAME = "gender";
    public static final String BIRTHDATE_CLAIM_NAME = "birthdate";
    public static final String ZONEINFO_CLAIM_NAME = "zoneinfo";
    public static final String LOCALE_CLAIM_NAME = "locale";
    public static final String PHONE_NUMBER_CLAIM_NAME = "phone_number";
    public static final String PHONE_NUMBER_VERIFIED_CLAIM_NAME = "phone_number_verified";
    public static final String ADDRESS_CLAIM_NAME = "address";
    public static final String UPDATED_AT_CLAIM_NAME = "updated_at";
    private static final Set<String> stdClaimNames = new LinkedHashSet();

    static {
        stdClaimNames.add(SUB_CLAIM_NAME);
        stdClaimNames.add(NAME_CLAIM_NAME);
        stdClaimNames.add(GIVEN_NAME_CLAIM_NAME);
        stdClaimNames.add(FAMILY_NAME_CLAIM_NAME);
        stdClaimNames.add(MIDDLE_NAME_CLAIM_NAME);
        stdClaimNames.add(NICKNAME_CLAIM_NAME);
        stdClaimNames.add(PREFERRED_USERNAME_CLAIM_NAME);
        stdClaimNames.add(PROFILE_CLAIM_NAME);
        stdClaimNames.add(PICTURE_CLAIM_NAME);
        stdClaimNames.add(WEBSITE_CLAIM_NAME);
        stdClaimNames.add(EMAIL_CLAIM_NAME);
        stdClaimNames.add(EMAIL_VERIFIED_CLAIM_NAME);
        stdClaimNames.add(GENDER_CLAIM_NAME);
        stdClaimNames.add(BIRTHDATE_CLAIM_NAME);
        stdClaimNames.add(ZONEINFO_CLAIM_NAME);
        stdClaimNames.add(LOCALE_CLAIM_NAME);
        stdClaimNames.add(PHONE_NUMBER_CLAIM_NAME);
        stdClaimNames.add(PHONE_NUMBER_VERIFIED_CLAIM_NAME);
        stdClaimNames.add(ADDRESS_CLAIM_NAME);
        stdClaimNames.add(UPDATED_AT_CLAIM_NAME);
    }

    public static Set<String> getStandardClaimNames() {
        return Collections.unmodifiableSet(stdClaimNames);
    }

    public UserInfo(Subject subject) {
        this.setClaim(SUB_CLAIM_NAME, (Object)subject.getValue());
    }

    public UserInfo(JSONObject jSONObject) {
        super(jSONObject);
        if (this.getStringClaim(SUB_CLAIM_NAME) == null) {
            throw new IllegalArgumentException("Missing or invalid \"sub\" claim");
        }
    }

    public UserInfo(JWTClaimsSet jWTClaimsSet) {
        this(jWTClaimsSet.toJSONObject());
    }

    public void putAll(UserInfo userInfo) {
        Subject subject = userInfo.getSubject();
        if (subject == null) {
            throw new IllegalArgumentException("The subject of the other UserInfo is missing");
        }
        if (!subject.equals((Object)this.getSubject())) {
            throw new IllegalArgumentException("The subject of the other UserInfo must be identical");
        }
        this.putAll((ClaimsSet)userInfo);
    }

    public Subject getSubject() {
        return new Subject(this.getStringClaim(SUB_CLAIM_NAME));
    }

    public String getName() {
        return this.getStringClaim(NAME_CLAIM_NAME);
    }

    public String getName(LangTag langTag) {
        return this.getStringClaim(NAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getNameEntries() {
        return this.getLangTaggedClaim(NAME_CLAIM_NAME, String.class);
    }

    public void setName(String string) {
        this.setClaim(NAME_CLAIM_NAME, (Object)string);
    }

    public void setName(String string, LangTag langTag) {
        this.setClaim(NAME_CLAIM_NAME, (Object)string, langTag);
    }

    public String getGivenName() {
        return this.getStringClaim(GIVEN_NAME_CLAIM_NAME);
    }

    public String getGivenName(LangTag langTag) {
        return this.getStringClaim(GIVEN_NAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getGivenNameEntries() {
        return this.getLangTaggedClaim(GIVEN_NAME_CLAIM_NAME, String.class);
    }

    public void setGivenName(String string) {
        this.setClaim(GIVEN_NAME_CLAIM_NAME, (Object)string);
    }

    public void setGivenName(String string, LangTag langTag) {
        this.setClaim(GIVEN_NAME_CLAIM_NAME, (Object)string, langTag);
    }

    public String getFamilyName() {
        return this.getStringClaim(FAMILY_NAME_CLAIM_NAME);
    }

    public String getFamilyName(LangTag langTag) {
        return this.getStringClaim(FAMILY_NAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getFamilyNameEntries() {
        return this.getLangTaggedClaim(FAMILY_NAME_CLAIM_NAME, String.class);
    }

    public void setFamilyName(String string) {
        this.setClaim(FAMILY_NAME_CLAIM_NAME, (Object)string);
    }

    public void setFamilyName(String string, LangTag langTag) {
        this.setClaim(FAMILY_NAME_CLAIM_NAME, (Object)string, langTag);
    }

    public String getMiddleName() {
        return this.getStringClaim(MIDDLE_NAME_CLAIM_NAME);
    }

    public String getMiddleName(LangTag langTag) {
        return this.getStringClaim(MIDDLE_NAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getMiddleNameEntries() {
        return this.getLangTaggedClaim(MIDDLE_NAME_CLAIM_NAME, String.class);
    }

    public void setMiddleName(String string) {
        this.setClaim(MIDDLE_NAME_CLAIM_NAME, (Object)string);
    }

    public void setMiddleName(String string, LangTag langTag) {
        this.setClaim(MIDDLE_NAME_CLAIM_NAME, (Object)string, langTag);
    }

    public String getNickname() {
        return this.getStringClaim(NICKNAME_CLAIM_NAME);
    }

    public String getNickname(LangTag langTag) {
        return this.getStringClaim(NICKNAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getNicknameEntries() {
        return this.getLangTaggedClaim(NICKNAME_CLAIM_NAME, String.class);
    }

    public void setNickname(String string) {
        this.setClaim(NICKNAME_CLAIM_NAME, (Object)string);
    }

    public void setNickname(String string, LangTag langTag) {
        this.setClaim(NICKNAME_CLAIM_NAME, (Object)string, langTag);
    }

    public String getPreferredUsername() {
        return this.getStringClaim(PREFERRED_USERNAME_CLAIM_NAME);
    }

    public void setPreferredUsername(String string) {
        this.setClaim(PREFERRED_USERNAME_CLAIM_NAME, (Object)string);
    }

    public URI getProfile() {
        return this.getURIClaim(PROFILE_CLAIM_NAME);
    }

    public void setProfile(URI uRI) {
        this.setURIClaim(PROFILE_CLAIM_NAME, uRI);
    }

    public URI getPicture() {
        return this.getURIClaim(PICTURE_CLAIM_NAME);
    }

    public void setPicture(URI uRI) {
        this.setURIClaim(PICTURE_CLAIM_NAME, uRI);
    }

    public URI getWebsite() {
        return this.getURIClaim(WEBSITE_CLAIM_NAME);
    }

    public void setWebsite(URI uRI) {
        this.setURIClaim(WEBSITE_CLAIM_NAME, uRI);
    }

    @Deprecated
    public InternetAddress getEmail() {
        return this.getEmailClaim(EMAIL_CLAIM_NAME);
    }

    @Deprecated
    public void setEmail(InternetAddress internetAddress) {
        this.setEmailClaim(EMAIL_CLAIM_NAME, internetAddress);
    }

    public String getEmailAddress() {
        return this.getStringClaim(EMAIL_CLAIM_NAME);
    }

    public void setEmailAddress(String string) {
        this.setClaim(EMAIL_CLAIM_NAME, (Object)string);
    }

    public Boolean getEmailVerified() {
        return this.getBooleanClaim(EMAIL_VERIFIED_CLAIM_NAME);
    }

    public void setEmailVerified(Boolean bl2) {
        this.setClaim(EMAIL_VERIFIED_CLAIM_NAME, (Object)bl2);
    }

    public Gender getGender() {
        String string = this.getStringClaim(GENDER_CLAIM_NAME);
        if (string == null) {
            return null;
        }
        return new Gender(string);
    }

    public void setGender(Gender gender) {
        if (gender != null) {
            this.setClaim(GENDER_CLAIM_NAME, (Object)gender.getValue());
        } else {
            this.setClaim(GENDER_CLAIM_NAME, null);
        }
    }

    public String getBirthdate() {
        return this.getStringClaim(BIRTHDATE_CLAIM_NAME);
    }

    public void setBirthdate(String string) {
        this.setClaim(BIRTHDATE_CLAIM_NAME, (Object)string);
    }

    public String getZoneinfo() {
        return this.getStringClaim(ZONEINFO_CLAIM_NAME);
    }

    public void setZoneinfo(String string) {
        this.setClaim(ZONEINFO_CLAIM_NAME, (Object)string);
    }

    public String getLocale() {
        return this.getStringClaim(LOCALE_CLAIM_NAME);
    }

    public void setLocale(String string) {
        this.setClaim(LOCALE_CLAIM_NAME, (Object)string);
    }

    public String getPhoneNumber() {
        return this.getStringClaim(PHONE_NUMBER_CLAIM_NAME);
    }

    public void setPhoneNumber(String string) {
        this.setClaim(PHONE_NUMBER_CLAIM_NAME, (Object)string);
    }

    public Boolean getPhoneNumberVerified() {
        return this.getBooleanClaim(PHONE_NUMBER_VERIFIED_CLAIM_NAME);
    }

    public void setPhoneNumberVerified(Boolean bl2) {
        this.setClaim(PHONE_NUMBER_VERIFIED_CLAIM_NAME, (Object)bl2);
    }

    public Address getAddress() {
        return this.getAddress(null);
    }

    public Address getAddress(LangTag langTag) {
        String string = langTag != null ? "address#" + langTag : ADDRESS_CLAIM_NAME;
        JSONObject jSONObject = (JSONObject)this.getClaim(string, JSONObject.class);
        if (jSONObject == null) {
            return null;
        }
        return new Address(jSONObject);
    }

    public Map<LangTag, Address> getAddressEntries() {
        Map map = this.getLangTaggedClaim(ADDRESS_CLAIM_NAME, JSONObject.class);
        HashMap<LangTag, Address> hashMap = new HashMap<LangTag, Address>();
        for (Map.Entry entry : map.entrySet()) {
            hashMap.put((LangTag)entry.getKey(), new Address((JSONObject)entry.getValue()));
        }
        return hashMap;
    }

    public void setAddress(Address address) {
        if (address != null) {
            this.setClaim(ADDRESS_CLAIM_NAME, (Object)address.toJSONObject());
        } else {
            this.setClaim(ADDRESS_CLAIM_NAME, null);
        }
    }

    public void setAddress(Address address, LangTag langTag) {
        String string;
        String string2 = string = langTag == null ? ADDRESS_CLAIM_NAME : "address#" + langTag;
        if (address != null) {
            this.setClaim(string, (Object)address.toJSONObject());
        } else {
            this.setClaim(string, null);
        }
    }

    public Date getUpdatedTime() {
        return this.getDateClaim(UPDATED_AT_CLAIM_NAME);
    }

    public void setUpdatedTime(Date date) {
        this.setDateClaim(UPDATED_AT_CLAIM_NAME, date);
    }

    public static UserInfo parse(String string) throws ParseException {
        JSONObject jSONObject = JSONObjectUtils.parse((String)string);
        try {
            return new UserInfo(jSONObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
    }
}

