/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWK;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Audience;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Issuer;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Subject;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.Nonce;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.ACR;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.AMR;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.AccessTokenHash;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.AuthorizedParty;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.ClaimsSet;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.CodeHash;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;

public class IDTokenClaimsSet
extends ClaimsSet {
    public static final String ISS_CLAIM_NAME = "iss";
    public static final String SUB_CLAIM_NAME = "sub";
    public static final String AUD_CLAIM_NAME = "aud";
    public static final String EXP_CLAIM_NAME = "exp";
    public static final String IAT_CLAIM_NAME = "iat";
    public static final String AUTH_TIME_CLAIM_NAME = "auth_time";
    public static final String NONCE_CLAIM_NAME = "nonce";
    public static final String AT_HASH_CLAIM_NAME = "at_hash";
    public static final String C_HASH_CLAIM_NAME = "c_hash";
    public static final String ACR_CLAIM_NAME = "acr";
    public static final String AMR_CLAIM_NAME = "amr";
    public static final String AZP_CLAIM_NAME = "azp";
    public static final String SUB_JWK_CLAIM_NAME = "sub_jwk";
    private static final Set<String> stdClaimNames = new LinkedHashSet();

    static {
        stdClaimNames.add(ISS_CLAIM_NAME);
        stdClaimNames.add(SUB_CLAIM_NAME);
        stdClaimNames.add(AUD_CLAIM_NAME);
        stdClaimNames.add(EXP_CLAIM_NAME);
        stdClaimNames.add(IAT_CLAIM_NAME);
        stdClaimNames.add(AUTH_TIME_CLAIM_NAME);
        stdClaimNames.add(NONCE_CLAIM_NAME);
        stdClaimNames.add(AT_HASH_CLAIM_NAME);
        stdClaimNames.add(C_HASH_CLAIM_NAME);
        stdClaimNames.add(ACR_CLAIM_NAME);
        stdClaimNames.add(AMR_CLAIM_NAME);
        stdClaimNames.add(AZP_CLAIM_NAME);
        stdClaimNames.add(SUB_JWK_CLAIM_NAME);
    }

    public static Set<String> getStandardClaimNames() {
        return Collections.unmodifiableSet(stdClaimNames);
    }

    public IDTokenClaimsSet(Issuer issuer, Subject subject, List<Audience> list, Date date, Date date2) {
        this.setClaim(ISS_CLAIM_NAME, (Object)issuer.getValue());
        this.setClaim(SUB_CLAIM_NAME, (Object)subject.getValue());
        JSONArray jSONArray = new JSONArray();
        for (Audience audience : list) {
            jSONArray.add((Object)audience.getValue());
        }
        this.setClaim(AUD_CLAIM_NAME, (Object)jSONArray);
        this.setDateClaim(EXP_CLAIM_NAME, date);
        this.setDateClaim(IAT_CLAIM_NAME, date2);
    }

    private IDTokenClaimsSet(JSONObject jSONObject) throws ParseException {
        super(jSONObject);
        if (this.getStringClaim(ISS_CLAIM_NAME) == null) {
            throw new ParseException("Missing or invalid \"iss\" claim");
        }
        if (this.getStringClaim(SUB_CLAIM_NAME) == null) {
            throw new ParseException("Missing or invalid \"sub\" claim");
        }
        if (this.getStringClaim(AUD_CLAIM_NAME) == null && this.getStringListClaim(AUD_CLAIM_NAME) == null || this.getStringListClaim(AUD_CLAIM_NAME) != null && this.getStringListClaim(AUD_CLAIM_NAME).isEmpty()) {
            throw new ParseException("Missing or invalid \"aud\" claim");
        }
        if (this.getDateClaim(EXP_CLAIM_NAME) == null) {
            throw new ParseException("Missing or invalid \"exp\" claim");
        }
        if (this.getDateClaim(IAT_CLAIM_NAME) == null) {
            throw new ParseException("Missing or invalid \"iat\" claim");
        }
    }

    public IDTokenClaimsSet(JWTClaimsSet jWTClaimsSet) throws ParseException {
        this(jWTClaimsSet.toJSONObject());
    }

    public boolean hasRequiredClaims(ResponseType responseType, boolean bl2) {
        if (new ResponseType(new String[]{"code"}).equals((Object)responseType)) {
            return true;
        }
        if (new ResponseType(new String[]{"id_token"}).equals((Object)responseType)) {
            return this.getNonce() != null;
        }
        if (new ResponseType(new String[]{"id_token", "token"}).equals((Object)responseType)) {
            if (this.getNonce() == null) {
                return false;
            }
            return this.getAccessTokenHash() != null;
        }
        if (new ResponseType(new String[]{"code", "id_token"}).equals((Object)responseType)) {
            if (this.getNonce() == null) {
                return false;
            }
            if (!bl2) {
                return true;
            }
            return this.getCodeHash() != null;
        }
        if (new ResponseType(new String[]{"code", "token"}).equals((Object)responseType)) {
            if (this.getNonce() == null) {
                return false;
            }
            if (!bl2) {
                return true;
            }
            return true;
        }
        if (new ResponseType(new String[]{"code", "id_token", "token"}).equals((Object)responseType)) {
            if (this.getNonce() == null) {
                return false;
            }
            if (!bl2) {
                return true;
            }
            if (this.getAccessTokenHash() == null) {
                return false;
            }
            return this.getCodeHash() != null;
        }
        throw new IllegalArgumentException("Unsupported response_type: " + responseType);
    }

    @Deprecated
    public boolean hasRequiredClaims(ResponseType responseType) {
        return this.hasRequiredClaims(responseType, true);
    }

    public Issuer getIssuer() {
        return new Issuer(this.getStringClaim(ISS_CLAIM_NAME));
    }

    public Subject getSubject() {
        return new Subject(this.getStringClaim(SUB_CLAIM_NAME));
    }

    public List<Audience> getAudience() {
        if (this.getClaim(AUD_CLAIM_NAME) instanceof String) {
            return new Audience(this.getStringClaim(AUD_CLAIM_NAME)).toSingleAudienceList();
        }
        List list = this.getStringListClaim(AUD_CLAIM_NAME);
        ArrayList<Audience> arrayList = new ArrayList<Audience>(list.size());
        for (String string : list) {
            arrayList.add(new Audience(string));
        }
        return arrayList;
    }

    public Date getExpirationTime() {
        return this.getDateClaim(EXP_CLAIM_NAME);
    }

    public Date getIssueTime() {
        return this.getDateClaim(IAT_CLAIM_NAME);
    }

    public Date getAuthenticationTime() {
        return this.getDateClaim(AUTH_TIME_CLAIM_NAME);
    }

    public void setAuthenticationTime(Date date) {
        this.setDateClaim(AUTH_TIME_CLAIM_NAME, date);
    }

    public Nonce getNonce() {
        String string = this.getStringClaim(NONCE_CLAIM_NAME);
        return string != null ? new Nonce(string) : null;
    }

    public void setNonce(Nonce nonce) {
        if (nonce != null) {
            this.setClaim(NONCE_CLAIM_NAME, (Object)nonce.getValue());
        } else {
            this.setClaim(NONCE_CLAIM_NAME, null);
        }
    }

    public AccessTokenHash getAccessTokenHash() {
        String string = this.getStringClaim(AT_HASH_CLAIM_NAME);
        return string != null ? new AccessTokenHash(string) : null;
    }

    public void setAccessTokenHash(AccessTokenHash accessTokenHash) {
        if (accessTokenHash != null) {
            this.setClaim(AT_HASH_CLAIM_NAME, (Object)accessTokenHash.getValue());
        } else {
            this.setClaim(AT_HASH_CLAIM_NAME, null);
        }
    }

    public CodeHash getCodeHash() {
        String string = this.getStringClaim(C_HASH_CLAIM_NAME);
        return string != null ? new CodeHash(string) : null;
    }

    public void setCodeHash(CodeHash codeHash) {
        if (codeHash != null) {
            this.setClaim(C_HASH_CLAIM_NAME, (Object)codeHash.getValue());
        } else {
            this.setClaim(C_HASH_CLAIM_NAME, null);
        }
    }

    public ACR getACR() {
        String string = this.getStringClaim(ACR_CLAIM_NAME);
        return string != null ? new ACR(string) : null;
    }

    public void setACR(ACR aCR) {
        if (aCR != null) {
            this.setClaim(ACR_CLAIM_NAME, (Object)aCR.getValue());
        } else {
            this.setClaim(ACR_CLAIM_NAME, null);
        }
    }

    public List<AMR> getAMR() {
        List list = this.getStringListClaim(AMR_CLAIM_NAME);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<AMR> arrayList = new ArrayList<AMR>(list.size());
        for (String string : list) {
            arrayList.add(new AMR(string));
        }
        return arrayList;
    }

    public void setAMR(List<AMR> list) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (AMR aMR : list) {
                arrayList.add(aMR.getValue());
            }
            this.setClaim(AMR_CLAIM_NAME, arrayList);
        } else {
            this.setClaim(AMR_CLAIM_NAME, null);
        }
    }

    public AuthorizedParty getAuthorizedParty() {
        String string = this.getStringClaim(AZP_CLAIM_NAME);
        return string != null ? new AuthorizedParty(string) : null;
    }

    public void setAuthorizedParty(AuthorizedParty authorizedParty) {
        if (authorizedParty != null) {
            this.setClaim(AZP_CLAIM_NAME, (Object)authorizedParty.getValue());
        } else {
            this.setClaim(AZP_CLAIM_NAME, null);
        }
    }

    public JWK getSubjectJWK() {
        JSONObject jSONObject = (JSONObject)this.getClaim(SUB_JWK_CLAIM_NAME, JSONObject.class);
        if (jSONObject == null) {
            return null;
        }
        try {
            return JWK.parse((JSONObject)jSONObject);
        }
        catch (java.text.ParseException parseException) {
            return null;
        }
    }

    public void setSubjectJWK(JWK jWK) {
        if (jWK != null) {
            if (jWK.isPrivate()) {
                throw new IllegalArgumentException("The subject's JSON Web Key (JWK) must be public");
            }
            this.setClaim(SUB_JWK_CLAIM_NAME, (Object)jWK.toJSONObject());
        } else {
            this.setClaim(SUB_JWK_CLAIM_NAME, null);
        }
    }

    public static IDTokenClaimsSet parse(String string) throws ParseException {
        JSONObject jSONObject = JSONObjectUtils.parse((String)string);
        try {
            return new IDTokenClaimsSet(jSONObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
    }
}

