/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagUtils;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.DateUtils;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.javax.mail_1_4_7.internet.InternetAddress;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;

public abstract class ClaimsSet {
    private final JSONObject claims;

    protected ClaimsSet() {
        this.claims = new JSONObject();
    }

    protected ClaimsSet(JSONObject jSONObject) {
        if (jSONObject == null) {
            throw new IllegalArgumentException("The JSON object must not be null");
        }
        this.claims = jSONObject;
    }

    public void putAll(ClaimsSet claimsSet) {
        this.putAll((Map)claimsSet.claims);
    }

    public void putAll(Map<String, Object> map) {
        this.claims.putAll(map);
    }

    public Object getClaim(String string) {
        return this.claims.get((Object)string);
    }

    public <T> T getClaim(String string, Class<T> clazz) {
        try {
            return (T)JSONObjectUtils.getGeneric((JSONObject)this.claims, (String)string, clazz);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public <T> Map<LangTag, T> getLangTaggedClaim(String string, Class<T> clazz) {
        Map map = LangTagUtils.find((String)string, (Map)this.claims);
        HashMap<LangTag, Object> hashMap = new HashMap<LangTag, Object>();
        for (Map.Entry entry : map.entrySet()) {
            LangTag langTag = (LangTag)entry.getKey();
            String string2 = String.valueOf(string) + (langTag != null ? "#" + langTag : "");
            try {
                hashMap.put(langTag, JSONObjectUtils.getGeneric((JSONObject)this.claims, (String)string2, clazz));
            }
            catch (ParseException parseException) {}
        }
        return hashMap;
    }

    public void setClaim(String string, Object object) {
        if (object != null) {
            this.claims.put((Object)string, object);
        } else {
            this.claims.remove((Object)string);
        }
    }

    public void setClaim(String string, Object object, LangTag langTag) {
        String string2 = langTag != null ? String.valueOf(string) + "#" + langTag : string;
        this.setClaim(string2, object);
    }

    public String getStringClaim(String string) {
        try {
            return JSONObjectUtils.getString((JSONObject)this.claims, (String)string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public String getStringClaim(String string, LangTag langTag) {
        return langTag == null ? this.getStringClaim(string) : this.getStringClaim(String.valueOf(string) + '#' + langTag);
    }

    public Boolean getBooleanClaim(String string) {
        try {
            return JSONObjectUtils.getBoolean((JSONObject)this.claims, (String)string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Number getNumberClaim(String string) {
        try {
            return JSONObjectUtils.getNumber((JSONObject)this.claims, (String)string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public URL getURLClaim(String string) {
        try {
            return JSONObjectUtils.getURL((JSONObject)this.claims, (String)string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setURLClaim(String string, URL uRL) {
        if (uRL != null) {
            this.setClaim(string, (Object)uRL.toString());
        } else {
            this.claims.remove((Object)string);
        }
    }

    public URI getURIClaim(String string) {
        try {
            return JSONObjectUtils.getURI((JSONObject)this.claims, (String)string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setURIClaim(String string, URI uRI) {
        if (uRI != null) {
            this.setClaim(string, (Object)uRI.toString());
        } else {
            this.claims.remove((Object)string);
        }
    }

    @Deprecated
    public InternetAddress getEmailClaim(String string) {
        try {
            return JSONObjectUtils.getEmail((JSONObject)this.claims, (String)string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Deprecated
    public void setEmailClaim(String string, InternetAddress internetAddress) {
        if (internetAddress != null) {
            this.setClaim(string, (Object)internetAddress.getAddress());
        } else {
            this.claims.remove((Object)string);
        }
    }

    public Date getDateClaim(String string) {
        try {
            return DateUtils.fromSecondsSinceEpoch((long)JSONObjectUtils.getNumber((JSONObject)this.claims, (String)string).longValue());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDateClaim(String string, Date date) {
        if (date != null) {
            this.setClaim(string, (Object)DateUtils.toSecondsSinceEpoch((Date)date));
        } else {
            this.claims.remove((Object)string);
        }
    }

    public List<String> getStringListClaim(String string) {
        try {
            return Arrays.asList(JSONObjectUtils.getStringArray((JSONObject)this.claims, (String)string));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public JSONObject toJSONObject() {
        return this.claims;
    }

    public JWTClaimsSet toJWTClaimsSet() throws ParseException {
        try {
            return JWTClaimsSet.parse((JSONObject)this.claims);
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException.getMessage(), (Throwable)parseException);
        }
    }
}

