/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1;

import macromedia.externals.com.nimbusds.jwt_8_2_1.JWT;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SuccessResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPResponse;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.UserInfoResponse;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.UserInfo;
import macromedia.externals.javax.mail_1_4_7.internet.ContentType;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class UserInfoSuccessResponse
extends UserInfoResponse
implements SuccessResponse {
    private final UserInfo claimsSet;
    private final JWT jwt;

    public UserInfoSuccessResponse(UserInfo userInfo) {
        if (userInfo == null) {
            throw new IllegalArgumentException("The claims must not be null");
        }
        this.claimsSet = userInfo;
        this.jwt = null;
    }

    public UserInfoSuccessResponse(JWT jWT) {
        if (jWT == null) {
            throw new IllegalArgumentException("The claims JWT must not be null");
        }
        this.jwt = jWT;
        this.claimsSet = null;
    }

    public boolean indicatesSuccess() {
        return true;
    }

    public ContentType getContentType() {
        if (this.claimsSet != null) {
            return CommonContentTypes.APPLICATION_JSON;
        }
        return CommonContentTypes.APPLICATION_JWT;
    }

    public UserInfo getUserInfo() {
        return this.claimsSet;
    }

    public JWT getUserInfoJWT() {
        return this.jwt;
    }

    public HTTPResponse toHTTPResponse() {
        String string;
        HTTPResponse hTTPResponse = new HTTPResponse(200);
        hTTPResponse.setContentType(this.getContentType());
        if (this.claimsSet != null) {
            string = this.claimsSet.toJSONObject().toString();
        } else {
            try {
                string = this.jwt.serialize();
            }
            catch (IllegalStateException illegalStateException) {
                throw new SerializeException("Couldn't serialize UserInfo claims JWT: " + illegalStateException.getMessage(), (Throwable)illegalStateException);
            }
        }
        hTTPResponse.setContent(string);
        return hTTPResponse;
    }

    public static UserInfoSuccessResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        UserInfoSuccessResponse userInfoSuccessResponse;
        hTTPResponse.ensureStatusCode(new int[]{200});
        hTTPResponse.ensureContentType();
        ContentType contentType = hTTPResponse.getContentType();
        if (contentType.match(CommonContentTypes.APPLICATION_JSON)) {
            UserInfo userInfo;
            try {
                userInfo = new UserInfo(hTTPResponse.getContentAsJSONObject());
            }
            catch (Exception exception) {
                throw new ParseException("Couldn't parse UserInfo claims: " + exception.getMessage(), (Throwable)exception);
            }
            userInfoSuccessResponse = new UserInfoSuccessResponse(userInfo);
        } else if (contentType.match(CommonContentTypes.APPLICATION_JWT)) {
            JWT jWT;
            try {
                jWT = hTTPResponse.getContentAsJWT();
            }
            catch (ParseException parseException) {
                throw new ParseException("Couldn't parse UserInfo claims JWT: " + parseException.getMessage(), (Throwable)parseException);
            }
            userInfoSuccessResponse = new UserInfoSuccessResponse(jWT);
        } else {
            throw new ParseException("Unexpected Content-Type, must be " + CommonContentTypes.APPLICATION_JSON + " or " + CommonContentTypes.APPLICATION_JWT);
        }
        return userInfoSuccessResponse;
    }

    public static /* bridge */ /* synthetic */ UserInfoResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        return UserInfoSuccessResponse.parse((HTTPResponse)hTTPResponse);
    }
}

