/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ErrorObject;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ErrorResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.BearerTokenError;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.UserInfoResponse;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class UserInfoErrorResponse
extends UserInfoResponse
implements ErrorResponse {
    private final ErrorObject error;

    public static Set<BearerTokenError> getStandardErrors() {
        HashSet<BearerTokenError> hashSet = new HashSet<BearerTokenError>();
        hashSet.add(BearerTokenError.MISSING_TOKEN);
        hashSet.add(BearerTokenError.INVALID_REQUEST);
        hashSet.add(BearerTokenError.INVALID_TOKEN);
        hashSet.add(BearerTokenError.INSUFFICIENT_SCOPE);
        return Collections.unmodifiableSet(hashSet);
    }

    private UserInfoErrorResponse() {
        this.error = null;
    }

    public UserInfoErrorResponse(BearerTokenError bearerTokenError) {
        this((ErrorObject)bearerTokenError);
    }

    public UserInfoErrorResponse(ErrorObject errorObject) {
        if (errorObject == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = errorObject;
    }

    public boolean indicatesSuccess() {
        return false;
    }

    public ErrorObject getErrorObject() {
        return this.error;
    }

    public HTTPResponse toHTTPResponse() {
        HTTPResponse hTTPResponse = this.error != null && this.error.getHTTPStatusCode() > 0 ? new HTTPResponse(this.error.getHTTPStatusCode()) : new HTTPResponse(400);
        if (this.error instanceof BearerTokenError) {
            hTTPResponse.setWWWAuthenticate(((BearerTokenError)this.error).toWWWAuthenticateHeader());
        } else if (this.error != null) {
            hTTPResponse.setContentType(CommonContentTypes.APPLICATION_JSON);
            hTTPResponse.setContent(this.error.toJSONObject().toJSONString());
        }
        return hTTPResponse;
    }

    public static UserInfoErrorResponse parse(String string) throws ParseException {
        BearerTokenError bearerTokenError = BearerTokenError.parse((String)string);
        return new UserInfoErrorResponse(bearerTokenError);
    }

    public static UserInfoErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCodeNotOK();
        String string = hTTPResponse.getWWWAuthenticate();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            return UserInfoErrorResponse.parse((String)string);
        }
        return new UserInfoErrorResponse(ErrorObject.parse((HTTPResponse)hTTPResponse));
    }

    public static /* bridge */ /* synthetic */ UserInfoResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        return UserInfoErrorResponse.parse((HTTPResponse)hTTPResponse);
    }
}

