/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1;

import com.nimbusds.langtag.LangTag;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.Scope;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.AuthenticationRequest;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.ClaimsRequest;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.OIDCResponseTypeValue;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.OIDCScopeValue;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.ClaimRequirement;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import macromedia.externals.org.apache.commons_3_5.lang3.tuple.ImmutablePair;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClaimsRequest {
    private final Map<ImmutablePair<String, LangTag>, Entry> idTokenClaims = new HashMap();
    private final Map<ImmutablePair<String, LangTag>, Entry> userInfoClaims = new HashMap();

    public void add(ClaimsRequest claimsRequest) {
        if (claimsRequest == null) {
            return;
        }
        this.idTokenClaims.putAll(claimsRequest.idTokenClaims);
        this.userInfoClaims.putAll(claimsRequest.userInfoClaims);
    }

    public void addIDTokenClaim(String string) {
        this.addIDTokenClaim(string, ClaimRequirement.VOLUNTARY);
    }

    public void addIDTokenClaim(String string, ClaimRequirement claimRequirement) {
        this.addIDTokenClaim(string, claimRequirement, null);
    }

    public void addIDTokenClaim(String string, ClaimRequirement claimRequirement, LangTag langTag) {
        this.addIDTokenClaim(string, claimRequirement, langTag, null);
    }

    public void addIDTokenClaim(String string, ClaimRequirement claimRequirement, LangTag langTag, String string2) {
        this.addIDTokenClaim(new Entry(string, claimRequirement, langTag, string2));
    }

    public void addIDTokenClaim(String string, ClaimRequirement claimRequirement, LangTag langTag, List<String> list) {
        this.addIDTokenClaim(new Entry(string, claimRequirement, langTag, list));
    }

    public void addIDTokenClaim(Entry entry) {
        ImmutablePair immutablePair = new ImmutablePair((Object)entry.getClaimName(), (Object)entry.getLangTag());
        this.idTokenClaims.put(immutablePair, entry);
    }

    public Collection<Entry> getIDTokenClaims() {
        return Collections.unmodifiableCollection(this.idTokenClaims.values());
    }

    public Set<String> getIDTokenClaimNames(boolean bl2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Entry entry : this.idTokenClaims.values()) {
            hashSet.add(entry.getClaimName(bl2));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Entry removeIDTokenClaim(String string, LangTag langTag) {
        ImmutablePair immutablePair = new ImmutablePair((Object)string, (Object)langTag);
        return (Entry)this.idTokenClaims.remove(immutablePair);
    }

    public Collection<Entry> removeIDTokenClaims(String string) {
        LinkedList<Entry> linkedList = new LinkedList<Entry>();
        Iterator iterator = this.idTokenClaims.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((String)((ImmutablePair)entry.getKey()).getLeft()).equals(string)) continue;
            linkedList.add((Entry)entry.getValue());
            iterator.remove();
        }
        return Collections.unmodifiableCollection(linkedList);
    }

    public void addUserInfoClaim(String string) {
        this.addUserInfoClaim(string, ClaimRequirement.VOLUNTARY);
    }

    public void addUserInfoClaim(String string, ClaimRequirement claimRequirement) {
        this.addUserInfoClaim(string, claimRequirement, null);
    }

    public void addUserInfoClaim(String string, ClaimRequirement claimRequirement, LangTag langTag) {
        this.addUserInfoClaim(string, claimRequirement, langTag, null);
    }

    public void addUserInfoClaim(String string, ClaimRequirement claimRequirement, LangTag langTag, String string2) {
        this.addUserInfoClaim(new Entry(string, claimRequirement, langTag, string2));
    }

    public void addUserInfoClaim(String string, ClaimRequirement claimRequirement, LangTag langTag, List<String> list) {
        this.addUserInfoClaim(new Entry(string, claimRequirement, langTag, list));
    }

    public void addUserInfoClaim(Entry entry) {
        ImmutablePair immutablePair = new ImmutablePair((Object)entry.getClaimName(), (Object)entry.getLangTag());
        this.userInfoClaims.put(immutablePair, entry);
    }

    public Collection<Entry> getUserInfoClaims() {
        return Collections.unmodifiableCollection(this.userInfoClaims.values());
    }

    public Set<String> getUserInfoClaimNames(boolean bl2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Entry entry : this.userInfoClaims.values()) {
            hashSet.add(entry.getClaimName(bl2));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Entry removeUserInfoClaim(String string, LangTag langTag) {
        ImmutablePair immutablePair = new ImmutablePair((Object)string, (Object)langTag);
        return (Entry)this.userInfoClaims.remove(immutablePair);
    }

    public Collection<Entry> removeUserInfoClaims(String string) {
        LinkedList<Entry> linkedList = new LinkedList<Entry>();
        Iterator iterator = this.userInfoClaims.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((String)((ImmutablePair)entry.getKey()).getLeft()).equals(string)) continue;
            linkedList.add((Entry)entry.getValue());
            iterator.remove();
        }
        return Collections.unmodifiableCollection(linkedList);
    }

    public JSONObject toJSONObject() {
        Collection collection;
        JSONObject jSONObject = new JSONObject();
        Collection collection2 = this.getIDTokenClaims();
        if (!collection2.isEmpty()) {
            jSONObject.put((Object)"id_token", (Object)Entry.toJSONObject((Collection)collection2));
        }
        if (!(collection = this.getUserInfoClaims()).isEmpty()) {
            jSONObject.put((Object)"userinfo", (Object)Entry.toJSONObject((Collection)collection));
        }
        return jSONObject;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static ClaimsRequest resolve(ResponseType responseType, Scope scope) {
        return ClaimsRequest.resolve((ResponseType)responseType, (Scope)scope, Collections.emptyMap());
    }

    public static ClaimsRequest resolve(ResponseType responseType, Scope scope, Map<Scope.Value, Set<String>> map) {
        boolean bl2 = responseType.contains((Object)OIDCResponseTypeValue.ID_TOKEN) && !responseType.contains((Object)ResponseType.Value.CODE) && !responseType.contains((Object)ResponseType.Value.TOKEN);
        ClaimsRequest claimsRequest = new ClaimsRequest();
        for (Scope.Value value : scope) {
            Object object2;
            HashSet<Entry> hashSet;
            if (value.equals((Object)OIDCScopeValue.PROFILE)) {
                hashSet = OIDCScopeValue.PROFILE.toClaimsRequestEntries();
            } else if (value.equals((Object)OIDCScopeValue.EMAIL)) {
                hashSet = OIDCScopeValue.EMAIL.toClaimsRequestEntries();
            } else if (value.equals((Object)OIDCScopeValue.PHONE)) {
                hashSet = OIDCScopeValue.PHONE.toClaimsRequestEntries();
            } else if (value.equals((Object)OIDCScopeValue.ADDRESS)) {
                hashSet = OIDCScopeValue.ADDRESS.toClaimsRequestEntries();
            } else {
                Set<String> set;
                if (map == null || !map.containsKey(value) || (set = map.get(value)) == null || set.isEmpty()) continue;
                hashSet = new HashSet<Entry>();
                for (Object object2 : set) {
                    hashSet.add(new Entry((String)object2, ClaimRequirement.VOLUNTARY));
                }
            }
            object2 = hashSet.iterator();
            while (object2.hasNext()) {
                Entry entry = (Entry)object2.next();
                if (bl2) {
                    claimsRequest.addIDTokenClaim(entry);
                    continue;
                }
                claimsRequest.addUserInfoClaim(entry);
            }
        }
        return claimsRequest;
    }

    public static ClaimsRequest resolve(ResponseType responseType, Scope scope, ClaimsRequest claimsRequest) {
        return ClaimsRequest.resolve((ResponseType)responseType, (Scope)scope, (ClaimsRequest)claimsRequest, Collections.emptyMap());
    }

    public static ClaimsRequest resolve(ResponseType responseType, Scope scope, ClaimsRequest claimsRequest, Map<Scope.Value, Set<String>> map) {
        ClaimsRequest claimsRequest2 = ClaimsRequest.resolve((ResponseType)responseType, (Scope)scope, map);
        claimsRequest2.add(claimsRequest);
        return claimsRequest2;
    }

    public static ClaimsRequest resolve(AuthenticationRequest authenticationRequest) {
        return ClaimsRequest.resolve((ResponseType)authenticationRequest.getResponseType(), (Scope)authenticationRequest.getScope(), (ClaimsRequest)authenticationRequest.getClaims());
    }

    public static ClaimsRequest parse(JSONObject jSONObject) {
        ClaimsRequest claimsRequest = new ClaimsRequest();
        try {
            Collection collection;
            JSONObject jSONObject2;
            if (jSONObject.containsKey((Object)"id_token")) {
                jSONObject2 = (JSONObject)jSONObject.get((Object)"id_token");
                collection = Entry.parseEntries((JSONObject)jSONObject2);
                for (Entry entry : collection) {
                    claimsRequest.addIDTokenClaim(entry);
                }
            }
            if (jSONObject.containsKey((Object)"userinfo")) {
                jSONObject2 = (JSONObject)jSONObject.get((Object)"userinfo");
                collection = Entry.parseEntries((JSONObject)jSONObject2);
                for (Entry entry : collection) {
                    claimsRequest.addUserInfoClaim(entry);
                }
            }
        }
        catch (Exception exception) {}
        return claimsRequest;
    }

    public static ClaimsRequest parse(String string) throws ParseException {
        return ClaimsRequest.parse((JSONObject)JSONObjectUtils.parse((String)string));
    }
}

