/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationErrorResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ErrorObject;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseMode;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.State;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.AuthenticationResponse;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.OIDCError;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class AuthenticationErrorResponse
extends AuthorizationErrorResponse
implements AuthenticationResponse {
    private static final Set<ErrorObject> stdErrors = new HashSet();

    static {
        stdErrors.addAll(AuthorizationErrorResponse.getStandardErrors());
        stdErrors.add(OIDCError.INTERACTION_REQUIRED);
        stdErrors.add(OIDCError.LOGIN_REQUIRED);
        stdErrors.add(OIDCError.ACCOUNT_SELECTION_REQUIRED);
        stdErrors.add(OIDCError.CONSENT_REQUIRED);
        stdErrors.add(OIDCError.INVALID_REQUEST_URI);
        stdErrors.add(OIDCError.INVALID_REQUEST_OBJECT);
        stdErrors.add(OIDCError.REGISTRATION_NOT_SUPPORTED);
        stdErrors.add(OIDCError.REQUEST_NOT_SUPPORTED);
        stdErrors.add(OIDCError.REQUEST_URI_NOT_SUPPORTED);
    }

    public static Set<ErrorObject> getStandardErrors() {
        return Collections.unmodifiableSet(stdErrors);
    }

    public AuthenticationErrorResponse(URI uRI, ErrorObject errorObject, State state, ResponseMode responseMode) {
        super(uRI, errorObject, state, responseMode);
    }

    public static AuthenticationErrorResponse parse(URI uRI, Map<String, String> map) throws ParseException {
        AuthorizationErrorResponse authorizationErrorResponse = AuthorizationErrorResponse.parse((URI)uRI, map);
        return new AuthenticationErrorResponse(authorizationErrorResponse.getRedirectionURI(), authorizationErrorResponse.getErrorObject(), authorizationErrorResponse.getState(), null);
    }

    public static AuthenticationErrorResponse parse(URI uRI) throws ParseException {
        AuthorizationErrorResponse authorizationErrorResponse = AuthorizationErrorResponse.parse((URI)uRI);
        return new AuthenticationErrorResponse(authorizationErrorResponse.getRedirectionURI(), authorizationErrorResponse.getErrorObject(), authorizationErrorResponse.getState(), null);
    }

    public static AuthenticationErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        AuthorizationErrorResponse authorizationErrorResponse = AuthorizationErrorResponse.parse((HTTPResponse)hTTPResponse);
        return new AuthenticationErrorResponse(authorizationErrorResponse.getRedirectionURI(), authorizationErrorResponse.getErrorObject(), authorizationErrorResponse.getState(), null);
    }

    public static AuthenticationErrorResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        URI uRI;
        try {
            uRI = hTTPRequest.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
        if (hTTPRequest.getQuery() != null) {
            return AuthenticationErrorResponse.parse((URI)uRI, (Map)URLUtils.parseParameters((String)hTTPRequest.getQuery()));
        }
        if (hTTPRequest.getFragment() != null) {
            return AuthenticationErrorResponse.parse((URI)uRI, (Map)URLUtils.parseParameters((String)hTTPRequest.getFragment()));
        }
        throw new ParseException("Missing URI fragment, query string or post body");
    }

    public static /* bridge */ /* synthetic */ AuthorizationErrorResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        return AuthenticationErrorResponse.parse((HTTPRequest)hTTPRequest);
    }

    public static /* bridge */ /* synthetic */ AuthorizationErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        return AuthenticationErrorResponse.parse((HTTPResponse)hTTPResponse);
    }

    public static /* bridge */ /* synthetic */ AuthorizationErrorResponse parse(URI uRI) throws ParseException {
        return AuthenticationErrorResponse.parse((URI)uRI);
    }

    public static /* bridge */ /* synthetic */ AuthorizationErrorResponse parse(URI uRI, Map map) throws ParseException {
        return AuthenticationErrorResponse.parse((URI)uRI, (Map)map);
    }
}

