/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token;

import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.AccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.BearerAccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.RefreshToken;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

@Immutable
public class Tokens {
    private final AccessToken accessToken;
    private final RefreshToken refreshToken;

    public Tokens(AccessToken accessToken, RefreshToken refreshToken) {
        if (accessToken == null) {
            throw new IllegalArgumentException("The access token must not be null");
        }
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public BearerAccessToken getBearerAccessToken() {
        if (this.accessToken instanceof BearerAccessToken) {
            return (BearerAccessToken)this.accessToken;
        }
        return null;
    }

    public RefreshToken getRefreshToken() {
        return this.refreshToken;
    }

    public Set<String> getParameterNames() {
        Set set = this.accessToken.getParameterNames();
        if (this.refreshToken != null) {
            set.addAll(this.refreshToken.getParameterNames());
        }
        return set;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = this.accessToken.toJSONObject();
        if (this.refreshToken != null) {
            jSONObject.putAll((Map)this.refreshToken.toJSONObject());
        }
        return jSONObject;
    }

    public String toString() {
        return this.toJSONObject().toJSONString();
    }

    public static Tokens parse(JSONObject jSONObject) throws ParseException {
        return new Tokens(AccessToken.parse((JSONObject)jSONObject), RefreshToken.parse((JSONObject)jSONObject));
    }
}

