/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token;

import java.util.Map;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ErrorObject;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.Scope;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.AccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.AccessTokenType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.BearerTokenError;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public final class BearerAccessToken
extends AccessToken {
    public BearerAccessToken() {
        this(32);
    }

    public BearerAccessToken(int n2) {
        this(n2, 0L, null);
    }

    public BearerAccessToken(long l2, Scope scope) {
        this(32, l2, scope);
    }

    public BearerAccessToken(int n2, long l2, Scope scope) {
        super(AccessTokenType.BEARER, n2, l2, scope);
    }

    public BearerAccessToken(String string) {
        this(string, 0L, null);
    }

    public BearerAccessToken(String string, long l2, Scope scope) {
        super(AccessTokenType.BEARER, string, l2, scope);
    }

    public String toAuthorizationHeader() {
        return "Bearer " + this.getValue();
    }

    public boolean equals(Object object) {
        return object instanceof BearerAccessToken && this.toString().equals(object.toString());
    }

    public static BearerAccessToken parse(JSONObject jSONObject) throws ParseException {
        String string;
        AccessTokenType accessTokenType = new AccessTokenType(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"token_type"));
        if (!accessTokenType.equals((Object)AccessTokenType.BEARER)) {
            throw new ParseException("Token type must be \"Bearer\"");
        }
        String string2 = JSONObjectUtils.getString((JSONObject)jSONObject, (String)"access_token");
        long l2 = 0L;
        if (jSONObject.containsKey((Object)"expires_in")) {
            if (jSONObject.get((Object)"expires_in") instanceof Number) {
                l2 = JSONObjectUtils.getLong((JSONObject)jSONObject, (String)"expires_in");
            } else {
                string = JSONObjectUtils.getString((JSONObject)jSONObject, (String)"expires_in");
                try {
                    l2 = new Long(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Invalid \"expires_in\" parameter, must be integer");
                }
            }
        }
        string = null;
        if (jSONObject.containsKey((Object)"scope")) {
            string = Scope.parse((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)"scope"));
        }
        return new BearerAccessToken(string2, l2, (Scope)string);
    }

    public static BearerAccessToken parse(String string) throws ParseException {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new ParseException("Missing HTTP Authorization header", (ErrorObject)BearerTokenError.MISSING_TOKEN);
        }
        String[] stringArray = string.split("\\s", 2);
        if (stringArray.length != 2) {
            throw new ParseException("Invalid HTTP Authorization header value", (ErrorObject)BearerTokenError.INVALID_REQUEST);
        }
        if (!stringArray[0].equals("Bearer")) {
            throw new ParseException("Token type must be \"Bearer\"", (ErrorObject)BearerTokenError.INVALID_REQUEST);
        }
        try {
            return new BearerAccessToken(stringArray[1]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), (ErrorObject)BearerTokenError.INVALID_REQUEST);
        }
    }

    public static BearerAccessToken parse(HTTPRequest hTTPRequest) throws ParseException {
        String string = hTTPRequest.getAuthorization();
        if (string != null) {
            return BearerAccessToken.parse((String)string);
        }
        Map map = hTTPRequest.getQueryParameters();
        String string2 = (String)map.get("access_token");
        if (StringUtils.isBlank((CharSequence)string2)) {
            throw new ParseException("Missing access token value", (ErrorObject)BearerTokenError.MISSING_TOKEN);
        }
        return new BearerAccessToken(string2);
    }

    public static /* bridge */ /* synthetic */ AccessToken parse(String string) throws ParseException {
        return BearerAccessToken.parse((String)string);
    }

    public static /* bridge */ /* synthetic */ AccessToken parse(JSONObject jSONObject) throws ParseException {
        return BearerAccessToken.parse((JSONObject)jSONObject);
    }
}

