/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.pkce;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Identifier;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.pkce.CodeChallengeMethod;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.pkce.CodeVerifier;

public class CodeChallenge
extends Identifier {
    private CodeChallenge(String string) {
        super(string);
    }

    public static CodeChallenge compute(CodeChallengeMethod codeChallengeMethod, CodeVerifier codeVerifier) {
        if (CodeChallengeMethod.PLAIN.equals((Object)codeChallengeMethod)) {
            return new CodeChallenge(codeVerifier.getValue());
        }
        if (CodeChallengeMethod.S256.equals((Object)codeChallengeMethod)) {
            MessageDigest messageDigest;
            try {
                messageDigest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalStateException(noSuchAlgorithmException.getMessage());
            }
            byte[] byArray = messageDigest.digest(codeVerifier.getValueBytes());
            return new CodeChallenge(Base64URL.encode((byte[])byArray).toString());
        }
        throw new IllegalArgumentException("Unsupported code challenge method: " + codeChallengeMethod);
    }

    public static CodeChallenge parse(String string) throws ParseException {
        try {
            return new CodeChallenge(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException("Invalid code challenge: " + illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
        }
    }
}

