/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.jose;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ByteUtils;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.Secret;

/*
 * Exception performing whole class analysis ignored.
 */
public class SecretKeyDerivation {
    public static SecretKey deriveSecretKey(Secret secret, JWEAlgorithm jWEAlgorithm, EncryptionMethod encryptionMethod) throws JOSEException {
        if (JWEAlgorithm.DIR.equals((Object)jWEAlgorithm)) {
            int n2 = encryptionMethod.cekBitLength();
            if (n2 == 0) {
                throw new JOSEException("Unsupported JWE method: enc=" + encryptionMethod);
            }
            return SecretKeyDerivation.deriveSecretKey((Secret)secret, (int)encryptionMethod.cekBitLength());
        }
        if (JWEAlgorithm.Family.AES_KW.contains((Object)jWEAlgorithm)) {
            if (JWEAlgorithm.A128KW.equals((Object)jWEAlgorithm)) {
                return SecretKeyDerivation.deriveSecretKey((Secret)secret, (int)128);
            }
            if (JWEAlgorithm.A192KW.equals((Object)jWEAlgorithm)) {
                return SecretKeyDerivation.deriveSecretKey((Secret)secret, (int)192);
            }
            if (JWEAlgorithm.A256KW.equals((Object)jWEAlgorithm)) {
                return SecretKeyDerivation.deriveSecretKey((Secret)secret, (int)256);
            }
        } else if (JWEAlgorithm.Family.AES_GCM_KW.contains((Object)jWEAlgorithm)) {
            if (JWEAlgorithm.A128GCMKW.equals((Object)jWEAlgorithm)) {
                return SecretKeyDerivation.deriveSecretKey((Secret)secret, (int)128);
            }
            if (JWEAlgorithm.A192GCMKW.equals((Object)jWEAlgorithm)) {
                return SecretKeyDerivation.deriveSecretKey((Secret)secret, (int)192);
            }
            if (JWEAlgorithm.A256GCMKW.equals((Object)jWEAlgorithm)) {
                return SecretKeyDerivation.deriveSecretKey((Secret)secret, (int)256);
            }
        }
        throw new JOSEException("Unsupported JWE algorithm / method: alg=" + jWEAlgorithm + " enc=" + encryptionMethod);
    }

    public static SecretKey deriveSecretKey(Secret secret, int n2) throws JOSEException {
        byte[] byArray;
        byte[] byArray2;
        int n3;
        switch (n2) {
            case 128: 
            case 192: 
            case 256: {
                n3 = 256;
                break;
            }
            case 384: {
                n3 = 384;
                break;
            }
            case 512: {
                n3 = 512;
                break;
            }
            default: {
                throw new JOSEException("Unsupported secret key length: " + n2 + " bits");
            }
        }
        try {
            byArray2 = MessageDigest.getInstance("SHA-" + n3).digest(secret.getValueBytes());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException(noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        switch (n2) {
            case 128: {
                byArray = ByteUtils.subArray((byte[])byArray2, (int)ByteUtils.byteLength((int)128), (int)ByteUtils.byteLength((int)128));
                break;
            }
            case 192: {
                byArray = ByteUtils.subArray((byte[])byArray2, (int)ByteUtils.byteLength((int)64), (int)ByteUtils.byteLength((int)192));
                break;
            }
            case 256: {
                byArray = byArray2;
                break;
            }
            case 384: {
                byArray = byArray2;
                break;
            }
            case 512: {
                byArray = byArray2;
                break;
            }
            default: {
                throw new JOSEException("Unsupported secret key length: " + n2 + " bits");
            }
        }
        return new SecretKeySpec(byArray, "AES");
    }

    private SecretKeyDerivation() {
    }
}

