/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id;

import java.io.Serializable;
import java.security.SecureRandom;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.net.minidev.json_1_3_1.JSONAware;
import macromedia.externals.net.minidev.json_1_3_1.JSONValue;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;

public class Identifier
implements JSONAware,
Serializable,
Comparable<Identifier> {
    public static final int DEFAULT_BYTE_LENGTH = 32;
    private static final SecureRandom secureRandom = new SecureRandom();
    private final String value;

    public Identifier(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IllegalArgumentException("The value must not be null or empty string");
        }
        this.value = string;
    }

    public Identifier(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("The byte length must be a positive integer");
        }
        byte[] byArray = new byte[n2];
        secureRandom.nextBytes(byArray);
        this.value = Base64URL.encode((byte[])byArray).toString();
    }

    public Identifier() {
        this(32);
    }

    public String getValue() {
        return this.value;
    }

    public String toJSONString() {
        StringBuilder stringBuilder = new StringBuilder("\"");
        stringBuilder.append(JSONValue.escape((String)this.value));
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public int compareTo(Identifier identifier) {
        return this.getValue().compareTo(identifier.getValue());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Identifier identifier = (Identifier)object;
        return this.getValue() != null ? this.getValue().equals(identifier.getValue()) : identifier.getValue() == null;
    }

    public int hashCode() {
        return this.getValue() != null ? this.getValue().hashCode() : 0;
    }
}

