/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import net.jcip.annotations.ThreadSafe;

/*
 * Exception performing whole class analysis ignored.
 */
@ThreadSafe
public class ServletUtils {
    private static String reconstructRequestURLString(HttpServletRequest httpServletRequest) {
        String string;
        StringBuilder stringBuilder = new StringBuilder("http");
        if (httpServletRequest.isSecure()) {
            stringBuilder.append('s');
        }
        stringBuilder.append("://");
        String string2 = httpServletRequest.getLocalAddr();
        if (string2 != null && !string2.trim().isEmpty()) {
            if (string2.contains(".")) {
                stringBuilder.append(string2);
            } else if (string2.contains(":")) {
                stringBuilder.append('[');
                stringBuilder.append(string2);
                stringBuilder.append(']');
            }
        }
        if (!httpServletRequest.isSecure() && httpServletRequest.getLocalPort() != 80) {
            stringBuilder.append(':');
            stringBuilder.append(httpServletRequest.getLocalPort());
        }
        if (httpServletRequest.isSecure() && httpServletRequest.getLocalPort() != 443) {
            stringBuilder.append(':');
            stringBuilder.append(httpServletRequest.getLocalPort());
        }
        if ((string = httpServletRequest.getRequestURI()) != null) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static HTTPRequest createHTTPRequest(HttpServletRequest httpServletRequest) throws IOException {
        return ServletUtils.createHTTPRequest((HttpServletRequest)httpServletRequest, (long)-1L);
    }

    public static HTTPRequest createHTTPRequest(HttpServletRequest httpServletRequest, long l2) throws IOException {
        CharSequence charSequence;
        URL uRL;
        HTTPRequest.Method method = HTTPRequest.Method.valueOf((String)httpServletRequest.getMethod().toUpperCase());
        String string = ServletUtils.reconstructRequestURLString((HttpServletRequest)httpServletRequest);
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Invalid request URL: " + malformedURLException.getMessage() + ": " + string, malformedURLException);
        }
        HTTPRequest hTTPRequest = new HTTPRequest(method, uRL);
        try {
            hTTPRequest.setContentType(httpServletRequest.getContentType());
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("Invalid Content-Type header value: " + parseException.getMessage(), parseException);
        }
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            charSequence = (String)enumeration.nextElement();
            hTTPRequest.setHeader((String)charSequence, httpServletRequest.getHeader((String)charSequence));
        }
        if (method.equals((Object)HTTPRequest.Method.GET) || method.equals((Object)HTTPRequest.Method.DELETE)) {
            hTTPRequest.setQuery(httpServletRequest.getQueryString());
        } else if (method.equals((Object)HTTPRequest.Method.POST) || method.equals((Object)HTTPRequest.Method.PUT)) {
            if (hTTPRequest.getContentType() != null && hTTPRequest.getContentType().getBaseType().equals(CommonContentTypes.APPLICATION_URLENCODED.getBaseType())) {
                hTTPRequest.setQuery(URLUtils.serializeParametersAlt((Map)httpServletRequest.getParameterMap()));
            } else {
                int n2;
                charSequence = new StringBuilder(256);
                BufferedReader bufferedReader = httpServletRequest.getReader();
                char[] cArray = new char[256];
                while ((n2 = bufferedReader.read(cArray)) != -1) {
                    ((StringBuilder)charSequence).append(cArray, 0, n2);
                    if (l2 <= 0L || (long)((StringBuilder)charSequence).length() <= l2) continue;
                    throw new IOException("Request entity body is too large, limit is " + l2 + " chars");
                }
                bufferedReader.close();
                hTTPRequest.setQuery(((StringBuilder)charSequence).toString());
            }
        }
        return hTTPRequest;
    }

    public static void applyHTTPResponse(HTTPResponse hTTPResponse, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setStatus(hTTPResponse.getStatusCode());
        for (Map.Entry object : hTTPResponse.getHeaders().entrySet()) {
            httpServletResponse.setHeader((String)object.getKey(), (String)object.getValue());
        }
        if (hTTPResponse.getContentType() != null) {
            httpServletResponse.setContentType(hTTPResponse.getContentType().toString());
        }
        if (hTTPResponse.getContent() != null) {
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.print(hTTPResponse.getContent());
            printWriter.close();
        }
    }

    private ServletUtils() {
    }
}

