/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPMessage;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.ThreadSafe;

/*
 * Exception performing whole class analysis ignored.
 */
@ThreadSafe
public class HTTPRequest
extends HTTPMessage {
    private final Method method;
    private final URL url;
    private String query = null;
    private String fragment = null;
    private int connectTimeout = 0;
    private int readTimeout = 0;
    private boolean followRedirects = true;
    private static HostnameVerifier defaultHostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
    private static SSLSocketFactory defaultSSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();

    public HTTPRequest(Method method, URL uRL) {
        if (method == null) {
            throw new IllegalArgumentException("The HTTP method must not be null");
        }
        this.method = method;
        if (uRL == null) {
            throw new IllegalArgumentException("The HTTP URL must not be null");
        }
        this.url = uRL;
    }

    public Method getMethod() {
        return this.method;
    }

    public URL getURL() {
        return this.url;
    }

    public void ensureMethod(Method method) throws ParseException {
        if (this.method != method) {
            throw new ParseException("The HTTP request method must be " + method);
        }
    }

    public String getAuthorization() {
        return this.getHeader("Authorization");
    }

    public void setAuthorization(String string) {
        this.setHeader("Authorization", string);
    }

    public String getAccept() {
        return this.getHeader("Accept");
    }

    public void setAccept(String string) {
        this.setHeader("Accept", string);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    private void ensureQuery() throws ParseException {
        if (this.query == null || this.query.trim().isEmpty()) {
            throw new ParseException("Missing or empty HTTP query string / entity body");
        }
    }

    public Map<String, String> getQueryParameters() {
        return URLUtils.parseParameters((String)this.query);
    }

    public JSONObject getQueryAsJSONObject() throws ParseException {
        this.ensureContentType(CommonContentTypes.APPLICATION_JSON);
        this.ensureQuery();
        return JSONObjectUtils.parse((String)this.query);
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String string) {
        this.fragment = string;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The HTTP connect timeout must be zero or positive");
        }
        this.connectTimeout = n2;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("The HTTP response read timeout must be zero or positive");
        }
        this.readTimeout = n2;
    }

    public boolean getFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean bl2) {
        this.followRedirects = bl2;
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerifier;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("The hostname verifier must not be null");
        }
        defaultHostnameVerifier = hostnameVerifier;
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory() {
        return defaultSSLSocketFactory;
    }

    public static void setDefaultSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        if (sSLSocketFactory == null) {
            throw new IllegalArgumentException("The SSL socket factory must not be null");
        }
        defaultSSLSocketFactory = sSLSocketFactory;
    }

    public HttpURLConnection toHttpURLConnection() throws IOException {
        return this.toHttpURLConnection(null, null);
    }

    public HttpURLConnection toHttpURLConnection(HostnameVerifier hostnameVerifier, SSLSocketFactory sSLSocketFactory) throws IOException {
        Object object2;
        URL uRL = this.url;
        if (this.query != null && (this.method.equals((Object)Method.GET) || this.method.equals((Object)Method.DELETE))) {
            object2 = new StringBuilder(this.url.toString());
            ((StringBuilder)object2).append('?');
            ((StringBuilder)object2).append(this.query);
            try {
                uRL = new URL(((StringBuilder)object2).toString());
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException("Couldn't append query string: " + malformedURLException.getMessage(), malformedURLException);
            }
        }
        if (this.fragment != null) {
            object2 = new StringBuilder(uRL.toString());
            ((StringBuilder)object2).append('#');
            ((StringBuilder)object2).append(this.fragment);
            try {
                uRL = new URL(((StringBuilder)object2).toString());
            }
            catch (MalformedURLException malformedURLException) {
                throw new IOException("Couldn't append raw fragment: " + malformedURLException.getMessage(), malformedURLException);
            }
        }
        if ((object2 = (HttpURLConnection)uRL.openConnection()) instanceof HttpsURLConnection) {
            HttpsURLConnection object3 = (HttpsURLConnection)object2;
            object3.setHostnameVerifier(hostnameVerifier != null ? hostnameVerifier : HTTPRequest.getDefaultHostnameVerifier());
            object3.setSSLSocketFactory(sSLSocketFactory != null ? sSLSocketFactory : HTTPRequest.getDefaultSSLSocketFactory());
        }
        for (Map.Entry entry : this.getHeaders().entrySet()) {
            ((URLConnection)object2).setRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
        ((HttpURLConnection)object2).setRequestMethod(this.method.name());
        ((URLConnection)object2).setConnectTimeout(this.connectTimeout);
        ((URLConnection)object2).setReadTimeout(this.readTimeout);
        ((HttpURLConnection)object2).setInstanceFollowRedirects(this.followRedirects);
        if (this.method.equals((Object)Method.POST) || this.method.equals((Object)Method.PUT)) {
            ((URLConnection)object2).setDoOutput(true);
            if (this.getContentType() != null) {
                ((URLConnection)object2).setRequestProperty("Content-Type", this.getContentType().toString());
            }
            if (this.query != null) {
                try {
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(((URLConnection)object2).getOutputStream());
                    outputStreamWriter.write(this.query);
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    HTTPRequest.closeStreams((HttpURLConnection)object2);
                    throw iOException;
                }
            }
        }
        return object2;
    }

    public HTTPResponse send() throws IOException {
        return this.send(null, null);
    }

    public HTTPResponse send(HostnameVerifier hostnameVerifier, SSLSocketFactory sSLSocketFactory) throws IOException {
        Map.Entry<String, List<String>> entry2;
        Object object;
        int n2;
        BufferedReader bufferedReader;
        HttpURLConnection httpURLConnection = this.toHttpURLConnection(hostnameVerifier, sSLSocketFactory);
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            n2 = httpURLConnection.getResponseCode();
        }
        catch (IOException iOException) {
            n2 = httpURLConnection.getResponseCode();
            if (n2 == -1) {
                throw iOException;
            }
            object = httpURLConnection.getErrorStream();
            bufferedReader = object != null ? new BufferedReader(new InputStreamReader((InputStream)object)) : new BufferedReader(new StringReader(""));
        }
        StringBuilder stringBuilder = new StringBuilder();
        while ((object = bufferedReader.readLine()) != null) {
            stringBuilder.append((String)object);
            stringBuilder.append(System.getProperty("line.separator"));
        }
        bufferedReader.close();
        HTTPResponse hTTPResponse = new HTTPResponse(n2);
        hTTPResponse.setStatusMessage(httpURLConnection.getResponseMessage());
        for (Map.Entry<String, List<String>> entry2 : httpURLConnection.getHeaderFields().entrySet()) {
            List list;
            if (entry2.getKey() == null || (list = (List)entry2.getValue()) == null || list.isEmpty() || list.get(0) == null) continue;
            hTTPResponse.setHeader((String)entry2.getKey(), (String)list.get(0));
        }
        HTTPRequest.closeStreams((HttpURLConnection)httpURLConnection);
        entry2 = stringBuilder.toString();
        if (!((String)((Object)entry2)).isEmpty()) {
            hTTPResponse.setContent((String)((Object)entry2));
        }
        return hTTPResponse;
    }

    private static void closeStreams(HttpURLConnection httpURLConnection) {
        if (httpURLConnection == null) {
            return;
        }
        try {
            if (httpURLConnection.getInputStream() != null) {
                httpURLConnection.getInputStream().close();
            }
        }
        catch (Exception exception) {}
        try {
            if (httpURLConnection.getOutputStream() != null) {
                httpURLConnection.getOutputStream().close();
            }
        }
        catch (Exception exception) {}
        try {
            if (httpURLConnection.getErrorStream() != null) {
                httpURLConnection.getOutputStream().close();
            }
        }
        catch (Exception exception) {}
    }
}

