/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http;

import java.util.Map;
import java.util.TreeMap;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.ContentTypeUtils;
import macromedia.externals.javax.mail_1_4_7.internet.ContentType;

abstract class HTTPMessage {
    private final Map<String, String> headers = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    HTTPMessage() {
    }

    public ContentType getContentType() {
        String string = this.getHeader("Content-Type");
        if (string == null) {
            return null;
        }
        try {
            return new ContentType(string);
        }
        catch (macromedia.externals.javax.mail_1_4_7.internet.ParseException parseException) {
            return null;
        }
    }

    public void setContentType(ContentType contentType) {
        this.setHeader("Content-Type", contentType != null ? contentType.toString() : null);
    }

    public void setContentType(String string) throws ParseException {
        try {
            this.setHeader("Content-Type", string != null ? new ContentType(string).toString() : null);
        }
        catch (macromedia.externals.javax.mail_1_4_7.internet.ParseException parseException) {
            throw new ParseException("Invalid Content-Type value: " + parseException.getMessage());
        }
    }

    public void ensureContentType() throws ParseException {
        if (this.getContentType() == null) {
            throw new ParseException("Missing HTTP Content-Type header");
        }
    }

    public void ensureContentType(ContentType contentType) throws ParseException {
        ContentTypeUtils.ensureContentType((ContentType)contentType, (ContentType)this.getContentType());
    }

    public String getHeader(String string) {
        return (String)this.headers.get(string);
    }

    public void setHeader(String string, String string2) {
        if (string2 != null) {
            this.headers.put(string, string2);
        } else {
            this.headers.remove(string);
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

