/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSObject;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.jwt_8_2_1.SignedJWT;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ProtectedResourceRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client.ClientMetadata;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.AccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.BearerAccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import net.jcip.annotations.Immutable;

@Immutable
public class ClientRegistrationRequest
extends ProtectedResourceRequest {
    private final ClientMetadata metadata;
    private final SignedJWT softwareStatement;

    public ClientRegistrationRequest(URI uRI, ClientMetadata clientMetadata, BearerAccessToken bearerAccessToken) {
        this(uRI, clientMetadata, null, bearerAccessToken);
    }

    public ClientRegistrationRequest(URI uRI, ClientMetadata clientMetadata, SignedJWT signedJWT, BearerAccessToken bearerAccessToken) {
        super(uRI, (AccessToken)bearerAccessToken);
        if (clientMetadata == null) {
            throw new IllegalArgumentException("The client metadata must not be null");
        }
        this.metadata = clientMetadata;
        if (signedJWT != null) {
            JWTClaimsSet jWTClaimsSet;
            if (signedJWT.getState() == JWSObject.State.UNSIGNED) {
                throw new IllegalArgumentException("The software statement JWT must be signed");
            }
            try {
                jWTClaimsSet = signedJWT.getJWTClaimsSet();
            }
            catch (java.text.ParseException parseException) {
                throw new IllegalArgumentException("The software statement is not a valid signed JWT: " + parseException.getMessage());
            }
            if (jWTClaimsSet.getIssuer() == null) {
                throw new IllegalArgumentException("The software statement JWT must contain an 'iss' claim");
            }
        }
        this.softwareStatement = signedJWT;
    }

    public ClientMetadata getClientMetadata() {
        return this.metadata;
    }

    public SignedJWT getSoftwareStatement() {
        return this.softwareStatement;
    }

    public HTTPRequest toHTTPRequest() {
        URL uRL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            uRL = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SerializeException(malformedURLException.getMessage(), (Throwable)malformedURLException);
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, uRL);
        if (this.getAccessToken() != null) {
            hTTPRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        }
        hTTPRequest.setContentType(CommonContentTypes.APPLICATION_JSON);
        JSONObject jSONObject = this.metadata.toJSONObject();
        if (this.softwareStatement != null) {
            jSONObject.put((Object)"software_statement", (Object)this.softwareStatement.serialize());
        }
        hTTPRequest.setQuery(jSONObject.toString());
        return hTTPRequest;
    }

    public static ClientRegistrationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        JSONObject jSONObject = hTTPRequest.getQueryAsJSONObject();
        SignedJWT signedJWT = null;
        if (jSONObject.containsKey((Object)"software_statement")) {
            try {
                signedJWT = SignedJWT.parse((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)"software_statement"));
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid software statement JWT: " + parseException.getMessage());
            }
            jSONObject.remove((Object)"software_statement");
        }
        ClientMetadata clientMetadata = ClientMetadata.parse((JSONObject)jSONObject);
        BearerAccessToken bearerAccessToken = null;
        String string = hTTPRequest.getAuthorization();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            bearerAccessToken = BearerAccessToken.parse((String)string);
        }
        try {
            URI uRI = hTTPRequest.getURL().toURI();
            return new ClientRegistrationRequest(uRI, clientMetadata, signedJWT, bearerAccessToken);
        }
        catch (IllegalArgumentException | URISyntaxException exception) {
            throw new ParseException(exception.getMessage(), (Throwable)exception);
        }
    }
}

