/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client;

import com.nimbusds.langtag.LangTag;
import com.nimbusds.langtag.LangTagUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKSet;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.GrantType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.Scope;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthenticationMethod;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.client.RegistrationError;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.SoftwareID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.SoftwareVersion;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.javax.mail_1_4_7.internet.AddressException;
import macromedia.externals.javax.mail_1_4_7.internet.InternetAddress;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClientMetadata {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private Set<URI> redirectURIs;
    private Scope scope;
    private Set<ResponseType> responseTypes;
    private Set<GrantType> grantTypes;
    private List<String> contacts;
    private final Map<LangTag, String> nameEntries;
    private final Map<LangTag, URI> logoURIEntries;
    private final Map<LangTag, URI> uriEntries;
    private Map<LangTag, URI> policyURIEntries;
    private final Map<LangTag, URI> tosURIEntries;
    private ClientAuthenticationMethod authMethod;
    private JWSAlgorithm authJWSAlg;
    private URI jwkSetURI;
    private JWKSet jwkSet;
    private SoftwareID softwareID;
    private SoftwareVersion softwareVersion;
    private JSONObject customFields;

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("redirect_uris");
        hashSet.add("scope");
        hashSet.add("response_types");
        hashSet.add("grant_types");
        hashSet.add("contacts");
        hashSet.add("client_name");
        hashSet.add("logo_uri");
        hashSet.add("client_uri");
        hashSet.add("policy_uri");
        hashSet.add("tos_uri");
        hashSet.add("token_endpoint_auth_method");
        hashSet.add("token_endpoint_auth_signing_alg");
        hashSet.add("jwks_uri");
        hashSet.add("jwks");
        hashSet.add("software_id");
        hashSet.add("software_version");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public ClientMetadata() {
        this.nameEntries = new HashMap();
        this.logoURIEntries = new HashMap();
        this.uriEntries = new HashMap();
        this.policyURIEntries = new HashMap();
        this.policyURIEntries = new HashMap();
        this.tosURIEntries = new HashMap();
        this.customFields = new JSONObject();
    }

    public ClientMetadata(ClientMetadata clientMetadata) {
        this.redirectURIs = clientMetadata.redirectURIs;
        this.scope = clientMetadata.scope;
        this.responseTypes = clientMetadata.responseTypes;
        this.grantTypes = clientMetadata.grantTypes;
        this.contacts = clientMetadata.contacts;
        this.nameEntries = clientMetadata.nameEntries;
        this.logoURIEntries = clientMetadata.logoURIEntries;
        this.uriEntries = clientMetadata.uriEntries;
        this.policyURIEntries = clientMetadata.policyURIEntries;
        this.tosURIEntries = clientMetadata.tosURIEntries;
        this.authMethod = clientMetadata.authMethod;
        this.authJWSAlg = clientMetadata.authJWSAlg;
        this.jwkSetURI = clientMetadata.jwkSetURI;
        this.jwkSet = clientMetadata.getJWKSet();
        this.softwareID = clientMetadata.softwareID;
        this.softwareVersion = clientMetadata.softwareVersion;
        this.customFields = clientMetadata.customFields;
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public Set<URI> getRedirectionURIs() {
        return this.redirectURIs;
    }

    public Set<String> getRedirectionURIStrings() {
        if (this.redirectURIs == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (URI uRI : this.redirectURIs) {
            hashSet.add(uRI.toString());
        }
        return hashSet;
    }

    public void setRedirectionURIs(Set<URI> set) {
        if (set != null) {
            for (URI uRI : set) {
                if (uRI == null) {
                    throw new IllegalArgumentException("The redirect_uri must not be null");
                }
                if (uRI.getFragment() == null) continue;
                throw new IllegalArgumentException("The redirect_uri must not contain fragment");
            }
            this.redirectURIs = set;
        } else {
            this.redirectURIs = null;
        }
    }

    public void setRedirectionURI(URI uRI) {
        this.setRedirectionURIs(uRI != null ? Collections.singleton(uRI) : null);
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean hasScopeValue(Scope.Value value) {
        return this.scope != null && this.scope.contains((Object)value);
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public Set<ResponseType> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(Set<ResponseType> set) {
        this.responseTypes = set;
    }

    public Set<GrantType> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(Set<GrantType> set) {
        this.grantTypes = set;
    }

    @Deprecated
    public List<InternetAddress> getContacts() {
        if (this.contacts == null) {
            return null;
        }
        LinkedList<InternetAddress> linkedList = new LinkedList<InternetAddress>();
        for (String string : this.contacts) {
            if (string == null) continue;
            try {
                linkedList.add(new InternetAddress(string, false));
            }
            catch (AddressException addressException) {}
        }
        return linkedList;
    }

    @Deprecated
    public void setContacts(List<InternetAddress> list) {
        if (list == null) {
            this.contacts = null;
            return;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (InternetAddress internetAddress : list) {
            if (internetAddress == null) continue;
            linkedList.add(internetAddress.toString());
        }
        this.contacts = linkedList;
    }

    public List<String> getEmailContacts() {
        return this.contacts;
    }

    public void setEmailContacts(List<String> list) {
        this.contacts = list;
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(LangTag langTag) {
        return (String)this.nameEntries.get(langTag);
    }

    public Map<LangTag, String> getNameEntries() {
        return this.nameEntries;
    }

    public void setName(String string) {
        this.nameEntries.put(null, string);
    }

    public void setName(String string, LangTag langTag) {
        this.nameEntries.put(langTag, string);
    }

    public URI getLogoURI() {
        return this.getLogoURI(null);
    }

    public URI getLogoURI(LangTag langTag) {
        return (URI)this.logoURIEntries.get(langTag);
    }

    public Map<LangTag, URI> getLogoURIEntries() {
        return this.logoURIEntries;
    }

    public void setLogoURI(URI uRI) {
        this.logoURIEntries.put(null, uRI);
    }

    public void setLogoURI(URI uRI, LangTag langTag) {
        this.logoURIEntries.put(langTag, uRI);
    }

    public URI getURI() {
        return this.getURI(null);
    }

    public URI getURI(LangTag langTag) {
        return (URI)this.uriEntries.get(langTag);
    }

    public Map<LangTag, URI> getURIEntries() {
        return this.uriEntries;
    }

    public void setURI(URI uRI) {
        this.uriEntries.put(null, uRI);
    }

    public void setURI(URI uRI, LangTag langTag) {
        this.uriEntries.put(langTag, uRI);
    }

    public URI getPolicyURI() {
        return this.getPolicyURI(null);
    }

    public URI getPolicyURI(LangTag langTag) {
        return (URI)this.policyURIEntries.get(langTag);
    }

    public Map<LangTag, URI> getPolicyURIEntries() {
        return this.policyURIEntries;
    }

    public void setPolicyURI(URI uRI) {
        this.policyURIEntries.put(null, uRI);
    }

    public void setPolicyURI(URI uRI, LangTag langTag) {
        this.policyURIEntries.put(langTag, uRI);
    }

    public URI getTermsOfServiceURI() {
        return this.getTermsOfServiceURI(null);
    }

    public URI getTermsOfServiceURI(LangTag langTag) {
        return (URI)this.tosURIEntries.get(langTag);
    }

    public Map<LangTag, URI> getTermsOfServiceURIEntries() {
        return this.tosURIEntries;
    }

    public void setTermsOfServiceURI(URI uRI) {
        this.tosURIEntries.put(null, uRI);
    }

    public void setTermsOfServiceURI(URI uRI, LangTag langTag) {
        this.tosURIEntries.put(langTag, uRI);
    }

    public ClientAuthenticationMethod getTokenEndpointAuthMethod() {
        return this.authMethod;
    }

    public void setTokenEndpointAuthMethod(ClientAuthenticationMethod clientAuthenticationMethod) {
        this.authMethod = clientAuthenticationMethod;
    }

    public JWSAlgorithm getTokenEndpointAuthJWSAlg() {
        return this.authJWSAlg;
    }

    public void setTokenEndpointAuthJWSAlg(JWSAlgorithm jWSAlgorithm) {
        this.authJWSAlg = jWSAlgorithm;
    }

    public URI getJWKSetURI() {
        return this.jwkSetURI;
    }

    public void setJWKSetURI(URI uRI) {
        this.jwkSetURI = uRI;
    }

    public JWKSet getJWKSet() {
        return this.jwkSet;
    }

    public void setJWKSet(JWKSet jWKSet) {
        this.jwkSet = jWKSet;
    }

    public SoftwareID getSoftwareID() {
        return this.softwareID;
    }

    public void setSoftwareID(SoftwareID softwareID) {
        this.softwareID = softwareID;
    }

    public SoftwareVersion getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(SoftwareVersion softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public Object getCustomField(String string) {
        return this.customFields.get((Object)string);
    }

    public JSONObject getCustomFields() {
        return this.customFields;
    }

    public void setCustomField(String string, Object object) {
        this.customFields.put((Object)string, object);
    }

    public void setCustomFields(JSONObject jSONObject) {
        if (jSONObject == null) {
            throw new IllegalArgumentException("The custom fields JSON object must not be null");
        }
        this.customFields = jSONObject;
    }

    public void applyDefaults() {
        if (this.responseTypes == null) {
            this.responseTypes = new HashSet();
            this.responseTypes.add(ResponseType.getDefault());
        }
        if (this.grantTypes == null) {
            this.grantTypes = new HashSet();
            this.grantTypes.add(GrantType.AUTHORIZATION_CODE);
        }
        if (this.authMethod == null) {
            this.authMethod = this.grantTypes.contains(GrantType.IMPLICIT) && this.grantTypes.size() == 1 ? ClientAuthenticationMethod.NONE : ClientAuthenticationMethod.getDefault();
        }
    }

    public JSONObject toJSONObject() {
        return this.toJSONObject(true);
    }

    public JSONObject toJSONObject(boolean bl2) {
        Object object;
        LangTag langTag;
        JSONObject jSONObject = bl2 ? new JSONObject((Map)this.customFields) : new JSONObject();
        if (this.redirectURIs != null) {
            JSONArray object22 = new JSONArray();
            for (Iterator iterator : this.redirectURIs) {
                object22.add((Object)((URI)((Object)iterator)).toString());
            }
            jSONObject.put((Object)"redirect_uris", (Object)object22);
        }
        if (this.scope != null) {
            jSONObject.put((Object)"scope", (Object)this.scope.toString());
        }
        if (this.responseTypes != null) {
            JSONArray jSONArray = new JSONArray();
            for (Iterator iterator : this.responseTypes) {
                jSONArray.add((Object)iterator.toString());
            }
            jSONObject.put((Object)"response_types", (Object)jSONArray);
        }
        if (this.grantTypes != null) {
            JSONArray jSONArray = new JSONArray();
            for (Iterator iterator : this.grantTypes) {
                jSONArray.add((Object)iterator.toString());
            }
            jSONObject.put((Object)"grant_types", (Object)jSONArray);
        }
        if (this.contacts != null) {
            jSONObject.put((Object)"contacts", (Object)this.contacts);
        }
        if (!this.nameEntries.isEmpty()) {
            for (Map.Entry entry : this.nameEntries.entrySet()) {
                langTag = (LangTag)entry.getKey();
                object = (String)entry.getValue();
                if (object == null) continue;
                if (langTag == null) {
                    jSONObject.put((Object)"client_name", entry.getValue());
                    continue;
                }
                jSONObject.put((Object)("client_name#" + langTag), entry.getValue());
            }
        }
        if (!this.logoURIEntries.isEmpty()) {
            for (Map.Entry entry : this.logoURIEntries.entrySet()) {
                langTag = (LangTag)entry.getKey();
                object = (URI)entry.getValue();
                if (object == null) continue;
                if (langTag == null) {
                    jSONObject.put((Object)"logo_uri", (Object)((URI)entry.getValue()).toString());
                    continue;
                }
                jSONObject.put((Object)("logo_uri#" + langTag), (Object)((URI)entry.getValue()).toString());
            }
        }
        if (!this.uriEntries.isEmpty()) {
            for (Map.Entry entry : this.uriEntries.entrySet()) {
                langTag = (LangTag)entry.getKey();
                object = (URI)entry.getValue();
                if (object == null) continue;
                if (langTag == null) {
                    jSONObject.put((Object)"client_uri", (Object)((URI)entry.getValue()).toString());
                    continue;
                }
                jSONObject.put((Object)("client_uri#" + langTag), (Object)((URI)entry.getValue()).toString());
            }
        }
        if (!this.policyURIEntries.isEmpty()) {
            for (Map.Entry entry : this.policyURIEntries.entrySet()) {
                langTag = (LangTag)entry.getKey();
                object = (URI)entry.getValue();
                if (object == null) continue;
                if (langTag == null) {
                    jSONObject.put((Object)"policy_uri", (Object)((URI)entry.getValue()).toString());
                    continue;
                }
                jSONObject.put((Object)("policy_uri#" + langTag), (Object)((URI)entry.getValue()).toString());
            }
        }
        if (!this.tosURIEntries.isEmpty()) {
            for (Map.Entry entry : this.tosURIEntries.entrySet()) {
                langTag = (LangTag)entry.getKey();
                object = (URI)entry.getValue();
                if (object == null) continue;
                if (langTag == null) {
                    jSONObject.put((Object)"tos_uri", (Object)((URI)entry.getValue()).toString());
                    continue;
                }
                jSONObject.put((Object)("tos_uri#" + langTag), (Object)((URI)entry.getValue()).toString());
            }
        }
        if (this.authMethod != null) {
            jSONObject.put((Object)"token_endpoint_auth_method", (Object)this.authMethod.toString());
        }
        if (this.authJWSAlg != null) {
            jSONObject.put((Object)"token_endpoint_auth_signing_alg", (Object)this.authJWSAlg.getName());
        }
        if (this.jwkSetURI != null) {
            jSONObject.put((Object)"jwks_uri", (Object)this.jwkSetURI.toString());
        }
        if (this.jwkSet != null) {
            jSONObject.put((Object)"jwks", (Object)this.jwkSet.toJSONObject(true));
        }
        if (this.softwareID != null) {
            jSONObject.put((Object)"software_id", (Object)this.softwareID.getValue());
        }
        if (this.softwareVersion != null) {
            jSONObject.put((Object)"software_version", (Object)this.softwareVersion.getValue());
        }
        return jSONObject;
    }

    public static ClientMetadata parse(JSONObject jSONObject) throws ParseException {
        return ClientMetadata.parseFromModifiableJSONObject((JSONObject)new JSONObject((Map)jSONObject));
    }

    private static ClientMetadata parseFromModifiableJSONObject(JSONObject jSONObject) throws ParseException {
        Map.Entry entry2;
        int n2;
        int n3;
        String[] stringArray;
        Object object;
        ClientMetadata clientMetadata = new ClientMetadata();
        if (jSONObject.get((Object)"redirect_uris") != null) {
            object = new LinkedHashSet();
            stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"redirect_uris");
            n3 = stringArray.length;
            n2 = 0;
            while (n2 < n3) {
                URI uRI;
                entry2 = stringArray[n2];
                try {
                    uRI = new URI((String)((Object)entry2));
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ParseException("Invalid \"redirect_uris\" parameter: " + uRISyntaxException.getMessage(), RegistrationError.INVALID_REDIRECT_URI.appendDescription(": " + uRISyntaxException.getMessage()));
                }
                if (uRI.getFragment() != null) {
                    String string = "URI must not contain fragment";
                    throw new ParseException("Invalid \"redirect_uris\" parameter: " + string, RegistrationError.INVALID_REDIRECT_URI.appendDescription(": " + string));
                }
                object.add(uRI);
                ++n2;
            }
            clientMetadata.setRedirectionURIs(object);
            jSONObject.remove((Object)"redirect_uris");
        }
        try {
            if (jSONObject.get((Object)"scope") != null) {
                clientMetadata.setScope(Scope.parse((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)"scope")));
                jSONObject.remove((Object)"scope");
            }
            if (jSONObject.get((Object)"response_types") != null) {
                object = new LinkedHashSet();
                stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"response_types");
                n3 = stringArray.length;
                n2 = 0;
                while (n2 < n3) {
                    entry2 = stringArray[n2];
                    object.add(ResponseType.parse((String)((Object)entry2)));
                    ++n2;
                }
                clientMetadata.setResponseTypes((Set)object);
                jSONObject.remove((Object)"response_types");
            }
            if (jSONObject.get((Object)"grant_types") != null) {
                object = new LinkedHashSet();
                stringArray = JSONObjectUtils.getStringArray((JSONObject)jSONObject, (String)"grant_types");
                n3 = stringArray.length;
                n2 = 0;
                while (n2 < n3) {
                    entry2 = stringArray[n2];
                    object.add(GrantType.parse((String)((Object)entry2)));
                    ++n2;
                }
                clientMetadata.setGrantTypes((Set)object);
                jSONObject.remove((Object)"grant_types");
            }
            if (jSONObject.get((Object)"contacts") != null) {
                clientMetadata.setEmailContacts(JSONObjectUtils.getStringList((JSONObject)jSONObject, (String)"contacts"));
                jSONObject.remove((Object)"contacts");
            }
            object = LangTagUtils.find((String)"client_name", (Map)jSONObject);
            for (Map.Entry entry2 : object.entrySet()) {
                try {
                    clientMetadata.setName((String)entry2.getValue(), (LangTag)entry2.getKey());
                }
                catch (ClassCastException classCastException) {
                    throw new ParseException("Invalid \"client_name\" (language tag) parameter");
                }
                ClientMetadata.removeMember((JSONObject)jSONObject, (String)"client_name", (LangTag)((LangTag)entry2.getKey()));
            }
            object = LangTagUtils.find((String)"logo_uri", (Map)jSONObject);
            for (Map.Entry entry2 : object.entrySet()) {
                if (entry2.getValue() == null) continue;
                try {
                    clientMetadata.setLogoURI(new URI((String)entry2.getValue()), (LangTag)entry2.getKey());
                }
                catch (Exception exception) {
                    throw new ParseException("Invalid \"logo_uri\" (language tag) parameter");
                }
                ClientMetadata.removeMember((JSONObject)jSONObject, (String)"logo_uri", (LangTag)((LangTag)entry2.getKey()));
            }
            object = LangTagUtils.find((String)"client_uri", (Map)jSONObject);
            for (Map.Entry entry2 : object.entrySet()) {
                if (entry2.getValue() == null) continue;
                try {
                    clientMetadata.setURI(new URI((String)entry2.getValue()), (LangTag)entry2.getKey());
                }
                catch (Exception exception) {
                    throw new ParseException("Invalid \"client_uri\" (language tag) parameter");
                }
                ClientMetadata.removeMember((JSONObject)jSONObject, (String)"client_uri", (LangTag)((LangTag)entry2.getKey()));
            }
            object = LangTagUtils.find((String)"policy_uri", (Map)jSONObject);
            for (Map.Entry entry2 : object.entrySet()) {
                if (entry2.getValue() == null) continue;
                try {
                    clientMetadata.setPolicyURI(new URI((String)entry2.getValue()), (LangTag)entry2.getKey());
                }
                catch (Exception exception) {
                    throw new ParseException("Invalid \"policy_uri\" (language tag) parameter");
                }
                ClientMetadata.removeMember((JSONObject)jSONObject, (String)"policy_uri", (LangTag)((LangTag)entry2.getKey()));
            }
            object = LangTagUtils.find((String)"tos_uri", (Map)jSONObject);
            for (Map.Entry entry2 : object.entrySet()) {
                if (entry2.getValue() == null) continue;
                try {
                    clientMetadata.setTermsOfServiceURI(new URI((String)entry2.getValue()), (LangTag)entry2.getKey());
                }
                catch (Exception exception) {
                    throw new ParseException("Invalid \"tos_uri\" (language tag) parameter");
                }
                ClientMetadata.removeMember((JSONObject)jSONObject, (String)"tos_uri", (LangTag)((LangTag)entry2.getKey()));
            }
            if (jSONObject.get((Object)"token_endpoint_auth_method") != null) {
                clientMetadata.setTokenEndpointAuthMethod(new ClientAuthenticationMethod(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"token_endpoint_auth_method")));
                jSONObject.remove((Object)"token_endpoint_auth_method");
            }
            if (jSONObject.get((Object)"token_endpoint_auth_signing_alg") != null) {
                clientMetadata.setTokenEndpointAuthJWSAlg(new JWSAlgorithm(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"token_endpoint_auth_signing_alg")));
                jSONObject.remove((Object)"token_endpoint_auth_signing_alg");
            }
            if (jSONObject.get((Object)"jwks_uri") != null) {
                clientMetadata.setJWKSetURI(JSONObjectUtils.getURI((JSONObject)jSONObject, (String)"jwks_uri"));
                jSONObject.remove((Object)"jwks_uri");
            }
            if (jSONObject.get((Object)"jwks") != null) {
                try {
                    clientMetadata.setJWKSet(JWKSet.parse((JSONObject)JSONObjectUtils.getJSONObject((JSONObject)jSONObject, (String)"jwks")));
                }
                catch (java.text.ParseException parseException) {
                    throw new ParseException(parseException.getMessage(), (Throwable)parseException);
                }
                jSONObject.remove((Object)"jwks");
            }
            if (jSONObject.get((Object)"software_id") != null) {
                clientMetadata.setSoftwareID(new SoftwareID(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"software_id")));
                jSONObject.remove((Object)"software_id");
            }
            if (jSONObject.get((Object)"software_version") != null) {
                clientMetadata.setSoftwareVersion(new SoftwareVersion(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"software_version")));
                jSONObject.remove((Object)"software_version");
            }
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), RegistrationError.INVALID_CLIENT_METADATA.appendDescription(": " + parseException.getMessage()), parseException.getCause());
        }
        clientMetadata.customFields = jSONObject;
        return clientMetadata;
    }

    private static void removeMember(JSONObject jSONObject, String string, LangTag langTag) {
        if (langTag == null) {
            jSONObject.remove((Object)string);
        } else {
            jSONObject.remove((Object)(String.valueOf(string) + "#" + langTag));
        }
    }
}

