/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth;

import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Date;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import net.jcip.annotations.Immutable;

@Immutable
public class Secret {
    public static final int DEFAULT_BYTE_LENGTH = 32;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private byte[] value;
    private final Date expDate;

    public Secret(String string) {
        this(string, null);
    }

    public Secret(String string, Date date) {
        this.value = string.getBytes(Charset.forName("utf-8"));
        this.expDate = date;
    }

    public Secret(int n2) {
        this(n2, null);
    }

    public Secret(int n2, Date date) {
        if (n2 < 1) {
            throw new IllegalArgumentException("The byte length must be a positive integer");
        }
        byte[] byArray = new byte[n2];
        SECURE_RANDOM.nextBytes(byArray);
        this.value = Base64URL.encode((byte[])byArray).toString().getBytes(Charset.forName("UTF-8"));
        this.expDate = date;
    }

    public Secret() {
        this(32);
    }

    public String getValue() {
        if (this.value == null) {
            return null;
        }
        return new String(this.value, Charset.forName("utf-8"));
    }

    public byte[] getValueBytes() {
        return this.value;
    }

    public void erase() {
        if (this.value == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.value.length) {
            this.value[n2] = 0;
            ++n2;
        }
        this.value = null;
    }

    public Date getExpirationDate() {
        return this.expDate;
    }

    public boolean expired() {
        if (this.expDate == null) {
            return false;
        }
        Date date = new Date();
        return this.expDate.before(date);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Secret)) {
            return false;
        }
        Secret secret = (Secret)object;
        return Arrays.equals(this.value, secret.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

