/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthentication;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthenticationMethod;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.PlainClientSecret;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.Secret;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public final class ClientSecretBasic
extends PlainClientSecret {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public ClientSecretBasic(ClientID clientID, Secret secret) {
        super(ClientAuthenticationMethod.CLIENT_SECRET_BASIC, clientID, secret);
    }

    public String toHTTPAuthorizationHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(URLEncoder.encode(this.getClientID().getValue(), UTF8_CHARSET.name()));
            stringBuilder.append(':');
            stringBuilder.append(URLEncoder.encode(this.getClientSecret().getValue(), UTF8_CHARSET.name()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return "Basic " + Base64.encode((byte[])stringBuilder.toString().getBytes(UTF8_CHARSET));
    }

    public void applyTo(HTTPRequest hTTPRequest) {
        hTTPRequest.setAuthorization(this.toHTTPAuthorizationHeader());
    }

    public static ClientSecretBasic parse(String string) throws ParseException {
        String[] stringArray = string.split("\\s");
        if (stringArray.length != 2) {
            throw new ParseException("Malformed client secret basic authentication (see RFC 6749, section 2.3.1): Unexpected number of HTTP Authorization header value parts: " + stringArray.length);
        }
        if (!stringArray[0].equalsIgnoreCase("Basic")) {
            throw new ParseException("HTTP authentication must be \"Basic\"");
        }
        String string2 = new String(new Base64(stringArray[1]).decode(), UTF8_CHARSET);
        String[] stringArray2 = string2.split(":", 2);
        if (stringArray2.length != 2) {
            throw new ParseException("Malformed client secret basic authentication (see RFC 6749, section 2.3.1): Missing credentials delimiter \":\"");
        }
        try {
            String string3 = URLDecoder.decode(stringArray2[0], UTF8_CHARSET.name());
            String string4 = URLDecoder.decode(stringArray2[1], UTF8_CHARSET.name());
            return new ClientSecretBasic(new ClientID(string3), new Secret(string4));
        }
        catch (UnsupportedEncodingException | IllegalArgumentException exception) {
            throw new ParseException("Malformed client secret basic authentication (see RFC 6749, section 2.3.1): Invalid URL encoding", (Throwable)exception);
        }
    }

    public static ClientSecretBasic parse(HTTPRequest hTTPRequest) throws ParseException {
        String string = hTTPRequest.getAuthorization();
        if (string == null) {
            throw new ParseException("Missing HTTP Authorization header");
        }
        return ClientSecretBasic.parse((String)string);
    }

    public static /* bridge */ /* synthetic */ ClientAuthentication parse(HTTPRequest hTTPRequest) throws ParseException {
        return ClientSecretBasic.parse((HTTPRequest)hTTPRequest);
    }
}

