/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth;

import java.util.Map;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthenticationMethod;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientSecretBasic;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientSecretPost;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.JWTAuthentication;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;

public abstract class ClientAuthentication {
    private final ClientAuthenticationMethod method;
    private final ClientID clientID;

    protected ClientAuthentication(ClientAuthenticationMethod clientAuthenticationMethod, ClientID clientID) {
        if (clientAuthenticationMethod == null) {
            throw new IllegalArgumentException("The client authentication method must not be null");
        }
        this.method = clientAuthenticationMethod;
        if (clientID == null) {
            throw new IllegalArgumentException("The client identifier must not be null");
        }
        this.clientID = clientID;
    }

    public ClientAuthenticationMethod getMethod() {
        return this.method;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public static ClientAuthentication parse(HTTPRequest hTTPRequest) throws ParseException {
        if (hTTPRequest.getAuthorization() != null && hTTPRequest.getAuthorization().startsWith("Basic")) {
            return ClientSecretBasic.parse((HTTPRequest)hTTPRequest);
        }
        if (hTTPRequest.getMethod() != HTTPRequest.Method.POST && !hTTPRequest.getContentType().match(CommonContentTypes.APPLICATION_URLENCODED)) {
            return null;
        }
        Map map = hTTPRequest.getQueryParameters();
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)map.get("client_id"))) && StringUtils.isNotBlank((CharSequence)((CharSequence)map.get("client_secret")))) {
            return ClientSecretPost.parse((HTTPRequest)hTTPRequest);
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)map.get("client_assertion"))) && StringUtils.isNotBlank((CharSequence)((CharSequence)map.get("client_assertion_type")))) {
            return JWTAuthentication.parse((HTTPRequest)hTTPRequest);
        }
        return null;
    }

    public abstract void applyTo(HTTPRequest var1);
}

