/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.saml2;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.DateUtils;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.ClockSkewAware;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.saml2.BadSAML2AssertionException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.saml2.SAML2AssertionDetails;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Audience;
import net.jcip.annotations.Immutable;
import org.apache.commons.collections4.CollectionUtils;

@Immutable
public class SAML2AssertionDetailsVerifier
implements ClockSkewAware {
    public static final int DEFAULT_MAX_CLOCK_SKEW_SECONDS = 60;
    private static final BadSAML2AssertionException EXPIRED_SAML2_ASSERTION_EXCEPTION = new BadSAML2AssertionException("Expired SAML 2.0 assertion");
    private static final BadSAML2AssertionException SAML2_ASSERTION_BEFORE_USE_EXCEPTION = new BadSAML2AssertionException("SAML 2.0 assertion before use time");
    private final Set<Audience> expectedAudience;
    private final BadSAML2AssertionException unexpectedAudienceException;
    private int maxClockSkewSeconds = 60;

    public SAML2AssertionDetailsVerifier(Set<Audience> set) {
        if (CollectionUtils.isEmpty(set)) {
            throw new IllegalArgumentException("The expected audience set must not be null or empty");
        }
        this.expectedAudience = set;
        this.unexpectedAudienceException = new BadSAML2AssertionException("Invalid SAML 2.0 audience, expected " + set);
    }

    public Set<Audience> getExpectedAudience() {
        return this.expectedAudience;
    }

    public int getMaxClockSkew() {
        return this.maxClockSkewSeconds;
    }

    public void setMaxClockSkew(int n2) {
        this.maxClockSkewSeconds = n2;
    }

    public void verify(SAML2AssertionDetails sAML2AssertionDetails) throws BadSAML2AssertionException {
        if (!Audience.matchesAny((Collection)this.expectedAudience, (Collection)sAML2AssertionDetails.getAudience())) {
            throw this.unexpectedAudienceException;
        }
        Date date = new Date();
        if (!DateUtils.isAfter((Date)sAML2AssertionDetails.getExpirationTime(), (Date)date, (long)this.maxClockSkewSeconds)) {
            throw EXPIRED_SAML2_ASSERTION_EXCEPTION;
        }
        if (sAML2AssertionDetails.getNotBeforeTime() != null && !DateUtils.isBefore((Date)sAML2AssertionDetails.getNotBeforeTime(), (Date)date, (long)this.maxClockSkewSeconds)) {
            throw SAML2_ASSERTION_BEFORE_USE_EXCEPTION;
        }
    }
}

