/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.saml2;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.AssertionDetails;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Audience;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Identifier;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Issuer;
import macromedia.externals.com.nimbusds.openid.connect.sdk_5_24_1.claims.ACR;
import net.jcip.annotations.Immutable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;

@Immutable
public class SAML2AssertionDetails
extends AssertionDetails {
    private final String subjectFormat;
    private final Date subjectAuthTime;
    private final ACR subjectACR;
    private final Date nbf;
    private final InetAddress clientAddress;
    private final Map<String, List<String>> attrStatement;

    public SAML2AssertionDetails(Issuer issuer, macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Subject subject, Audience audience) {
        this(issuer, subject, null, null, null, audience.toSingleAudienceList(), new Date(new Date().getTime() + 300000L), null, new Date(), new Identifier(), null, null);
    }

    public SAML2AssertionDetails(Issuer issuer, macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Subject subject, String string, Date date, ACR aCR, List<Audience> list, Date date2, Date date3, Date date4, Identifier identifier, InetAddress inetAddress, Map<String, List<String>> map) {
        super(issuer, subject, list, date4, date2, identifier);
        if (date4 == null) {
            throw new IllegalArgumentException("The issue time must not be null");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("The assertion identifier must not be null");
        }
        this.subjectFormat = string;
        this.subjectAuthTime = date;
        this.subjectACR = aCR;
        this.clientAddress = inetAddress;
        this.nbf = date3;
        this.attrStatement = map;
    }

    public String getSubjectFormat() {
        return this.subjectFormat;
    }

    public Date getSubjectAuthenticationTime() {
        return this.subjectAuthTime;
    }

    public ACR getSubjectACR() {
        return this.subjectACR;
    }

    public Date getNotBeforeTime() {
        return this.nbf;
    }

    public InetAddress getClientInetAddress() {
        return this.clientAddress;
    }

    public Map<String, List<String>> getAttributeStatement() {
        return this.attrStatement;
    }

    public Assertion toSAML2Assertion() throws SerializeException {
        AuthnContextClassRef authnContextClassRef;
        SAMLObjectBuilder sAMLObjectBuilder;
        AuthnStatement authnStatement;
        SAMLObjectBuilder sAMLObjectBuilder2;
        org.opensaml.saml2.core.Audience audience;
        Audience audience222;
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException configurationException) {
            throw new SerializeException(configurationException.getMessage(), (Throwable)configurationException);
        }
        XMLObjectBuilderFactory xMLObjectBuilderFactory = Configuration.getBuilderFactory();
        SAMLObjectBuilder sAMLObjectBuilder3 = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = (Assertion)sAMLObjectBuilder3.buildObject();
        assertion.setID(this.getID().getValue());
        assertion.setIssueInstant(new DateTime((Object)this.getIssueTime()));
        SAMLObjectBuilder sAMLObjectBuilder4 = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(org.opensaml.saml2.core.Issuer.DEFAULT_ELEMENT_NAME);
        org.opensaml.saml2.core.Issuer issuer = (org.opensaml.saml2.core.Issuer)sAMLObjectBuilder4.buildObject();
        issuer.setValue(this.getIssuer().getValue());
        assertion.setIssuer(issuer);
        SAMLObjectBuilder sAMLObjectBuilder5 = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)sAMLObjectBuilder5.buildObject();
        SAMLObjectBuilder sAMLObjectBuilder6 = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(AudienceRestriction.DEFAULT_ELEMENT_NAME);
        AudienceRestriction audienceRestriction = (AudienceRestriction)sAMLObjectBuilder6.buildObject();
        SAMLObjectBuilder sAMLObjectBuilder7 = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(org.opensaml.saml2.core.Audience.DEFAULT_ELEMENT_NAME);
        for (Audience audience222 : this.getAudience()) {
            audience = (org.opensaml.saml2.core.Audience)sAMLObjectBuilder7.buildObject();
            audience.setAudienceURI(audience222.getValue());
            audienceRestriction.getAudiences().add(audience);
        }
        conditions.getAudienceRestrictions().add(audienceRestriction);
        assertion.setConditions(conditions);
        audience222 = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(Subject.DEFAULT_ELEMENT_NAME);
        Subject subject = (Subject)audience222.buildObject();
        audience = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(NameID.DEFAULT_ELEMENT_NAME);
        NameID nameID = (NameID)audience.buildObject();
        nameID.setFormat(this.subjectFormat);
        nameID.setValue(this.getSubject().getValue());
        subject.setNameID(nameID);
        SAMLObjectBuilder sAMLObjectBuilder8 = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)sAMLObjectBuilder8.buildObject();
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        SAMLObjectBuilder sAMLObjectBuilder9 = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
        SubjectConfirmationData subjectConfirmationData = (SubjectConfirmationData)sAMLObjectBuilder9.buildObject();
        subjectConfirmationData.setNotOnOrAfter(new DateTime((Object)this.getExpirationTime()));
        subjectConfirmationData.setNotBefore(this.getNotBeforeTime() != null ? new DateTime((Object)this.getNotBeforeTime()) : null);
        subjectConfirmationData.setRecipient(((Audience)this.getAudience().get(0)).getValue());
        if (this.clientAddress != null) {
            subjectConfirmationData.setAddress(this.clientAddress.getHostAddress());
        }
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subject.getSubjectConfirmations().add(subjectConfirmation);
        assertion.setSubject(subject);
        if (this.subjectAuthTime != null || this.subjectACR != null) {
            sAMLObjectBuilder2 = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(AuthnStatement.DEFAULT_ELEMENT_NAME);
            authnStatement = (AuthnStatement)sAMLObjectBuilder2.buildObject();
            if (this.subjectAuthTime != null) {
                authnStatement.setAuthnInstant(new DateTime((Object)this.subjectAuthTime));
            }
            if (this.subjectACR != null) {
                sAMLObjectBuilder = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(AuthnContext.DEFAULT_ELEMENT_NAME);
                AuthnContext object = (AuthnContext)sAMLObjectBuilder.buildObject();
                SAMLObjectBuilder sAMLObjectBuilder10 = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
                authnContextClassRef = (AuthnContextClassRef)sAMLObjectBuilder10.buildObject();
                authnContextClassRef.setAuthnContextClassRef(this.subjectACR.getValue());
                object.setAuthnContextClassRef(authnContextClassRef);
                authnStatement.setAuthnContext(object);
            }
            assertion.getAuthnStatements().add(authnStatement);
        }
        if (MapUtils.isNotEmpty((Map)this.attrStatement)) {
            sAMLObjectBuilder2 = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(AttributeStatement.DEFAULT_ELEMENT_NAME);
            authnStatement = (AttributeStatement)sAMLObjectBuilder2.buildObject();
            sAMLObjectBuilder = (SAMLObjectBuilder)xMLObjectBuilderFactory.getBuilder(Attribute.DEFAULT_ELEMENT_NAME);
            for (Map.Entry entry : this.attrStatement.entrySet()) {
                authnContextClassRef = (Attribute)sAMLObjectBuilder.buildObject();
                authnContextClassRef.setName((String)entry.getKey());
                XSStringBuilder xSStringBuilder = (XSStringBuilder)Configuration.getBuilderFactory().getBuilder(XSString.TYPE_NAME);
                for (String string : (List)entry.getValue()) {
                    XSString xSString = (XSString)xSStringBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
                    xSString.setValue(string);
                    authnContextClassRef.getAttributeValues().add(xSString);
                }
                authnStatement.getAttributes().add(authnContextClassRef);
            }
            assertion.getAttributeStatements().add(authnStatement);
        }
        return assertion;
    }

    public static SAML2AssertionDetails parse(Assertion assertion) throws ParseException {
        Object object2;
        org.opensaml.saml2.core.Audience audience2;
        AudienceRestriction audienceRestriction;
        SubjectConfirmation subjectConfirmation2;
        List list2;
        if (assertion.getIssuer() == null) {
            throw new ParseException("Missing Assertion Issuer element");
        }
        Issuer issuer = new Issuer(assertion.getIssuer().getValue());
        if (assertion.getSubject() == null) {
            throw new ParseException("Missing Assertion Subject element");
        }
        if (assertion.getSubject().getNameID() == null) {
            throw new ParseException("Missing Assertion Subject NameID element");
        }
        macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Subject subject = new macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Subject(assertion.getSubject().getNameID().getValue());
        String string = assertion.getSubject().getNameID().getFormat();
        Date date = null;
        ACR aCR = null;
        if (CollectionUtils.isNotEmpty((Collection)assertion.getAuthnStatements())) {
            for (List list2 : assertion.getAuthnStatements()) {
                if (list2 == null) continue;
                if (list2.getAuthnInstant() != null) {
                    date = list2.getAuthnInstant().toDate();
                }
                if (list2.getAuthnContext() == null || list2.getAuthnContext().getAuthnContextClassRef() == null) continue;
                aCR = new ACR(list2.getAuthnContext().getAuthnContextClassRef().getAuthnContextClassRef());
            }
        }
        if (CollectionUtils.isEmpty((Collection)(list2 = assertion.getSubject().getSubjectConfirmations()))) {
            throw new ParseException("Missing SubjectConfirmation element");
        }
        boolean bl2 = false;
        for (SubjectConfirmation subjectConfirmation2 : list2) {
            if (!"urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(subjectConfirmation2.getMethod())) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            throw new ParseException("Missing SubjectConfirmation Method urn:oasis:names:tc:SAML:2.0:cm:bearer attribute");
        }
        subjectConfirmation2 = assertion.getConditions();
        if (subjectConfirmation2 == null) {
            throw new ParseException("Missing Conditions element");
        }
        List list3 = subjectConfirmation2.getAudienceRestrictions();
        if (CollectionUtils.isEmpty((Collection)list3)) {
            throw new ParseException("Missing AudienceRestriction element");
        }
        HashSet<Audience> hashSet = new HashSet<Audience>();
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            audienceRestriction = (AudienceRestriction)iterator.next();
            if (CollectionUtils.isEmpty((Collection)audienceRestriction.getAudiences())) continue;
            for (org.opensaml.saml2.core.Audience audience2 : audienceRestriction.getAudiences()) {
                hashSet.add(new Audience(audience2.getAudienceURI()));
            }
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            audienceRestriction = (SubjectConfirmation)iterator.next();
            if (audienceRestriction.getSubjectConfirmationData() == null) continue;
            if (audienceRestriction.getSubjectConfirmationData().getRecipient() == null) {
                throw new ParseException("Missing SubjectConfirmationData Recipient attribute");
            }
            hashSet.add(new Audience(audienceRestriction.getSubjectConfirmationData().getRecipient()));
        }
        audienceRestriction = subjectConfirmation2.getNotOnOrAfter() != null ? subjectConfirmation2.getNotOnOrAfter().toDate() : null;
        Iterator iterator2 = iterator = subjectConfirmation2.getNotBefore() != null ? subjectConfirmation2.getNotBefore().toDate() : null;
        if (audienceRestriction == null) {
            for (org.opensaml.saml2.core.Audience audience2 : list2) {
                if (audience2.getSubjectConfirmationData() == null) continue;
                audienceRestriction = audience2.getSubjectConfirmationData().getNotOnOrAfter() != null ? audience2.getSubjectConfirmationData().getNotOnOrAfter().toDate() : null;
                Iterator iterator3 = iterator = audience2.getSubjectConfirmationData().getNotBefore() != null ? audience2.getSubjectConfirmationData().getNotBefore().toDate() : null;
            }
        }
        if (assertion.getID() == null) {
            throw new ParseException("Missing Assertion ID attribute");
        }
        audience2 = new Identifier(assertion.getID());
        if (assertion.getIssueInstant() == null) {
            throw new ParseException("Missing Assertion IssueInstant attribute");
        }
        Date date2 = assertion.getIssueInstant().toDate();
        InetAddress inetAddress = null;
        for (Object object2 : list2) {
            if (object2.getSubjectConfirmationData() == null || object2.getSubjectConfirmationData().getAddress() == null) continue;
            try {
                inetAddress = InetAddress.getByName(object2.getSubjectConfirmationData().getAddress());
            }
            catch (UnknownHostException unknownHostException) {
                throw new ParseException("Invalid Address: " + unknownHostException.getMessage(), (Throwable)unknownHostException);
            }
        }
        object2 = null;
        if (CollectionUtils.isNotEmpty((Collection)assertion.getAttributeStatements())) {
            object2 = new HashMap();
            for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
                if (attributeStatement == null) continue;
                for (Attribute attribute : attributeStatement.getAttributes()) {
                    String string2 = attribute.getName();
                    LinkedList<String> linkedList = new LinkedList<String>();
                    for (XMLObject xMLObject : attribute.getAttributeValues()) {
                        linkedList.add(xMLObject.getDOM().getTextContent());
                    }
                    object2.put(string2, linkedList);
                }
            }
        }
        return new SAML2AssertionDetails(issuer, subject, string, date, aCR, new ArrayList(hashSet), (Date)audienceRestriction, iterator, date2, (Identifier)audience2, inetAddress, (Map)object2);
    }
}

