/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.jwt;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.DateUtils;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.assertions.AssertionDetails;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Audience;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Identifier;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Issuer;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.JWTID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Subject;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.JSONObjectUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class JWTAssertionDetails
extends AssertionDetails {
    private static final Set<String> reservedClaimsNames = new LinkedHashSet();
    private final Date nbf;
    private final Map<String, Object> other;

    static {
        reservedClaimsNames.add("iss");
        reservedClaimsNames.add("sub");
        reservedClaimsNames.add("aud");
        reservedClaimsNames.add("exp");
        reservedClaimsNames.add("nbf");
        reservedClaimsNames.add("iat");
        reservedClaimsNames.add("jti");
    }

    public static Set<String> getReservedClaimsNames() {
        return Collections.unmodifiableSet(reservedClaimsNames);
    }

    public JWTAssertionDetails(Issuer issuer, Subject subject, Audience audience) {
        this(issuer, subject, audience.toSingleAudienceList(), new Date(new Date().getTime() + 300000L), null, null, new JWTID(), null);
    }

    public JWTAssertionDetails(Issuer issuer, Subject subject, List<Audience> list, Date date, Date date2, Date date3, JWTID jWTID, Map<String, Object> map) {
        super(issuer, subject, list, date3, date, (Identifier)jWTID);
        this.nbf = date2;
        this.other = map;
    }

    public Date getNotBeforeTime() {
        return this.nbf;
    }

    public JWTID getJWTID() {
        Identifier identifier = this.getID();
        return identifier != null ? new JWTID(identifier.getValue()) : null;
    }

    public Map<String, Object> getCustomClaims() {
        return this.other;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"iss", (Object)this.getIssuer().getValue());
        jSONObject.put((Object)"sub", (Object)this.getSubject().getValue());
        jSONObject.put((Object)"aud", (Object)Audience.toStringList((List)this.getAudience()));
        jSONObject.put((Object)"exp", (Object)DateUtils.toSecondsSinceEpoch((Date)this.getExpirationTime()));
        if (this.nbf != null) {
            jSONObject.put((Object)"nbf", (Object)DateUtils.toSecondsSinceEpoch((Date)this.nbf));
        }
        if (this.getIssueTime() != null) {
            jSONObject.put((Object)"iat", (Object)DateUtils.toSecondsSinceEpoch((Date)this.getIssueTime()));
        }
        if (this.getID() != null) {
            jSONObject.put((Object)"jti", (Object)this.getID().getValue());
        }
        if (this.other != null) {
            jSONObject.putAll(this.other);
        }
        return jSONObject;
    }

    public JWTClaimsSet toJWTClaimsSet() {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder().issuer(this.getIssuer().getValue()).subject(this.getSubject().getValue()).audience(Audience.toStringList((List)this.getAudience())).expirationTime(this.getExpirationTime()).notBeforeTime(this.nbf).issueTime(this.getIssueTime()).jwtID(this.getID() != null ? this.getJWTID().getValue() : null);
        if (this.other != null) {
            for (Map.Entry entry : this.other.entrySet()) {
                builder = builder.claim((String)entry.getKey(), entry.getValue());
            }
        }
        return builder.build();
    }

    public static JWTAssertionDetails parse(JSONObject jSONObject) throws ParseException {
        Issuer issuer = new Issuer(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"iss"));
        Subject subject = new Subject(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"sub"));
        List list = jSONObject.get((Object)"aud") instanceof String ? new Audience(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"aud")).toSingleAudienceList() : Audience.create((List)JSONObjectUtils.getStringList((JSONObject)jSONObject, (String)"aud"));
        Date date = DateUtils.fromSecondsSinceEpoch((long)JSONObjectUtils.getLong((JSONObject)jSONObject, (String)"exp"));
        Date date2 = null;
        if (jSONObject.containsKey((Object)"nbf")) {
            date2 = DateUtils.fromSecondsSinceEpoch((long)JSONObjectUtils.getLong((JSONObject)jSONObject, (String)"nbf"));
        }
        Date date3 = null;
        if (jSONObject.containsKey((Object)"iat")) {
            date3 = DateUtils.fromSecondsSinceEpoch((long)JSONObjectUtils.getLong((JSONObject)jSONObject, (String)"iat"));
        }
        JWTID jWTID = null;
        if (jSONObject.containsKey((Object)"jti")) {
            jWTID = new JWTID(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"jti"));
        }
        LinkedHashMap<String, Object> linkedHashMap = null;
        Set set = jSONObject.keySet();
        if (set.removeAll(reservedClaimsNames)) {
            linkedHashMap = new LinkedHashMap<String, Object>();
            for (String string : set) {
                linkedHashMap.put(string, jSONObject.get((Object)string));
            }
        }
        return new JWTAssertionDetails(issuer, subject, list, date, date2, date3, jWTID, linkedHashMap);
    }

    public static JWTAssertionDetails parse(JWTClaimsSet jWTClaimsSet) throws ParseException {
        return JWTAssertionDetails.parse((JSONObject)jWTClaimsSet.toJSONObject());
    }
}

