/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AbstractOptionallyIdentifiedRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.TokenRevocationRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthentication;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.AccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.RefreshToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.Token;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.TypelessAccessToken;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import net.jcip.annotations.Immutable;

@Immutable
public final class TokenRevocationRequest
extends AbstractOptionallyIdentifiedRequest {
    private final Token token;

    public TokenRevocationRequest(URI uRI, ClientAuthentication clientAuthentication, Token token) {
        super(uRI, clientAuthentication);
        if (clientAuthentication == null) {
            throw new IllegalArgumentException("The client authentication must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("The token must not be null");
        }
        this.token = token;
    }

    public TokenRevocationRequest(URI uRI, ClientID clientID, Token token) {
        super(uRI, clientID);
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("The token must not be null");
        }
        this.token = token;
    }

    public Token getToken() {
        return this.token;
    }

    public HTTPRequest toHTTPRequest() {
        URL uRL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            uRL = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SerializeException(malformedURLException.getMessage(), (Throwable)malformedURLException);
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, uRL);
        hTTPRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.getClientID() != null) {
            hashMap.put("client_id", this.getClientID().getValue());
        }
        hashMap.put("token", this.token.getValue());
        if (this.token instanceof AccessToken) {
            hashMap.put("token_type_hint", "access_token");
        } else if (this.token instanceof RefreshToken) {
            hashMap.put("token_type_hint", "refresh_token");
        }
        hTTPRequest.setQuery(URLUtils.serializeParameters(hashMap));
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(hTTPRequest);
        }
        return hTTPRequest;
    }

    public static TokenRevocationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        URI uRI;
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        Map map = hTTPRequest.getQueryParameters();
        String string = (String)map.get("token");
        if (string == null || string.isEmpty()) {
            throw new ParseException("Missing required token parameter");
        }
        1 var3_3 = null;
        String string2 = (String)map.get("token_type_hint");
        if (string2 == null) {
            var3_3 = new /* Unavailable Anonymous Inner Class!! */;
        } else if (string2.equals("access_token")) {
            var3_3 = new TypelessAccessToken(string);
        } else if (string2.equals("refresh_token")) {
            var3_3 = new RefreshToken(string);
        }
        try {
            uRI = hTTPRequest.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
        ClientAuthentication clientAuthentication = ClientAuthentication.parse((HTTPRequest)hTTPRequest);
        if (clientAuthentication != null) {
            return new TokenRevocationRequest(uRI, clientAuthentication, (Token)var3_3);
        }
        String string3 = (String)map.get("client_id");
        if (StringUtils.isBlank((CharSequence)string3)) {
            throw new ParseException("Invalid token revocation request: No client authentication or client_id parameter found");
        }
        return new TokenRevocationRequest(uRI, new ClientID(string3), (Token)var3_3);
    }
}

