/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AbstractOptionallyIdentifiedRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.OAuth2Error;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.Scope;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientAuthentication;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.auth.ClientSecretBasic;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import net.jcip.annotations.Immutable;
import org.apache.commons.collections4.MapUtils;

@Immutable
public class TokenRequest
extends AbstractOptionallyIdentifiedRequest {
    private final AuthorizationGrant authzGrant;
    private final Scope scope;
    private final Map<String, String> customParams;

    public TokenRequest(URI uRI, ClientAuthentication clientAuthentication, AuthorizationGrant authorizationGrant, Scope scope) {
        this(uRI, clientAuthentication, authorizationGrant, scope, null);
    }

    public TokenRequest(URI uRI, ClientAuthentication clientAuthentication, AuthorizationGrant authorizationGrant, Scope scope, Map<String, String> map) {
        super(uRI, clientAuthentication);
        if (clientAuthentication == null) {
            throw new IllegalArgumentException("The client authentication must not be null");
        }
        this.authzGrant = authorizationGrant;
        this.scope = scope;
        this.customParams = MapUtils.isNotEmpty(map) ? map : Collections.emptyMap();
    }

    public TokenRequest(URI uRI, ClientAuthentication clientAuthentication, AuthorizationGrant authorizationGrant) {
        this(uRI, clientAuthentication, authorizationGrant, null);
    }

    public TokenRequest(URI uRI, ClientID clientID, AuthorizationGrant authorizationGrant, Scope scope) {
        this(uRI, clientID, authorizationGrant, scope, null);
    }

    public TokenRequest(URI uRI, ClientID clientID, AuthorizationGrant authorizationGrant, Scope scope, Map<String, String> map) {
        super(uRI, clientID);
        if (authorizationGrant.getType().requiresClientAuthentication()) {
            throw new IllegalArgumentException("The \"" + authorizationGrant.getType() + "\" grant type requires client authentication");
        }
        if (authorizationGrant.getType().requiresClientID() && clientID == null) {
            throw new IllegalArgumentException("The \"" + authorizationGrant.getType() + "\" grant type requires a \"client_id\" parameter");
        }
        this.authzGrant = authorizationGrant;
        this.scope = scope;
        this.customParams = MapUtils.isNotEmpty(map) ? map : Collections.emptyMap();
    }

    public TokenRequest(URI uRI, ClientID clientID, AuthorizationGrant authorizationGrant) {
        this(uRI, clientID, authorizationGrant, null);
    }

    public TokenRequest(URI uRI, AuthorizationGrant authorizationGrant, Scope scope) {
        this(uRI, null, authorizationGrant, scope);
    }

    public TokenRequest(URI uRI, AuthorizationGrant authorizationGrant) {
        this(uRI, null, authorizationGrant, null);
    }

    public AuthorizationGrant getAuthorizationGrant() {
        return this.authzGrant;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParams;
    }

    public String getCustomParameter(String string) {
        return (String)this.customParams.get(string);
    }

    public HTTPRequest toHTTPRequest() {
        URL uRL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            uRL = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SerializeException(malformedURLException.getMessage(), (Throwable)malformedURLException);
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, uRL);
        hTTPRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(hTTPRequest);
        }
        Map map = hTTPRequest.getQueryParameters();
        map.putAll(this.authzGrant.toParameters());
        if (this.scope != null && !this.scope.isEmpty()) {
            map.put("scope", this.scope.toString());
        }
        if (this.getClientID() != null) {
            map.put("client_id", this.getClientID().getValue());
        }
        if (!this.getCustomParameters().isEmpty()) {
            map.putAll(this.getCustomParameters());
        }
        hTTPRequest.setQuery(URLUtils.serializeParameters((Map)map));
        return hTTPRequest;
    }

    public static TokenRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        String string;
        ClientAuthentication clientAuthentication;
        URI uRI;
        try {
            uRI = hTTPRequest.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureContentType(CommonContentTypes.APPLICATION_URLENCODED);
        try {
            clientAuthentication = ClientAuthentication.parse((HTTPRequest)hTTPRequest);
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), OAuth2Error.INVALID_REQUEST.appendDescription(": " + parseException.getMessage()));
        }
        Map map = hTTPRequest.getQueryParameters();
        if (clientAuthentication instanceof ClientSecretBasic && (StringUtils.isNotBlank((CharSequence)((CharSequence)map.get("client_assertion"))) || StringUtils.isNotBlank((CharSequence)((CharSequence)map.get("client_assertion_type"))))) {
            String string2 = "Multiple conflicting client authentication methods found: Basic and JWT assertion";
            throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string2));
        }
        AuthorizationGrant authorizationGrant = AuthorizationGrant.parse((Map)map);
        if (clientAuthentication == null && authorizationGrant.getType().requiresClientAuthentication()) {
            String string3 = "Missing client authentication";
            throw new ParseException(string3, OAuth2Error.INVALID_CLIENT.appendDescription(": " + string3));
        }
        ClientID clientID = null;
        if (clientAuthentication == null) {
            string = (String)map.get("client_id");
            if (string != null && !string.trim().isEmpty()) {
                clientID = new ClientID(string);
            }
            if (clientID == null && authorizationGrant.getType().requiresClientID()) {
                String string4 = "Missing required \"client_id\" parameter";
                throw new ParseException(string4, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string4));
            }
        }
        string = (String)map.get("scope");
        Scope scope = null;
        if (string != null) {
            scope = Scope.parse((String)string);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("grant_type") || ((String)entry.getKey()).equalsIgnoreCase("client_id") || ((String)entry.getKey()).equalsIgnoreCase("client_secret") || ((String)entry.getKey()).equalsIgnoreCase("client_assertion_type") || ((String)entry.getKey()).equalsIgnoreCase("client_assertion") || ((String)entry.getKey()).equalsIgnoreCase("scope") || authorizationGrant.getType().getRequestParameterNames().contains(entry.getKey())) continue;
            hashMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (clientAuthentication != null) {
            return new TokenRequest(uRI, clientAuthentication, authorizationGrant, scope, hashMap);
        }
        return new TokenRequest(uRI, clientID, authorizationGrant, scope, hashMap);
    }
}

