/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ErrorObject;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ErrorResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.OAuth2Error;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.TokenIntrospectionResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.token.BearerTokenError;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class TokenIntrospectionErrorResponse
extends TokenIntrospectionResponse
implements ErrorResponse {
    private static final Set<ErrorObject> STANDARD_ERRORS;
    private final ErrorObject error;

    static {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(OAuth2Error.INVALID_REQUEST);
        hashSet.add(OAuth2Error.INVALID_CLIENT);
        hashSet.add(BearerTokenError.MISSING_TOKEN);
        hashSet.add(BearerTokenError.INVALID_REQUEST);
        hashSet.add(BearerTokenError.INVALID_TOKEN);
        hashSet.add(BearerTokenError.INSUFFICIENT_SCOPE);
        STANDARD_ERRORS = Collections.unmodifiableSet(hashSet);
    }

    public static Set<ErrorObject> getStandardErrors() {
        return STANDARD_ERRORS;
    }

    public TokenIntrospectionErrorResponse(ErrorObject errorObject) {
        this.error = errorObject;
    }

    public ErrorObject getErrorObject() {
        return this.error;
    }

    public boolean indicatesSuccess() {
        return false;
    }

    public HTTPResponse toHTTPResponse() {
        int n2 = this.error != null && this.error.getHTTPStatusCode() > 0 ? this.error.getHTTPStatusCode() : 400;
        HTTPResponse hTTPResponse = new HTTPResponse(n2);
        if (this.error == null) {
            return hTTPResponse;
        }
        if (this.error instanceof BearerTokenError) {
            hTTPResponse.setWWWAuthenticate(((BearerTokenError)this.error).toWWWAuthenticateHeader());
        }
        hTTPResponse.setContentType(CommonContentTypes.APPLICATION_JSON);
        hTTPResponse.setCacheControl("no-store");
        hTTPResponse.setPragma("no-cache");
        hTTPResponse.setContent(this.error.toJSONObject().toJSONString());
        return hTTPResponse;
    }

    public static TokenIntrospectionErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCodeNotOK();
        String string = hTTPResponse.getWWWAuthenticate();
        if ((hTTPResponse.getStatusCode() == 401 || hTTPResponse.getStatusCode() == 403) && string != null && string.toLowerCase().startsWith("bearer")) {
            try {
                return new TokenIntrospectionErrorResponse((ErrorObject)BearerTokenError.parse((String)hTTPResponse.getWWWAuthenticate()));
            }
            catch (ParseException parseException) {}
        }
        return new TokenIntrospectionErrorResponse(ErrorObject.parse((HTTPResponse)hTTPResponse));
    }

    public static /* bridge */ /* synthetic */ TokenIntrospectionResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        return TokenIntrospectionErrorResponse.parse((HTTPResponse)hTTPResponse);
    }
}

