/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.util.Arrays;
import java.util.HashSet;
import java.util.StringTokenizer;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseType;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class ResponseType
extends HashSet<Value> {
    public static ResponseType getDefault() {
        ResponseType responseType = new ResponseType();
        responseType.add((Object)Value.CODE);
        return responseType;
    }

    public ResponseType() {
    }

    public ResponseType(String ... stringArray) {
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            this.add((Object)new Value(string));
            ++n3;
        }
    }

    public ResponseType(Value ... valueArray) {
        this.addAll(Arrays.asList(valueArray));
    }

    public static ResponseType parse(String string) throws ParseException {
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new ParseException("Null or empty response type string");
        }
        ResponseType responseType = new ResponseType();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            responseType.add((Object)new Value(stringTokenizer.nextToken()));
        }
        return responseType;
    }

    public boolean impliesCodeFlow() {
        return this.contains((Object)Value.CODE) && this.size() == 1;
    }

    public boolean impliesImplicitFlow() {
        return !this.impliesCodeFlow();
    }

    public boolean contains(String string) {
        return this.contains((Object)new Value(string));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Value value : this) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(value.getValue());
        }
        return stringBuilder.toString();
    }
}

