/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.util.LinkedHashMap;
import java.util.Map;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.PlainObject;
import macromedia.externals.com.nimbusds.jwt_8_2_1.EncryptedJWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.SignedJWT;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AssertionGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationGrant;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.GrantType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.OAuth2Error;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class JWTBearerGrant
extends AssertionGrant {
    public static final GrantType GRANT_TYPE = GrantType.JWT_BEARER;
    private static final ParseException UNSUPPORTED_GRANT_TYPE_EXCEPTION = new ParseException("The \"grant_type\" must be " + GRANT_TYPE, OAuth2Error.UNSUPPORTED_GRANT_TYPE);
    private static final ParseException PLAIN_ASSERTION_REJECTED_EXCEPTION = new ParseException("The JWT assertion must not be unsecured (plain)", OAuth2Error.INVALID_REQUEST);
    private static final ParseException JWT_PARSE_EXCEPTION = new ParseException("The \"assertion\" is not a JWT", OAuth2Error.INVALID_REQUEST);
    private final JOSEObject assertion;

    public JWTBearerGrant(SignedJWT signedJWT) {
        super(GRANT_TYPE);
        if (signedJWT.getState().equals((Object)JWSObject.State.UNSIGNED)) {
            throw new IllegalArgumentException("The JWT assertion must not be in a unsigned state");
        }
        this.assertion = signedJWT;
    }

    public JWTBearerGrant(JWEObject jWEObject) {
        super(GRANT_TYPE);
        if (jWEObject.getState().equals((Object)JWEObject.State.UNENCRYPTED)) {
            throw new IllegalArgumentException("The JWT assertion must not be in a unencrypted state");
        }
        this.assertion = jWEObject;
    }

    public JWTBearerGrant(EncryptedJWT encryptedJWT) {
        this((JWEObject)encryptedJWT);
    }

    public JWT getJWTAssertion() {
        return this.assertion instanceof JWT ? (JWT)this.assertion : null;
    }

    public JOSEObject getJOSEAssertion() {
        return this.assertion;
    }

    public String getAssertion() {
        return this.assertion.serialize();
    }

    public Map<String, String> toParameters() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("grant_type", GRANT_TYPE.getValue());
        linkedHashMap.put("assertion", this.assertion.serialize());
        return linkedHashMap;
    }

    public static JWTBearerGrant parse(Map<String, String> map) throws ParseException {
        String string = map.get("grant_type");
        if (string == null) {
            throw MISSING_GRANT_TYPE_PARAM_EXCEPTION;
        }
        if (!GrantType.parse((String)string).equals((Object)GRANT_TYPE)) {
            throw UNSUPPORTED_GRANT_TYPE_EXCEPTION;
        }
        String string2 = map.get("assertion");
        if (string2 == null || string2.trim().isEmpty()) {
            throw MISSING_ASSERTION_PARAM_EXCEPTION;
        }
        try {
            JOSEObject jOSEObject = JOSEObject.parse((String)string2);
            if (jOSEObject instanceof PlainObject) {
                throw PLAIN_ASSERTION_REJECTED_EXCEPTION;
            }
            if (jOSEObject instanceof JWSObject) {
                return new JWTBearerGrant(new SignedJWT(jOSEObject.getParsedParts()[0], jOSEObject.getParsedParts()[1], jOSEObject.getParsedParts()[2]));
            }
            if ("JWT".equalsIgnoreCase(jOSEObject.getHeader().getContentType())) {
                return new JWTBearerGrant((JWEObject)jOSEObject);
            }
            return new JWTBearerGrant(new EncryptedJWT(jOSEObject.getParsedParts()[0], jOSEObject.getParsedParts()[1], jOSEObject.getParsedParts()[2], jOSEObject.getParsedParts()[3], jOSEObject.getParsedParts()[4]));
        }
        catch (java.text.ParseException parseException) {
            throw JWT_PARSE_EXCEPTION;
        }
    }

    public static /* bridge */ /* synthetic */ AuthorizationGrant parse(Map map) throws ParseException {
        return JWTBearerGrant.parse((Map)map);
    }
}

