/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.Identifier;
import net.jcip.annotations.Immutable;

@Immutable
public final class GrantType
extends Identifier {
    public static final GrantType AUTHORIZATION_CODE = new GrantType("authorization_code", false, true, new HashSet<String>(Arrays.asList("code", "redirect_uri", "code_verifier")));
    public static final GrantType IMPLICIT = new GrantType("implicit", false, true, Collections.emptySet());
    public static final GrantType REFRESH_TOKEN = new GrantType("refresh_token", false, false, Collections.singleton("refresh_token"));
    public static final GrantType PASSWORD = new GrantType("password", false, false, new HashSet<String>(Arrays.asList("username", "password")));
    public static final GrantType CLIENT_CREDENTIALS = new GrantType("client_credentials", true, true, Collections.emptySet());
    public static final GrantType JWT_BEARER = new GrantType("urn:ietf:params:oauth:grant-type:jwt-bearer", false, false, Collections.singleton("assertion"));
    public static final GrantType SAML2_BEARER = new GrantType("urn:ietf:params:oauth:grant-type:saml2-bearer", false, false, Collections.singleton("assertion"));
    private final boolean requiresClientAuth;
    private final boolean requiresClientID;
    private final Set<String> requestParamNames;

    public GrantType(String string) {
        this(string, false, false, Collections.emptySet());
    }

    private GrantType(String string, boolean bl2, boolean bl3, Set<String> set) {
        super(string);
        this.requiresClientAuth = bl2;
        this.requiresClientID = bl3;
        this.requestParamNames = set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
    }

    public boolean requiresClientAuthentication() {
        return this.requiresClientAuth;
    }

    public boolean requiresClientID() {
        return this.requiresClientID;
    }

    public Set<String> getRequestParameterNames() {
        return this.requestParamNames;
    }

    public boolean equals(Object object) {
        return object instanceof GrantType && this.toString().equals(object.toString());
    }

    public static GrantType parse(String string) throws ParseException {
        GrantType grantType;
        try {
            grantType = new GrantType(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage());
        }
        if (grantType.equals((Object)AUTHORIZATION_CODE)) {
            return AUTHORIZATION_CODE;
        }
        if (grantType.equals((Object)IMPLICIT)) {
            return IMPLICIT;
        }
        if (grantType.equals((Object)REFRESH_TOKEN)) {
            return REFRESH_TOKEN;
        }
        if (grantType.equals((Object)PASSWORD)) {
            return PASSWORD;
        }
        if (grantType.equals((Object)CLIENT_CREDENTIALS)) {
            return CLIENT_CREDENTIALS;
        }
        if (grantType.equals((Object)JWT_BEARER)) {
            return JWT_BEARER;
        }
        if (grantType.equals((Object)SAML2_BEARER)) {
            return SAML2_BEARER;
        }
        return grantType;
    }
}

