/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationErrorResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AuthorizationSuccessResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.Response;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseMode;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.CommonContentTypes;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPResponse;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.State;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URIUtils;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AuthorizationResponse
implements Response {
    private final URI redirectURI;
    private final State state;
    private final ResponseMode rm;

    protected AuthorizationResponse(URI uRI, State state, ResponseMode responseMode) {
        if (uRI == null) {
            throw new IllegalArgumentException("The redirection URI must not be null");
        }
        this.redirectURI = uRI;
        this.state = state;
        this.rm = responseMode;
    }

    public URI getRedirectionURI() {
        return this.redirectURI;
    }

    public State getState() {
        return this.state;
    }

    public ResponseMode getResponseMode() {
        return this.rm;
    }

    public abstract ResponseMode impliedResponseMode();

    public abstract Map<String, String> toParameters();

    public URI toURI() {
        ResponseMode responseMode = this.impliedResponseMode();
        StringBuilder stringBuilder = new StringBuilder(this.getRedirectionURI().toString());
        if (responseMode.equals((Object)ResponseMode.QUERY)) {
            if (StringUtils.isBlank((CharSequence)this.getRedirectionURI().getRawQuery())) {
                stringBuilder.append('?');
            } else {
                stringBuilder.append('&');
            }
        } else if (responseMode.equals((Object)ResponseMode.FRAGMENT)) {
            stringBuilder.append('#');
        } else {
            throw new SerializeException("The (implied) response mode must be query or fragment");
        }
        stringBuilder.append(URLUtils.serializeParameters((Map)this.toParameters()));
        try {
            return new URI(stringBuilder.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SerializeException("Couldn't serialize response: " + uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
    }

    public HTTPResponse toHTTPResponse() {
        if (ResponseMode.FORM_POST.equals((Object)this.rm)) {
            throw new SerializeException("The response mode must not be form_post");
        }
        HTTPResponse hTTPResponse = new HTTPResponse(302);
        hTTPResponse.setLocation(this.toURI());
        return hTTPResponse;
    }

    public HTTPRequest toHTTPRequest() {
        HTTPRequest hTTPRequest;
        if (!ResponseMode.FORM_POST.equals((Object)this.rm)) {
            throw new SerializeException("The response mode must be form_post");
        }
        try {
            hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.redirectURI.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw new SerializeException(malformedURLException.getMessage(), (Throwable)malformedURLException);
        }
        hTTPRequest.setContentType(CommonContentTypes.APPLICATION_URLENCODED);
        hTTPRequest.setQuery(URLUtils.serializeParameters((Map)this.toParameters()));
        return hTTPRequest;
    }

    public static AuthorizationResponse parse(URI uRI, Map<String, String> map) throws ParseException {
        if (StringUtils.isNotBlank((CharSequence)map.get("error"))) {
            return AuthorizationErrorResponse.parse((URI)uRI, map);
        }
        return AuthorizationSuccessResponse.parse((URI)uRI, map);
    }

    public static AuthorizationResponse parse(URI uRI) throws ParseException {
        Map map;
        if (uRI.getRawFragment() != null) {
            map = URLUtils.parseParameters((String)uRI.getRawFragment());
        } else if (uRI.getRawQuery() != null) {
            map = URLUtils.parseParameters((String)uRI.getRawQuery());
        } else {
            throw new ParseException("Missing URI fragment or query string");
        }
        return AuthorizationResponse.parse((URI)URIUtils.getBaseURI((URI)uRI), (Map)map);
    }

    public static AuthorizationResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        URI uRI = hTTPResponse.getLocation();
        if (uRI == null) {
            throw new ParseException("Missing redirection URI / HTTP Location header");
        }
        return AuthorizationResponse.parse((URI)uRI);
    }

    public static AuthorizationResponse parse(HTTPRequest hTTPRequest) throws ParseException {
        URI uRI;
        try {
            uRI = hTTPRequest.getURL().toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
        if (hTTPRequest.getQuery() != null) {
            return AuthorizationResponse.parse((URI)uRI, (Map)URLUtils.parseParameters((String)hTTPRequest.getQuery()));
        }
        if (hTTPRequest.getFragment() != null) {
            return AuthorizationResponse.parse((URI)uRI, (Map)URLUtils.parseParameters((String)hTTPRequest.getFragment()));
        }
        throw new ParseException("Missing URI fragment, query string or post body");
    }
}

