/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.AbstractRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.OAuth2Error;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ParseException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseMode;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.ResponseType;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.Scope;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.SerializeException;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.http.HTTPRequest;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.ClientID;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.id.State;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.pkce.CodeChallenge;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.pkce.CodeChallengeMethod;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URIUtils;
import macromedia.externals.com.nimbusds.oauth2.sdk_5_24_1.util.URLUtils;
import macromedia.externals.org.apache.commons_3_5.lang3.StringUtils;
import net.jcip.annotations.Immutable;
import org.apache.commons.collections4.MapUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public class AuthorizationRequest
extends AbstractRequest {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final ResponseType rt;
    private final ClientID clientID;
    private final URI redirectURI;
    private final Scope scope;
    private final State state;
    private final ResponseMode rm;
    private final CodeChallenge codeChallenge;
    private final CodeChallengeMethod codeChallengeMethod;
    private final Map<String, String> customParams;

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("response_type");
        hashSet.add("client_id");
        hashSet.add("redirect_uri");
        hashSet.add("scope");
        hashSet.add("state");
        hashSet.add("response_mode");
        hashSet.add("code_challenge");
        hashSet.add("code_challenge_method");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public AuthorizationRequest(URI uRI, ResponseType responseType, ClientID clientID) {
        this(uRI, responseType, null, clientID, null, null, null, null, null);
    }

    public AuthorizationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, ClientID clientID, URI uRI2, Scope scope, State state) {
        this(uRI, responseType, responseMode, clientID, uRI2, scope, state, null, null);
    }

    public AuthorizationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, ClientID clientID, URI uRI2, Scope scope, State state, CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod) {
        this(uRI, responseType, responseMode, clientID, uRI2, scope, state, codeChallenge, codeChallengeMethod, Collections.emptyMap());
    }

    public AuthorizationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, ClientID clientID, URI uRI2, Scope scope, State state, CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod, Map<String, String> map) {
        super(uRI);
        if (responseType == null) {
            throw new IllegalArgumentException("The response type must not be null");
        }
        this.rt = responseType;
        this.rm = responseMode;
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.clientID = clientID;
        this.redirectURI = uRI2;
        this.scope = scope;
        this.state = state;
        this.codeChallenge = codeChallenge;
        this.codeChallengeMethod = codeChallengeMethod;
        this.customParams = MapUtils.isNotEmpty(map) ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public ResponseType getResponseType() {
        return this.rt;
    }

    public ResponseMode getResponseMode() {
        return this.rm;
    }

    public ResponseMode impliedResponseMode() {
        if (this.rm != null) {
            return this.rm;
        }
        if (this.rt.impliesImplicitFlow()) {
            return ResponseMode.FRAGMENT;
        }
        return ResponseMode.QUERY;
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public URI getRedirectionURI() {
        return this.redirectURI;
    }

    public Scope getScope() {
        return this.scope;
    }

    public State getState() {
        return this.state;
    }

    public CodeChallenge getCodeChallenge() {
        return this.codeChallenge;
    }

    public CodeChallengeMethod getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParams;
    }

    public String getCustomParameter(String string) {
        return (String)this.customParams.get(string);
    }

    public Map<String, String> toParameters() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.putAll(this.customParams);
        linkedHashMap.put("response_type", this.rt.toString());
        linkedHashMap.put("client_id", this.clientID.getValue());
        if (this.rm != null) {
            linkedHashMap.put("response_mode", this.rm.getValue());
        }
        if (this.redirectURI != null) {
            linkedHashMap.put("redirect_uri", this.redirectURI.toString());
        }
        if (this.scope != null) {
            linkedHashMap.put("scope", this.scope.toString());
        }
        if (this.state != null) {
            linkedHashMap.put("state", this.state.getValue());
        }
        if (this.codeChallenge != null) {
            linkedHashMap.put("code_challenge", this.codeChallenge.getValue());
            if (this.codeChallengeMethod != null) {
                linkedHashMap.put("code_challenge_method", this.codeChallengeMethod.getValue());
            }
        }
        return linkedHashMap;
    }

    public String toQueryString() {
        return URLUtils.serializeParameters((Map)this.toParameters());
    }

    public URI toURI() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The authorization endpoint URI is not specified");
        }
        StringBuilder stringBuilder = new StringBuilder(this.getEndpointURI().toString());
        stringBuilder.append('?');
        stringBuilder.append(this.toQueryString());
        try {
            return new URI(stringBuilder.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SerializeException("Couldn't append query string: " + uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
    }

    public HTTPRequest toHTTPRequest(HTTPRequest.Method method) {
        HTTPRequest hTTPRequest;
        URL uRL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        try {
            uRL = this.getEndpointURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SerializeException(malformedURLException.getMessage(), (Throwable)malformedURLException);
        }
        if (method.equals((Object)HTTPRequest.Method.GET)) {
            hTTPRequest = new HTTPRequest(HTTPRequest.Method.GET, uRL);
        } else if (method.equals((Object)HTTPRequest.Method.POST)) {
            hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, uRL);
        } else {
            throw new IllegalArgumentException("The HTTP request method must be GET or POST");
        }
        hTTPRequest.setQuery(this.toQueryString());
        return hTTPRequest;
    }

    public HTTPRequest toHTTPRequest() {
        return this.toHTTPRequest(HTTPRequest.Method.GET);
    }

    public static AuthorizationRequest parse(Map<String, String> map) throws ParseException {
        return AuthorizationRequest.parse(null, map);
    }

    public static AuthorizationRequest parse(URI uRI, Map<String, String> map) throws ParseException {
        ResponseType responseType;
        String string = map.get("client_id");
        if (StringUtils.isBlank((CharSequence)string)) {
            String string2 = "Missing \"client_id\" parameter";
            throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string2));
        }
        ClientID clientID = new ClientID(string);
        string = map.get("redirect_uri");
        URI uRI2 = null;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                uRI2 = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                String string3 = "Invalid \"redirect_uri\" parameter: " + uRISyntaxException.getMessage();
                throw new ParseException(string3, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string3), clientID, null, null, null, (Throwable)uRISyntaxException);
            }
        }
        State state = State.parse((String)map.get("state"));
        string = map.get("response_type");
        try {
            responseType = ResponseType.parse((String)string);
        }
        catch (ParseException parseException) {
            String string4 = "Missing \"response_type\" parameter";
            throw new ParseException(string4, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string4), clientID, uRI2, null, state, (Throwable)parseException);
        }
        string = map.get("response_mode");
        ResponseMode responseMode = null;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            responseMode = new ResponseMode(string);
        }
        string = map.get("scope");
        Scope scope = null;
        if (StringUtils.isNotBlank((CharSequence)string)) {
            scope = Scope.parse((String)string);
        }
        CodeChallenge codeChallenge = null;
        CodeChallengeMethod codeChallengeMethod = null;
        string = map.get("code_challenge");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            codeChallenge = CodeChallenge.parse((String)string);
        }
        if (codeChallenge != null && StringUtils.isNotBlank((CharSequence)(string = map.get("code_challenge_method")))) {
            codeChallengeMethod = CodeChallengeMethod.parse((String)string);
        }
        HashMap<String, String> hashMap = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (REGISTERED_PARAMETER_NAMES.contains(entry.getKey())) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, String>();
            }
            hashMap.put(entry.getKey(), entry.getValue());
        }
        return new AuthorizationRequest(uRI, responseType, responseMode, clientID, uRI2, scope, state, codeChallenge, codeChallengeMethod, hashMap);
    }

    public static AuthorizationRequest parse(String string) throws ParseException {
        return AuthorizationRequest.parse(null, (Map)URLUtils.parseParameters((String)string));
    }

    public static AuthorizationRequest parse(URI uRI, String string) throws ParseException {
        return AuthorizationRequest.parse((URI)uRI, (Map)URLUtils.parseParameters((String)string));
    }

    public static AuthorizationRequest parse(URI uRI) throws ParseException {
        return AuthorizationRequest.parse((URI)URIUtils.getBaseURI((URI)uRI), (Map)URLUtils.parseParameters((String)uRI.getRawQuery()));
    }

    public static AuthorizationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        String string = hTTPRequest.getQuery();
        if (string == null) {
            throw new ParseException("Missing URI query string");
        }
        try {
            return AuthorizationRequest.parse((URI)URIUtils.getBaseURI((URI)hTTPRequest.getURL().toURI()), (String)string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
        }
    }
}

