/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jwt_8_2_1.proc;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.SecurityContext;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.BadJWTException;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.ClockSkewAware;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.JWTClaimsSetVerifier;
import macromedia.externals.com.nimbusds.jwt_8_2_1.proc.JWTClaimsVerifier;
import macromedia.externals.com.nimbusds.jwt_8_2_1.util.DateUtils;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJWTClaimsVerifier<C extends SecurityContext>
implements ClockSkewAware,
JWTClaimsSetVerifier<C>,
JWTClaimsVerifier {
    public static final int DEFAULT_MAX_CLOCK_SKEW_SECONDS = 60;
    private int maxClockSkew = 60;
    private final Set<String> acceptedAudienceValues;
    private final JWTClaimsSet exactMatchClaims;
    private final Set<String> requiredClaims;
    private final Set<String> prohibitedClaims;

    public DefaultJWTClaimsVerifier() {
        this(null, null, null, null);
    }

    public DefaultJWTClaimsVerifier(JWTClaimsSet jWTClaimsSet, Set<String> set) {
        this(null, jWTClaimsSet, set, null);
    }

    public DefaultJWTClaimsVerifier(String string, JWTClaimsSet jWTClaimsSet, Set<String> set) {
        this(string != null ? Collections.singleton(string) : null, jWTClaimsSet, set, null);
    }

    public DefaultJWTClaimsVerifier(Set<String> set, JWTClaimsSet jWTClaimsSet, Set<String> set2, Set<String> set3) {
        this.acceptedAudienceValues = set != null ? Collections.unmodifiableSet(set) : null;
        this.exactMatchClaims = jWTClaimsSet != null ? jWTClaimsSet : new JWTClaimsSet.Builder().build();
        HashSet hashSet = new HashSet(this.exactMatchClaims.getClaims().keySet());
        if (this.acceptedAudienceValues != null && !this.acceptedAudienceValues.contains(null)) {
            hashSet.add("aud");
        }
        if (set2 != null) {
            hashSet.addAll(set2);
        }
        this.requiredClaims = Collections.unmodifiableSet(hashSet);
        this.prohibitedClaims = set3 != null ? Collections.unmodifiableSet(set3) : Collections.emptySet();
    }

    public Set<String> getAcceptedAudienceValues() {
        return this.acceptedAudienceValues;
    }

    public JWTClaimsSet getExactMatchClaims() {
        return this.exactMatchClaims;
    }

    public Set<String> getRequiredClaims() {
        return this.requiredClaims;
    }

    public Set<String> getProhibitedClaims() {
        return this.prohibitedClaims;
    }

    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    public void setMaxClockSkew(int n2) {
        this.maxClockSkew = n2;
    }

    public void verify(JWTClaimsSet jWTClaimsSet) throws BadJWTException {
        this.verify(jWTClaimsSet, null);
    }

    public void verify(JWTClaimsSet jWTClaimsSet, C c2) throws BadJWTException {
        Object object3;
        Object object22;
        Collection<Object> collection;
        if (this.acceptedAudienceValues != null) {
            collection = jWTClaimsSet.getAudience();
            if (collection != null && !collection.isEmpty()) {
                boolean bl2 = false;
                for (Object object22 : collection) {
                    if (!this.acceptedAudienceValues.contains(object22)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    throw new BadJWTException("JWT audience rejected: " + collection);
                }
            } else if (!this.acceptedAudienceValues.contains(null)) {
                throw new BadJWTException("JWT missing required audience");
            }
        }
        if (!jWTClaimsSet.getClaims().keySet().containsAll(this.requiredClaims)) {
            collection = new HashSet(this.requiredClaims);
            collection.removeAll(jWTClaimsSet.getClaims().keySet());
            throw new BadJWTException("JWT missing required claims: " + collection);
        }
        collection = new HashSet();
        for (Object object3 : this.prohibitedClaims) {
            if (jWTClaimsSet.getClaims().containsKey(object3)) {
                collection.add(object3);
            }
            if (collection.isEmpty()) continue;
            throw new BadJWTException("JWT has prohibited claims: " + collection);
        }
        for (Object object3 : this.exactMatchClaims.getClaims().keySet()) {
            object22 = jWTClaimsSet.getClaim((String)object3);
            if (object22.equals(this.exactMatchClaims.getClaim((String)object3))) continue;
            throw new BadJWTException("JWT \"" + (String)object3 + "\" claim doesn't match expected value: " + object22);
        }
        Date date = new Date();
        object3 = jWTClaimsSet.getExpirationTime();
        if (object3 != null && !DateUtils.isAfter((Date)object3, (Date)date, (long)this.maxClockSkew)) {
            throw new BadJWTException("Expired JWT");
        }
        object22 = jWTClaimsSet.getNotBeforeTime();
        if (object22 != null && !DateUtils.isBefore((Date)object22, (Date)date, (long)this.maxClockSkew)) {
            throw new BadJWTException("JWT before use time");
        }
    }
}

