/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jwt_8_2_1;

import java.text.ParseException;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.Payload;
import macromedia.externals.com.nimbusds.jose_8_2_1.PlainHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.PlainObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWT;
import macromedia.externals.com.nimbusds.jwt_8_2_1.JWTClaimsSet;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PlainJWT
extends PlainObject
implements JWT {
    private static final long serialVersionUID = 1L;

    public PlainJWT(JWTClaimsSet jWTClaimsSet) {
        super(new Payload(jWTClaimsSet.toJSONObject()));
    }

    public PlainJWT(PlainHeader plainHeader, JWTClaimsSet jWTClaimsSet) {
        super(plainHeader, new Payload(jWTClaimsSet.toJSONObject()));
    }

    public PlainJWT(Base64URL base64URL, Base64URL base64URL2) throws ParseException {
        super(base64URL, base64URL2);
    }

    public JWTClaimsSet getJWTClaimsSet() throws ParseException {
        JSONObject jSONObject = this.getPayload().toJSONObject();
        if (jSONObject == null) {
            throw new ParseException("Payload of unsecured JOSE object is not a valid JSON object", 0);
        }
        return JWTClaimsSet.parse((JSONObject)jSONObject);
    }

    public static PlainJWT parse(String string) throws ParseException {
        Base64URL[] base64URLArray = JOSEObject.split((String)string);
        if (!base64URLArray[2].toString().isEmpty()) {
            throw new ParseException("Unexpected third Base64URL part in the unsecured JWT object", 0);
        }
        return new PlainJWT(base64URLArray[0], base64URLArray[1]);
    }
}

