/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.util;

import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.X509CertUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;

public class X509CertChainUtils {
    public static List<Base64> toBase64List(JSONArray jSONArray) throws ParseException {
        if (jSONArray == null) {
            return null;
        }
        LinkedList<Base64> linkedList = new LinkedList<Base64>();
        for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
            Object object = jSONArray.get(i2);
            if (object == null) {
                throw new ParseException("The X.509 certificate at position " + i2 + " must not be null", 0);
            }
            if (!(object instanceof String)) {
                throw new ParseException("The X.509 certificate at position " + i2 + " must be encoded as a Base64 string", 0);
            }
            linkedList.add(new Base64((String)object));
        }
        return linkedList;
    }

    public static List<X509Certificate> parse(List<Base64> list) throws ParseException {
        if (list == null) {
            return null;
        }
        LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2) == null) continue;
            X509Certificate x509Certificate = X509CertUtils.parse((byte[])list.get(i2).decode());
            if (x509Certificate == null) {
                throw new ParseException("Invalid X.509 certificate at position " + i2, 0);
            }
            linkedList.add(x509Certificate);
        }
        return linkedList;
    }

    private X509CertChainUtils() {
    }
}

