/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.proc;

import java.security.Key;
import java.security.PublicKey;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.SecretKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.KeySourceException;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKMatcher;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKSelector;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyConverter;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.source.JWKSource;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.AbstractJWKSelectorWithSource;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWSKeySelector;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.SecurityContext;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JWSVerificationKeySelector<C extends SecurityContext>
extends AbstractJWKSelectorWithSource<C>
implements JWSKeySelector<C> {
    private final JWSAlgorithm jwsAlg;

    public JWSVerificationKeySelector(JWSAlgorithm jWSAlgorithm, JWKSource<C> jWKSource) {
        super(jWKSource);
        if (jWSAlgorithm == null) {
            throw new IllegalArgumentException("The JWS algorithm must not be null");
        }
        this.jwsAlg = jWSAlgorithm;
    }

    public JWSAlgorithm getExpectedJWSAlgorithm() {
        return this.jwsAlg;
    }

    protected JWKMatcher createJWKMatcher(JWSHeader jWSHeader) {
        if (!this.getExpectedJWSAlgorithm().equals((Object)jWSHeader.getAlgorithm())) {
            return null;
        }
        return JWKMatcher.forJWSHeader((JWSHeader)jWSHeader);
    }

    public List<Key> selectJWSKeys(JWSHeader jWSHeader, C c2) throws KeySourceException {
        if (!this.jwsAlg.equals((Object)jWSHeader.getAlgorithm())) {
            return Collections.emptyList();
        }
        JWKMatcher jWKMatcher = this.createJWKMatcher(jWSHeader);
        if (jWKMatcher == null) {
            return Collections.emptyList();
        }
        List list = this.getJWKSource().get(new JWKSelector(jWKMatcher), c2);
        LinkedList<Key> linkedList = new LinkedList<Key>();
        for (Key key : KeyConverter.toJavaKeys((List)list)) {
            if (!(key instanceof PublicKey) && !(key instanceof SecretKey)) continue;
            linkedList.add(key);
        }
        return linkedList;
    }
}

