/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.proc;

import java.security.Key;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.SecretKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEAlgorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEHeader;
import macromedia.externals.com.nimbusds.jose_8_2_1.KeySourceException;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKMatcher;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKSelector;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyConverter;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.source.JWKSource;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.AbstractJWKSelectorWithSource;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JWEKeySelector;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.SecurityContext;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JWEDecryptionKeySelector<C extends SecurityContext>
extends AbstractJWKSelectorWithSource<C>
implements JWEKeySelector<C> {
    private final JWEAlgorithm jweAlg;
    private final EncryptionMethod jweEnc;

    public JWEDecryptionKeySelector(JWEAlgorithm jWEAlgorithm, EncryptionMethod encryptionMethod, JWKSource<C> jWKSource) {
        super(jWKSource);
        if (jWEAlgorithm == null) {
            throw new IllegalArgumentException("The JWE algorithm must not be null");
        }
        this.jweAlg = jWEAlgorithm;
        if (encryptionMethod == null) {
            throw new IllegalArgumentException("The JWE encryption method must not be null");
        }
        this.jweEnc = encryptionMethod;
    }

    public JWEAlgorithm getExpectedJWEAlgorithm() {
        return this.jweAlg;
    }

    public EncryptionMethod getExpectedJWEEncryptionMethod() {
        return this.jweEnc;
    }

    protected JWKMatcher createJWKMatcher(JWEHeader jWEHeader) {
        if (!this.getExpectedJWEAlgorithm().equals((Object)jWEHeader.getAlgorithm())) {
            return null;
        }
        if (!this.getExpectedJWEEncryptionMethod().equals((Object)jWEHeader.getEncryptionMethod())) {
            return null;
        }
        return JWKMatcher.forJWEHeader((JWEHeader)jWEHeader);
    }

    public List<Key> selectJWEKeys(JWEHeader jWEHeader, C c2) throws KeySourceException {
        if (!this.jweAlg.equals((Object)jWEHeader.getAlgorithm()) || !this.jweEnc.equals((Object)jWEHeader.getEncryptionMethod())) {
            return Collections.emptyList();
        }
        JWKMatcher jWKMatcher = this.createJWKMatcher(jWEHeader);
        List list = this.getJWKSource().get(new JWKSelector(jWKMatcher), c2);
        LinkedList<Key> linkedList = new LinkedList<Key>();
        for (Key key : KeyConverter.toJavaKeys((List)list)) {
            if (!(key instanceof PrivateKey) && !(key instanceof SecretKey)) continue;
            linkedList.add(key);
        }
        return linkedList;
    }
}

