/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.proc;

import java.net.URI;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.EncryptionMethod;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWEObject;
import macromedia.externals.com.nimbusds.jose_8_2_1.JWSObject;

public class JOSEMatcher {
    private final Set<Class<? extends JOSEObject>> classes;
    private final Set<Algorithm> algs;
    private final Set<EncryptionMethod> encs;
    private final Set<URI> jkus;
    private final Set<String> kids;

    public JOSEMatcher(Set<Class<? extends JOSEObject>> set, Set<Algorithm> set2, Set<EncryptionMethod> set3, Set<URI> set4, Set<String> set5) {
        this.classes = set;
        this.algs = set2;
        this.encs = set3;
        this.jkus = set4;
        this.kids = set5;
    }

    public Set<Class<? extends JOSEObject>> getJOSEClasses() {
        return this.classes;
    }

    public Set<Algorithm> getAlgorithms() {
        return this.algs;
    }

    public Set<EncryptionMethod> getEncryptionMethods() {
        return this.encs;
    }

    public Set<URI> getJWKURLs() {
        return this.jkus;
    }

    public Set<String> getKeyIDs() {
        return this.kids;
    }

    public boolean matches(JOSEObject jOSEObject) {
        String string;
        URI uRI;
        if (this.classes != null) {
            boolean bl2 = false;
            for (Class clazz : this.classes) {
                if (clazz == null || !clazz.isInstance(jOSEObject)) continue;
                bl2 = true;
            }
            if (!bl2) {
                return false;
            }
        }
        if (this.algs != null && !this.algs.contains(jOSEObject.getHeader().getAlgorithm())) {
            return false;
        }
        if (this.encs != null) {
            if (!(jOSEObject instanceof JWEObject)) {
                return false;
            }
            JWEObject jWEObject = (JWEObject)jOSEObject;
            if (!this.encs.contains(jWEObject.getHeader().getEncryptionMethod())) {
                return false;
            }
        }
        if (this.jkus != null && !this.jkus.contains(uRI = jOSEObject instanceof JWSObject ? ((JWSObject)jOSEObject).getHeader().getJWKURL() : (jOSEObject instanceof JWEObject ? ((JWEObject)jOSEObject).getHeader().getJWKURL() : null))) {
            return false;
        }
        return this.kids == null || this.kids.contains(string = jOSEObject instanceof JWSObject ? ((JWSObject)jOSEObject).getHeader().getKeyID() : (jOSEObject instanceof JWEObject ? ((JWEObject)jOSEObject).getHeader().getKeyID() : null));
    }
}

