/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.proc;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEObjectType;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.BadJOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.JOSEObjectTypeVerifier;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.SecurityContext;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultJOSEObjectTypeVerifier<C extends SecurityContext>
implements JOSEObjectTypeVerifier<C> {
    private final Set<JOSEObjectType> allowedTypes;
    public static final DefaultJOSEObjectTypeVerifier JOSE = new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{JOSEObjectType.JOSE, null});
    public static final DefaultJOSEObjectTypeVerifier JWT = new DefaultJOSEObjectTypeVerifier(new JOSEObjectType[]{JOSEObjectType.JWT, null});

    public DefaultJOSEObjectTypeVerifier() {
        this.allowedTypes = Collections.singleton(null);
    }

    public DefaultJOSEObjectTypeVerifier(Set<JOSEObjectType> set) {
        if (set == null || set.isEmpty()) {
            throw new IllegalArgumentException("The allowed types must not be null or empty");
        }
        this.allowedTypes = set;
    }

    public DefaultJOSEObjectTypeVerifier(JOSEObjectType ... jOSEObjectTypeArray) {
        if (jOSEObjectTypeArray == null || jOSEObjectTypeArray.length == 0) {
            throw new IllegalArgumentException("The allowed types must not be null or empty");
        }
        this.allowedTypes = new HashSet<JOSEObjectType>(Arrays.asList(jOSEObjectTypeArray));
    }

    public Set<JOSEObjectType> getAllowedTypes() {
        return this.allowedTypes;
    }

    public void verify(JOSEObjectType jOSEObjectType, C c2) throws BadJOSEException {
        if (jOSEObjectType == null && !this.allowedTypes.contains(null)) {
            throw new BadJOSEException("Required JOSE header \"typ\" (type) parameter is missing");
        }
        if (!this.allowedTypes.contains(jOSEObjectType)) {
            throw new BadJOSEException("JOSE header \"typ\" (type) \"" + jOSEObjectType + "\" not allowed");
        }
    }
}

