/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk.source;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.RemoteKeySourceException;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKMatcher;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKSelector;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKSet;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.source.DefaultJWKSetCache;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.source.JWKSetCache;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.source.JWKSource;
import macromedia.externals.com.nimbusds.jose_8_2_1.proc.SecurityContext;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.DefaultResourceRetriever;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Resource;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ResourceRetriever;
import net.jcip.annotations.ThreadSafe;

/*
 * Exception performing whole class analysis ignored.
 */
@ThreadSafe
public class RemoteJWKSet<C extends SecurityContext>
implements JWKSource<C> {
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 500;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 500;
    public static final int DEFAULT_HTTP_SIZE_LIMIT = 51200;
    private final URL jwkSetURL;
    private final JWKSetCache jwkSetCache;
    private final ResourceRetriever jwkSetRetriever;

    public RemoteJWKSet(URL uRL) {
        this(uRL, null);
    }

    public RemoteJWKSet(URL uRL, ResourceRetriever resourceRetriever) {
        this(uRL, resourceRetriever, null);
    }

    public RemoteJWKSet(URL uRL, ResourceRetriever resourceRetriever, JWKSetCache jWKSetCache) {
        if (uRL == null) {
            throw new IllegalArgumentException("The JWK set URL must not be null");
        }
        this.jwkSetURL = uRL;
        this.jwkSetRetriever = resourceRetriever != null ? resourceRetriever : new DefaultResourceRetriever(500, 500, 51200);
        this.jwkSetCache = jWKSetCache != null ? jWKSetCache : new DefaultJWKSetCache();
    }

    private JWKSet updateJWKSetFromURL() throws RemoteKeySourceException {
        JWKSet jWKSet;
        Resource resource;
        try {
            resource = this.jwkSetRetriever.retrieveResource(this.jwkSetURL);
        }
        catch (IOException iOException) {
            throw new RemoteKeySourceException("Couldn't retrieve remote JWK set: " + iOException.getMessage(), (Throwable)iOException);
        }
        try {
            jWKSet = JWKSet.parse((String)resource.getContent());
        }
        catch (ParseException parseException) {
            throw new RemoteKeySourceException("Couldn't parse remote JWK set: " + parseException.getMessage(), (Throwable)parseException);
        }
        this.jwkSetCache.put(jWKSet);
        return jWKSet;
    }

    public URL getJWKSetURL() {
        return this.jwkSetURL;
    }

    public ResourceRetriever getResourceRetriever() {
        return this.jwkSetRetriever;
    }

    public JWKSetCache getJWKSetCache() {
        return this.jwkSetCache;
    }

    public JWKSet getCachedJWKSet() {
        return this.jwkSetCache.get();
    }

    protected static String getFirstSpecifiedKeyID(JWKMatcher jWKMatcher) {
        Set set = jWKMatcher.getKeyIDs();
        if (set == null || set.isEmpty()) {
            return null;
        }
        for (String string : set) {
            if (string == null) continue;
            return string;
        }
        return null;
    }

    public List<JWK> get(JWKSelector jWKSelector, C c2) throws RemoteKeySourceException {
        List list;
        JWKSet jWKSet = this.jwkSetCache.get();
        if (jWKSet == null) {
            jWKSet = this.updateJWKSetFromURL();
        }
        if (!(list = jWKSelector.select(jWKSet)).isEmpty()) {
            return list;
        }
        String string = RemoteJWKSet.getFirstSpecifiedKeyID((JWKMatcher)jWKSelector.getMatcher());
        if (string == null) {
            return Collections.emptyList();
        }
        if (jWKSet.getKeyByKeyId(string) != null) {
            return Collections.emptyList();
        }
        jWKSet = this.updateJWKSetFromURL();
        if (jWKSet == null) {
            return Collections.emptyList();
        }
        return jWKSelector.select(jWKSet);
    }
}

