/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk.source;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKSet;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.source.JWKSetCache;

public class DefaultJWKSetCache
implements JWKSetCache {
    public static final long DEFAULT_LIFESPAN_MINUTES = 5L;
    private final long lifespan;
    private final TimeUnit timeUnit;
    private long putTimestamp = -1L;
    private JWKSet jwkSet;

    public DefaultJWKSetCache() {
        this(5L, TimeUnit.MINUTES);
    }

    public DefaultJWKSetCache(long l2, TimeUnit timeUnit) {
        this.lifespan = l2;
        if (l2 > -1L && timeUnit == null) {
            throw new IllegalArgumentException("A time unit must be specified for non-negative lifespans");
        }
        this.timeUnit = timeUnit;
    }

    public void put(JWKSet jWKSet) {
        this.jwkSet = jWKSet;
        this.putTimestamp = jWKSet != null ? new Date().getTime() : -1L;
    }

    public JWKSet get() {
        if (this.isExpired()) {
            this.jwkSet = null;
        }
        return this.jwkSet;
    }

    public long getPutTimestamp() {
        return this.putTimestamp;
    }

    public boolean isExpired() {
        return this.putTimestamp > -1L && this.lifespan > -1L && new Date().getTime() > this.putTimestamp + TimeUnit.MILLISECONDS.convert(this.lifespan, this.timeUnit);
    }

    public long getLifespan(TimeUnit timeUnit) {
        if (this.lifespan < 0L) {
            return this.lifespan;
        }
        return timeUnit.convert(this.lifespan, timeUnit);
    }
}

