/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.com.nimbusds.jose_8_2_1.jwk;

import java.math.BigInteger;
import java.net.URI;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAMultiPrimePrivateCrtKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import macromedia.externals.com.nimbusds.jose_8_2_1.Algorithm;
import macromedia.externals.com.nimbusds.jose_8_2_1.JOSEException;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.AsymmetricJWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWK;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.JWKMetadata;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyOperation;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyType;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.KeyUse;
import macromedia.externals.com.nimbusds.jose_8_2_1.jwk.RSAKey;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.Base64URL;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.ByteUtils;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.IntegerOverflowException;
import macromedia.externals.com.nimbusds.jose_8_2_1.util.JSONObjectUtils;
import macromedia.externals.net.minidev.json_1_3_1.JSONArray;
import macromedia.externals.net.minidev.json_1_3_1.JSONObject;
import net.jcip.annotations.Immutable;

/*
 * Exception performing whole class analysis ignored.
 */
@Immutable
public final class RSAKey
extends JWK
implements AsymmetricJWK {
    private static final long serialVersionUID = 1L;
    private final Base64URL n;
    private final Base64URL e;
    private final Base64URL d;
    private final Base64URL p;
    private final Base64URL q;
    private final Base64URL dp;
    private final Base64URL dq;
    private final Base64URL qi;
    private final List<OtherPrimesInfo> oth;
    private final PrivateKey privateKey;

    public RSAKey(Base64URL base64URL, Base64URL base64URL2, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, KeyStore keyStore) {
        this(base64URL, base64URL2, null, null, null, null, null, null, null, null, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, keyStore);
    }

    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL4, Base64URL base64URL5, List<Base64> list, KeyStore keyStore) {
        this(base64URL, base64URL2, base64URL3, null, null, null, null, null, null, null, keyUse, set, algorithm, string, uRI, base64URL4, base64URL5, list, keyStore);
        if (base64URL3 == null) {
            throw new IllegalArgumentException("The private exponent must not be null");
        }
    }

    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5, Base64URL base64URL6, Base64URL base64URL7, List<OtherPrimesInfo> list, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL8, Base64URL base64URL9, List<Base64> list2, KeyStore keyStore) {
        this(base64URL, base64URL2, null, base64URL3, base64URL4, base64URL5, base64URL6, base64URL7, list, null, keyUse, set, algorithm, string, uRI, base64URL8, base64URL9, list2, keyStore);
        if (base64URL3 == null) {
            throw new IllegalArgumentException("The first prime factor must not be null");
        }
        if (base64URL4 == null) {
            throw new IllegalArgumentException("The second prime factor must not be null");
        }
        if (base64URL5 == null) {
            throw new IllegalArgumentException("The first factor CRT exponent must not be null");
        }
        if (base64URL6 == null) {
            throw new IllegalArgumentException("The second factor CRT exponent must not be null");
        }
        if (base64URL7 == null) {
            throw new IllegalArgumentException("The first CRT coefficient must not be null");
        }
    }

    @Deprecated
    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5, Base64URL base64URL6, Base64URL base64URL7, Base64URL base64URL8, List<OtherPrimesInfo> list, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL9, Base64URL base64URL10, List<Base64> list2) {
        this(base64URL, base64URL2, base64URL3, base64URL4, base64URL5, base64URL6, base64URL7, base64URL8, list, null, keyUse, set, algorithm, string, uRI, base64URL9, base64URL10, list2, null);
    }

    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5, Base64URL base64URL6, Base64URL base64URL7, Base64URL base64URL8, List<OtherPrimesInfo> list, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL9, Base64URL base64URL10, List<Base64> list2, KeyStore keyStore) {
        super(KeyType.RSA, keyUse, set, algorithm, string, uRI, base64URL9, base64URL10, list2, keyStore);
        if (base64URL == null) {
            throw new IllegalArgumentException("The modulus value must not be null");
        }
        this.n = base64URL;
        if (base64URL2 == null) {
            throw new IllegalArgumentException("The public exponent value must not be null");
        }
        this.e = base64URL2;
        if (this.getParsedX509CertChain() != null && !this.matches((X509Certificate)this.getParsedX509CertChain().get(0))) {
            throw new IllegalArgumentException("The public subject key info of the first X.509 certificate in the chain must match the JWK type and public parameters");
        }
        this.d = base64URL3;
        if (base64URL4 != null && base64URL5 != null && base64URL6 != null && base64URL7 != null && base64URL8 != null) {
            this.p = base64URL4;
            this.q = base64URL5;
            this.dp = base64URL6;
            this.dq = base64URL7;
            this.qi = base64URL8;
            this.oth = list != null ? Collections.unmodifiableList(list) : Collections.emptyList();
        } else if (base64URL4 == null && base64URL5 == null && base64URL6 == null && base64URL7 == null && base64URL8 == null && list == null) {
            this.p = null;
            this.q = null;
            this.dp = null;
            this.dq = null;
            this.qi = null;
            this.oth = Collections.emptyList();
        } else {
            if (base64URL4 != null || base64URL5 != null || base64URL6 != null || base64URL7 != null || base64URL8 != null) {
                if (base64URL4 == null) {
                    throw new IllegalArgumentException("Incomplete second private (CRT) representation: The first prime factor must not be null");
                }
                if (base64URL5 == null) {
                    throw new IllegalArgumentException("Incomplete second private (CRT) representation: The second prime factor must not be null");
                }
                if (base64URL6 == null) {
                    throw new IllegalArgumentException("Incomplete second private (CRT) representation: The first factor CRT exponent must not be null");
                }
                if (base64URL7 == null) {
                    throw new IllegalArgumentException("Incomplete second private (CRT) representation: The second factor CRT exponent must not be null");
                }
                throw new IllegalArgumentException("Incomplete second private (CRT) representation: The first CRT coefficient must not be null");
            }
            this.p = null;
            this.q = null;
            this.dp = null;
            this.dq = null;
            this.qi = null;
            this.oth = Collections.emptyList();
        }
        this.privateKey = privateKey;
    }

    public RSAKey(RSAPublicKey rSAPublicKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(Base64URL.encode((BigInteger)rSAPublicKey.getModulus()), Base64URL.encode((BigInteger)rSAPublicKey.getPublicExponent()), keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, keyStore);
    }

    public RSAKey(RSAPublicKey rSAPublicKey, RSAPrivateKey rSAPrivateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(Base64URL.encode((BigInteger)rSAPublicKey.getModulus()), Base64URL.encode((BigInteger)rSAPublicKey.getPublicExponent()), Base64URL.encode((BigInteger)rSAPrivateKey.getPrivateExponent()), keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, keyStore);
    }

    public RSAKey(RSAPublicKey rSAPublicKey, RSAPrivateCrtKey rSAPrivateCrtKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(Base64URL.encode((BigInteger)rSAPublicKey.getModulus()), Base64URL.encode((BigInteger)rSAPublicKey.getPublicExponent()), Base64URL.encode((BigInteger)rSAPrivateCrtKey.getPrivateExponent()), Base64URL.encode((BigInteger)rSAPrivateCrtKey.getPrimeP()), Base64URL.encode((BigInteger)rSAPrivateCrtKey.getPrimeQ()), Base64URL.encode((BigInteger)rSAPrivateCrtKey.getPrimeExponentP()), Base64URL.encode((BigInteger)rSAPrivateCrtKey.getPrimeExponentQ()), Base64URL.encode((BigInteger)rSAPrivateCrtKey.getCrtCoefficient()), null, null, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, keyStore);
    }

    public RSAKey(RSAPublicKey rSAPublicKey, RSAMultiPrimePrivateCrtKey rSAMultiPrimePrivateCrtKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(Base64URL.encode((BigInteger)rSAPublicKey.getModulus()), Base64URL.encode((BigInteger)rSAPublicKey.getPublicExponent()), Base64URL.encode((BigInteger)rSAMultiPrimePrivateCrtKey.getPrivateExponent()), Base64URL.encode((BigInteger)rSAMultiPrimePrivateCrtKey.getPrimeP()), Base64URL.encode((BigInteger)rSAMultiPrimePrivateCrtKey.getPrimeQ()), Base64URL.encode((BigInteger)rSAMultiPrimePrivateCrtKey.getPrimeExponentP()), Base64URL.encode((BigInteger)rSAMultiPrimePrivateCrtKey.getPrimeExponentQ()), Base64URL.encode((BigInteger)rSAMultiPrimePrivateCrtKey.getCrtCoefficient()), OtherPrimesInfo.toList((RSAOtherPrimeInfo[])rSAMultiPrimePrivateCrtKey.getOtherPrimeInfo()), null, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, keyStore);
    }

    public RSAKey(RSAPublicKey rSAPublicKey, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(Base64URL.encode((BigInteger)rSAPublicKey.getModulus()), Base64URL.encode((BigInteger)rSAPublicKey.getPublicExponent()), null, null, null, null, null, null, null, privateKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, keyStore);
    }

    public Base64URL getModulus() {
        return this.n;
    }

    public Base64URL getPublicExponent() {
        return this.e;
    }

    public Base64URL getPrivateExponent() {
        return this.d;
    }

    public Base64URL getFirstPrimeFactor() {
        return this.p;
    }

    public Base64URL getSecondPrimeFactor() {
        return this.q;
    }

    public Base64URL getFirstFactorCRTExponent() {
        return this.dp;
    }

    public Base64URL getSecondFactorCRTExponent() {
        return this.dq;
    }

    public Base64URL getFirstCRTCoefficient() {
        return this.qi;
    }

    public List<OtherPrimesInfo> getOtherPrimes() {
        return this.oth;
    }

    public RSAPublicKey toRSAPublicKey() throws JOSEException {
        BigInteger bigInteger = this.n.decodeToBigInteger();
        BigInteger bigInteger2 = this.e.decodeToBigInteger();
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
    }

    public RSAPrivateKey toRSAPrivateKey() throws JOSEException {
        Object object;
        RSAPrivateKeySpec rSAPrivateKeySpec;
        if (this.d == null) {
            return null;
        }
        BigInteger bigInteger = this.n.decodeToBigInteger();
        BigInteger bigInteger2 = this.d.decodeToBigInteger();
        if (this.p == null) {
            rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger, bigInteger2);
        } else {
            object = this.e.decodeToBigInteger();
            BigInteger bigInteger3 = this.p.decodeToBigInteger();
            BigInteger bigInteger4 = this.q.decodeToBigInteger();
            BigInteger bigInteger5 = this.dp.decodeToBigInteger();
            BigInteger bigInteger6 = this.dq.decodeToBigInteger();
            BigInteger bigInteger7 = this.qi.decodeToBigInteger();
            if (this.oth != null && !this.oth.isEmpty()) {
                RSAOtherPrimeInfo[] rSAOtherPrimeInfoArray = new RSAOtherPrimeInfo[this.oth.size()];
                for (int i2 = 0; i2 < this.oth.size(); ++i2) {
                    OtherPrimesInfo otherPrimesInfo = (OtherPrimesInfo)this.oth.get(i2);
                    BigInteger bigInteger8 = otherPrimesInfo.getPrimeFactor().decodeToBigInteger();
                    BigInteger bigInteger9 = otherPrimesInfo.getFactorCRTExponent().decodeToBigInteger();
                    BigInteger bigInteger10 = otherPrimesInfo.getFactorCRTCoefficient().decodeToBigInteger();
                    rSAOtherPrimeInfoArray[i2] = new RSAOtherPrimeInfo(bigInteger8, bigInteger9, bigInteger10);
                }
                rSAPrivateKeySpec = new RSAMultiPrimePrivateCrtKeySpec(bigInteger, (BigInteger)object, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, rSAOtherPrimeInfoArray);
            } else {
                rSAPrivateKeySpec = new RSAPrivateCrtKeySpec(bigInteger, (BigInteger)object, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7);
            }
        }
        try {
            object = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)((KeyFactory)object).generatePrivate(rSAPrivateKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
    }

    public PublicKey toPublicKey() throws JOSEException {
        return this.toRSAPublicKey();
    }

    public PrivateKey toPrivateKey() throws JOSEException {
        RSAPrivateKey rSAPrivateKey = this.toRSAPrivateKey();
        if (rSAPrivateKey != null) {
            return rSAPrivateKey;
        }
        return this.privateKey;
    }

    public KeyPair toKeyPair() throws JOSEException {
        return new KeyPair(this.toRSAPublicKey(), this.toPrivateKey());
    }

    public boolean matches(X509Certificate x509Certificate) {
        RSAPublicKey rSAPublicKey;
        try {
            rSAPublicKey = (RSAPublicKey)((X509Certificate)this.getParsedX509CertChain().get(0)).getPublicKey();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.e.decodeToBigInteger().equals(rSAPublicKey.getPublicExponent())) {
            return false;
        }
        return this.n.decodeToBigInteger().equals(rSAPublicKey.getModulus());
    }

    public LinkedHashMap<String, ?> getRequiredParams() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("e", this.e.toString());
        linkedHashMap.put("kty", this.getKeyType().getValue());
        linkedHashMap.put("n", this.n.toString());
        return linkedHashMap;
    }

    public boolean isPrivate() {
        return this.d != null || this.p != null || this.privateKey != null;
    }

    public int size() {
        try {
            return ByteUtils.safeBitLength((byte[])this.n.decode());
        }
        catch (IntegerOverflowException integerOverflowException) {
            throw new ArithmeticException(integerOverflowException.getMessage());
        }
    }

    public RSAKey toPublicJWK() {
        return new RSAKey(this.getModulus(), this.getPublicExponent(), this.getKeyUse(), this.getKeyOperations(), this.getAlgorithm(), this.getKeyID(), this.getX509CertURL(), this.getX509CertThumbprint(), this.getX509CertSHA256Thumbprint(), this.getX509CertChain(), this.getKeyStore());
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put((Object)"n", (Object)this.n.toString());
        jSONObject.put((Object)"e", (Object)this.e.toString());
        if (this.d != null) {
            jSONObject.put((Object)"d", (Object)this.d.toString());
        }
        if (this.p != null) {
            jSONObject.put((Object)"p", (Object)this.p.toString());
        }
        if (this.q != null) {
            jSONObject.put((Object)"q", (Object)this.q.toString());
        }
        if (this.dp != null) {
            jSONObject.put((Object)"dp", (Object)this.dp.toString());
        }
        if (this.dq != null) {
            jSONObject.put((Object)"dq", (Object)this.dq.toString());
        }
        if (this.qi != null) {
            jSONObject.put((Object)"qi", (Object)this.qi.toString());
        }
        if (this.oth != null && !this.oth.isEmpty()) {
            JSONArray jSONArray = new JSONArray();
            for (OtherPrimesInfo otherPrimesInfo : this.oth) {
                JSONObject jSONObject2 = new JSONObject();
                jSONObject2.put((Object)"r", (Object)OtherPrimesInfo.access$1000((OtherPrimesInfo)otherPrimesInfo).toString());
                jSONObject2.put((Object)"d", (Object)OtherPrimesInfo.access$1100((OtherPrimesInfo)otherPrimesInfo).toString());
                jSONObject2.put((Object)"t", (Object)OtherPrimesInfo.access$1200((OtherPrimesInfo)otherPrimesInfo).toString());
                jSONArray.add((Object)jSONObject2);
            }
            jSONObject.put((Object)"oth", (Object)jSONArray);
        }
        return jSONObject;
    }

    public static RSAKey parse(String string) throws ParseException {
        return RSAKey.parse((JSONObject)JSONObjectUtils.parse((String)string));
    }

    public static RSAKey parse(JSONObject jSONObject) throws ParseException {
        Base64URL base64URL = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"n"));
        Base64URL base64URL2 = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"e"));
        KeyType keyType = KeyType.parse((String)JSONObjectUtils.getString((JSONObject)jSONObject, (String)"kty"));
        if (keyType != KeyType.RSA) {
            throw new ParseException("The key type \"kty\" must be RSA", 0);
        }
        Base64URL base64URL3 = null;
        if (jSONObject.containsKey((Object)"d")) {
            base64URL3 = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"d"));
        }
        Base64URL base64URL4 = null;
        if (jSONObject.containsKey((Object)"p")) {
            base64URL4 = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"p"));
        }
        Base64URL base64URL5 = null;
        if (jSONObject.containsKey((Object)"q")) {
            base64URL5 = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"q"));
        }
        Base64URL base64URL6 = null;
        if (jSONObject.containsKey((Object)"dp")) {
            base64URL6 = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"dp"));
        }
        Base64URL base64URL7 = null;
        if (jSONObject.containsKey((Object)"dq")) {
            base64URL7 = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"dq"));
        }
        Base64URL base64URL8 = null;
        if (jSONObject.containsKey((Object)"qi")) {
            base64URL8 = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject, (String)"qi"));
        }
        ArrayList<OtherPrimesInfo> arrayList = null;
        if (jSONObject.containsKey((Object)"oth")) {
            JSONArray jSONArray = JSONObjectUtils.getJSONArray((JSONObject)jSONObject, (String)"oth");
            arrayList = new ArrayList<OtherPrimesInfo>(jSONArray.size());
            for (Object e2 : jSONArray) {
                if (!(e2 instanceof JSONObject)) continue;
                JSONObject jSONObject2 = (JSONObject)e2;
                Base64URL base64URL9 = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject2, (String)"r"));
                Base64URL base64URL10 = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject2, (String)"dq"));
                Base64URL base64URL11 = new Base64URL(JSONObjectUtils.getString((JSONObject)jSONObject2, (String)"t"));
                OtherPrimesInfo otherPrimesInfo = new OtherPrimesInfo(base64URL9, base64URL10, base64URL11);
                arrayList.add(otherPrimesInfo);
            }
        }
        try {
            return new RSAKey(base64URL, base64URL2, base64URL3, base64URL4, base64URL5, base64URL6, base64URL7, base64URL8, arrayList, null, JWKMetadata.parseKeyUse((JSONObject)jSONObject), JWKMetadata.parseKeyOperations((JSONObject)jSONObject), JWKMetadata.parseAlgorithm((JSONObject)jSONObject), JWKMetadata.parseKeyID((JSONObject)jSONObject), JWKMetadata.parseX509CertURL((JSONObject)jSONObject), JWKMetadata.parseX509CertThumbprint((JSONObject)jSONObject), JWKMetadata.parseX509CertSHA256Thumbprint((JSONObject)jSONObject), JWKMetadata.parseX509CertChain((JSONObject)jSONObject), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), 0);
        }
    }

    public static RSAKey parse(X509Certificate x509Certificate) throws JOSEException {
        if (!(x509Certificate.getPublicKey() instanceof RSAPublicKey)) {
            throw new JOSEException("The public key of the X.509 certificate is not RSA");
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)x509Certificate.getPublicKey();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return new Builder(rSAPublicKey).keyUse(KeyUse.from((X509Certificate)x509Certificate)).keyID(x509Certificate.getSerialNumber().toString(10)).x509CertChain(Collections.singletonList(Base64.encode((byte[])x509Certificate.getEncoded()))).x509CertSHA256Thumbprint(Base64URL.encode((byte[])messageDigest.digest(x509Certificate.getEncoded()))).build();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException("Couldn't encode x5t parameter: " + noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new JOSEException("Couldn't encode x5c parameter: " + certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
        }
    }

    public static RSAKey load(KeyStore keyStore, String string, char[] cArray) throws KeyStoreException, JOSEException {
        Key key;
        Certificate certificate = keyStore.getCertificate(string);
        if (certificate == null || !(certificate instanceof X509Certificate)) {
            return null;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (!(x509Certificate.getPublicKey() instanceof RSAPublicKey)) {
            throw new JOSEException("Couldn't load RSA JWK: The key algorithm is not RSA");
        }
        RSAKey rSAKey = RSAKey.parse((X509Certificate)x509Certificate);
        rSAKey = new Builder(rSAKey).keyID(string).keyStore(keyStore).build();
        try {
            key = keyStore.getKey(string, cArray);
        }
        catch (NoSuchAlgorithmException | UnrecoverableKeyException generalSecurityException) {
            throw new JOSEException("Couldn't retrieve private RSA key (bad pin?): " + generalSecurityException.getMessage(), (Throwable)generalSecurityException);
        }
        if (key instanceof RSAPrivateKey) {
            return new Builder(rSAKey).privateKey((RSAPrivateKey)key).build();
        }
        if (key instanceof PrivateKey && "RSA".equalsIgnoreCase(key.getAlgorithm())) {
            return new Builder(rSAKey).privateKey((PrivateKey)key).build();
        }
        return rSAKey;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RSAKey)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RSAKey rSAKey = (RSAKey)object;
        return Objects.equals(this.n, rSAKey.n) && Objects.equals(this.e, rSAKey.e) && Objects.equals(this.d, rSAKey.d) && Objects.equals(this.p, rSAKey.p) && Objects.equals(this.q, rSAKey.q) && Objects.equals(this.dp, rSAKey.dp) && Objects.equals(this.dq, rSAKey.dq) && Objects.equals(this.qi, rSAKey.qi) && Objects.equals(this.oth, rSAKey.oth) && Objects.equals(this.privateKey, rSAKey.privateKey);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.n, this.e, this.d, this.p, this.q, this.dp, this.dq, this.qi, this.oth, this.privateKey);
    }

    static /* synthetic */ Base64URL access$000(RSAKey rSAKey) {
        return rSAKey.n;
    }

    static /* synthetic */ Base64URL access$100(RSAKey rSAKey) {
        return rSAKey.e;
    }

    static /* synthetic */ Base64URL access$200(RSAKey rSAKey) {
        return rSAKey.d;
    }

    static /* synthetic */ Base64URL access$300(RSAKey rSAKey) {
        return rSAKey.p;
    }

    static /* synthetic */ Base64URL access$400(RSAKey rSAKey) {
        return rSAKey.q;
    }

    static /* synthetic */ Base64URL access$500(RSAKey rSAKey) {
        return rSAKey.dp;
    }

    static /* synthetic */ Base64URL access$600(RSAKey rSAKey) {
        return rSAKey.dq;
    }

    static /* synthetic */ Base64URL access$700(RSAKey rSAKey) {
        return rSAKey.qi;
    }

    static /* synthetic */ List access$800(RSAKey rSAKey) {
        return rSAKey.oth;
    }

    static /* synthetic */ PrivateKey access$900(RSAKey rSAKey) {
        return rSAKey.privateKey;
    }
}

